/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.BooleanOperations;
import org.ow2.opensuit.cel.impl.misc.NumberOperations;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstRightValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstBinaryOperation
extends AstRightValue {
    private ITypeConverter converter;
    private final Operator operator;
    private final AstNode left;
    private final AstNode right;
    private Class<?> resultType;
    public static final Operator ADD = new NumberOperator(){

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return NumberOperations.add(converter, o1, o2);
        }

        @Override
        public Class<?> getType(Class<?> t1, Class<?> t2) {
            return NumberOperations.getAddReturnType(t1, t2);
        }

        public String toString() {
            return "+";
        }
    };
    public static final Operator AND = new BooleanOperator(){

        @Override
        public boolean checkTypes(ITypeConverter converter, Class<?> t1, Class<?> t2) {
            return BooleanOperations.checkBooleanTypes(converter, t1, t2);
        }

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.and(converter, o1, o2);
        }

        public String toString() {
            return "&&";
        }
    };
    public static final Operator DIV = new NumberOperator(){

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return NumberOperations.div(converter, o1, o2);
        }

        @Override
        public Class<?> getType(Class<?> t1, Class<?> t2) {
            return NumberOperations.getDivReturnType(t1, t2);
        }

        public String toString() {
            return "/";
        }
    };
    public static final Operator EQ = new BooleanOperator(){

        @Override
        public boolean checkTypes(ITypeConverter converter, Class<?> t1, Class<?> t2) {
            return true;
        }

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.eq(converter, o1, o2);
        }

        public String toString() {
            return "==";
        }
    };
    public static final Operator GE = new ComparisionOperator(){

        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.ge(converter, o1, o2);
        }

        public String toString() {
            return ">=";
        }
    };
    public static final Operator GT = new ComparisionOperator(){

        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.gt(converter, o1, o2);
        }

        public String toString() {
            return ">";
        }
    };
    public static final Operator LE = new ComparisionOperator(){

        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.le(converter, o1, o2);
        }

        public String toString() {
            return "<=";
        }
    };
    public static final Operator LT = new ComparisionOperator(){

        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.lt(converter, o1, o2);
        }

        public String toString() {
            return "<";
        }
    };
    public static final Operator MOD = new NumberOperator(){

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return NumberOperations.mod(converter, o1, o2);
        }

        @Override
        public Class<?> getType(Class<?> t1, Class<?> t2) {
            return NumberOperations.getModReturnType(t1, t2);
        }

        public String toString() {
            return "%";
        }
    };
    public static final Operator MUL = new NumberOperator(){

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return NumberOperations.mul(converter, o1, o2);
        }

        @Override
        public Class<?> getType(Class<?> t1, Class<?> t2) {
            return NumberOperations.getMulReturnType(t1, t2);
        }

        public String toString() {
            return "*";
        }
    };
    public static final Operator NE = new BooleanOperator(){

        @Override
        public boolean checkTypes(ITypeConverter converter, Class<?> t1, Class<?> t2) {
            return true;
        }

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.ne(converter, o1, o2);
        }

        public String toString() {
            return "!=";
        }
    };
    public static final Operator OR = new BooleanOperator(){

        @Override
        public boolean checkTypes(ITypeConverter converter, Class<?> t1, Class<?> t2) {
            return BooleanOperations.checkBooleanTypes(converter, t1, t2);
        }

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return BooleanOperations.or(converter, o1, o2);
        }

        public String toString() {
            return "||";
        }
    };
    public static final Operator SUB = new NumberOperator(){

        @Override
        public Object apply(ITypeConverter converter, Object o1, Object o2) throws Exception {
            return NumberOperations.sub(converter, o1, o2);
        }

        @Override
        public Class<?> getType(Class<?> t1, Class<?> t2) {
            return NumberOperations.getSubReturnType(t1, t2);
        }

        public String toString() {
            return "-";
        }
    };

    public AstBinaryOperation(int position, AstNode left, AstNode right, Operator operator) {
        super(position);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        this.converter = converter;
        boolean compiled = this.left.compile(converter, ctx, messages);
        boolean bl = compiled = this.right.compile(converter, ctx, messages) && compiled;
        if (!compiled) {
            return false;
        }
        if (!this.operator.checkTypes(converter, this.left.getType(), this.right.getType())) {
            messages.addMessage(this, 2, "Invalid operand types");
            return false;
        }
        this.resultType = this.operator.getType(this.left.getType(), this.right.getType());
        return true;
    }

    @Override
    public Class<?> getType() {
        return this.resultType;
    }

    @Override
    public Type getGenericType() {
        return this.resultType;
    }

    @Override
    public boolean isStaticValue() {
        return this.left.isStaticValue() && this.right.isStaticValue();
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws Exception {
        try {
            return this.operator.apply(this.converter, this.left.invoke(context), this.right.invoke(context));
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
        }
    }

    @Override
    protected void appendExpressionString(StringBuilder b) {
        this.left.appendExpressionString(b);
        b.append(' ');
        b.append(this.operator);
        b.append(' ');
        this.right.appendExpressionString(b);
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendTypeExpr(builder, this.getGenericType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NumberOperator
    implements Operator {
        @Override
        public boolean checkTypes(ITypeConverter converter, Class<?> t1, Class<?> t2) {
            return NumberOperations.checkTypes(converter, t1, t2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ComparisionOperator
    implements Operator {
        @Override
        public boolean checkTypes(ITypeConverter converter, Class<?> t1, Class<?> t2) {
            return BooleanOperations.checkComparisonTypes(converter, t1, t2);
        }

        @Override
        public Class<?> getType(Class<?> arg0, Class<?> arg1) {
            return Boolean.TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BooleanOperator
    implements Operator {
        @Override
        public Class<?> getType(Class<?> arg0, Class<?> arg1) {
            return Boolean.TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operator {
        public boolean checkTypes(ITypeConverter var1, Class<?> var2, Class<?> var3);

        public Class<?> getType(Class<?> var1, Class<?> var2);

        public Object apply(ITypeConverter var1, Object var2, Object var3) throws Exception;
    }
}

