/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstBracket
extends AstProperty {
    private ITypeConverter converter;
    protected final AstNode property;
    private Class<?> returnClass;
    private Type returnType;

    public AstBracket(int position, AstNode base, AstNode property, boolean lvalue) {
        super(position, base, lvalue);
        this.property = property;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        this.converter = converter;
        boolean compiled = this.prefix.compile(converter, ctx, messages);
        boolean bl = compiled = this.property.compile(converter, ctx, messages) && compiled;
        if (!compiled) {
            return false;
        }
        Type objType = this.prefix.getGenericType();
        Class<?> objClass = this.prefix.getType();
        Class<?> propertyClass = this.property.getType();
        if (objClass.isArray()) {
            if (!converter.isConvertible(propertyClass, Integer.class)) {
                messages.addMessage(this, 2, "Bracket argument for an array must be either int or Integer.");
                return false;
            }
            this.returnType = this.returnClass = objClass.getComponentType();
            if (objType instanceof GenericArrayType) {
                this.returnType = ((GenericArrayType)objType).getGenericComponentType();
            }
            return true;
        }
        if (List.class.isAssignableFrom(objClass)) {
            if (!converter.isConvertible(propertyClass, Integer.class)) {
                messages.addMessage(this, 2, "Bracket argument for a List must be either int or Integer.");
                return false;
            }
            this.returnType = Object.class;
            this.returnClass = Object.class;
            if (objType instanceof ParameterizedType) {
                this.returnType = ((ParameterizedType)objType).getActualTypeArguments()[0];
                if (this.returnType instanceof Class) {
                    this.returnClass = (Class)this.returnType;
                } else if (this.returnType instanceof ParameterizedType) {
                    this.returnClass = (Class)((ParameterizedType)this.returnType).getRawType();
                }
            }
            return true;
        }
        if (Map.class.isAssignableFrom(objClass)) {
            this.returnType = Object.class;
            this.returnClass = Object.class;
            if (objType instanceof ParameterizedType) {
                this.returnType = ((ParameterizedType)objType).getActualTypeArguments()[1];
                Class declaredItemClass = null;
                Type declaredItemType = ((ParameterizedType)objType).getActualTypeArguments()[0];
                if (declaredItemType instanceof Class) {
                    declaredItemClass = (Class)declaredItemType;
                } else if (declaredItemType instanceof ParameterizedType) {
                    declaredItemClass = (Class)((ParameterizedType)declaredItemType).getRawType();
                }
                if (declaredItemClass != null && !converter.isConvertible(propertyClass, declaredItemClass)) {
                    messages.addMessage(this, 2, "Bracket argument must be of type " + declaredItemClass.getName() + ".");
                    return false;
                }
                if (this.returnType instanceof Class) {
                    this.returnClass = (Class)this.returnType;
                } else if (this.returnType instanceof ParameterizedType) {
                    this.returnClass = (Class)((ParameterizedType)this.returnType).getRawType();
                }
            }
            return true;
        }
        messages.addMessage(this, 2, "Object type does not support [] access: " + objClass.getName());
        return false;
    }

    @Override
    public Object invoke(IEvaluationContext iContext) throws Exception {
        Object obj = this.prefix.invoke(iContext);
        Object arg = this.property.invoke(iContext);
        if (obj == null) {
            throw new ExpressionEvaluationException((IExprNode)this, "prefix object is null.");
        }
        if (obj.getClass().isArray()) {
            try {
                int index = this.converter.convert(arg, Integer.class);
                return Array.get(obj, index);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
            }
        }
        if (obj instanceof List) {
            try {
                int index = this.converter.convert(arg, Integer.class);
                return ((List)obj).get(index);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
            }
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(arg);
        }
        throw new ExpressionEvaluationException((IExprNode)this, "Object type does not support []: " + obj.getClass().getName());
    }

    @Override
    public Class<?> getType() {
        return this.returnClass;
    }

    @Override
    public Type getGenericType() {
        return this.returnType;
    }

    @Override
    public void set(IEvaluationContext iContext, Object iValue) throws ExpressionEvaluationException {
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected void appendExpressionString(StringBuilder builder) {
        this.prefix.appendExpressionString(builder);
        builder.append('[');
        this.property.appendExpressionString(builder);
        builder.append(']');
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendTypeExpr(builder, this.getGenericType());
    }
}

