/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstRightValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstChoice
extends AstRightValue {
    private ITypeConverter converter;
    private final AstNode question;
    private final AstNode yes;
    private final AstNode no;
    private Class<?> returnType;

    public AstChoice(int position, AstNode question, AstNode yes, AstNode no) {
        super(position);
        this.question = question;
        this.yes = yes;
        this.no = no;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        this.converter = converter;
        boolean compiled = this.question.compile(converter, ctx, messages);
        compiled = this.yes.compile(converter, ctx, messages) && compiled;
        boolean bl = compiled = this.no.compile(converter, ctx, messages) && compiled;
        if (!converter.isConvertible(this.question.getType(), Boolean.class)) {
            messages.addMessage(this, 2, "Question cannot be avaluated as a boolean.");
            return false;
        }
        Class<?> t1 = this.yes.getType();
        Class<?> t2 = this.no.getType();
        if (converter.isConvertible(t2, t1)) {
            this.returnType = t1;
        } else if (converter.isConvertible(t1, t2)) {
            this.returnType = t2;
        } else {
            messages.addMessage(this, 2, "The 2 cases return type are not compatible.");
            return false;
        }
        return true;
    }

    @Override
    public Class<?> getType() {
        return this.returnType;
    }

    @Override
    public Type getGenericType() {
        return this.returnType;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws Exception {
        boolean res;
        Object questionResult = this.question.invoke(context);
        try {
            res = this.converter.convert(questionResult, Boolean.class);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
        }
        return res ? this.yes.invoke(context) : this.no.invoke(context);
    }

    @Override
    public boolean isStaticValue() {
        return this.question.isStaticValue() && this.yes.isStaticValue() && this.no.isStaticValue();
    }

    @Override
    protected void appendExpressionString(StringBuilder builder) {
        this.question.appendExpressionString(builder);
        builder.append(" ? ");
        this.yes.appendExpressionString(builder);
        builder.append(" : ");
        this.no.appendExpressionString(builder);
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        builder.append("{");
        this.yes.appendValuePattern(builder);
        builder.append("|");
        this.no.appendValuePattern(builder);
        builder.append("}");
    }
}

