/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import java.util.List;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstRightValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstComposite
extends AstRightValue {
    private ITypeConverter converter;
    private final List<AstNode> nodes;

    public AstComposite(int position, List<AstNode> nodes) {
        super(position);
        this.nodes = nodes;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        this.converter = converter;
        boolean compiled = true;
        for (AstNode child : this.nodes) {
            compiled = child.compile(converter, ctx, messages) && compiled;
        }
        return compiled;
    }

    @Override
    public Type getGenericType() {
        return String.class;
    }

    @Override
    public Class<?> getType() {
        return String.class;
    }

    @Override
    public boolean isStaticValue() {
        for (AstNode child : this.nodes) {
            if (child.isStaticValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws Exception {
        StringBuilder b = new StringBuilder(16);
        for (AstNode child : this.nodes) {
            b.append(this.converter.convert(child.invoke(context), String.class));
        }
        return b.toString();
    }

    @Override
    protected void appendExpressionString(StringBuilder builder) {
        for (AstNode child : this.nodes) {
            child.appendExpressionString(builder);
        }
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        for (AstNode child : this.nodes) {
            child.appendValuePattern(builder);
        }
    }
}

