/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.ParameterizedTypeNoVariable;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstDot
extends AstProperty {
    protected final String property;
    private static final Object[] NO_ARG = new Object[0];
    private static final Class<?>[] GET_SIGNATURE = new Class[0];
    private ITypeConverter converter;
    private Field field;
    private Method get;
    private Method set;
    private Type genType;
    private boolean isArrayLength = false;

    public AstDot(int position, AstNode base, String property, boolean lvalue) {
        super(position, base, lvalue);
        this.property = property;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        Class<?> objType;
        block16: {
            this.converter = converter;
            boolean compiled = this.prefix.compile(converter, ctx, messages);
            if (!compiled) {
                return false;
            }
            objType = this.prefix.getType();
            String getMethodName = "get" + Character.toUpperCase(this.property.charAt(0)) + this.property.substring(1);
            try {
                this.get = objType.getMethod(getMethodName, GET_SIGNATURE);
            }
            catch (Exception e) {
                String isMethodName = "is" + Character.toUpperCase(this.property.charAt(0)) + this.property.substring(1);
                try {
                    this.get = objType.getMethod(isMethodName, GET_SIGNATURE);
                    if (this.get.getReturnType() != Boolean.class && this.get.getReturnType() != Boolean.TYPE) {
                        messages.addMessage(this, 2, "The 'is' getter signature is only allowed for boolean type attributes.");
                        return false;
                    }
                }
                catch (Exception e1) {
                    try {
                        this.field = objType.getField(this.property);
                    }
                    catch (Exception e2) {
                        if (objType.isArray() && "length".equals(this.property)) {
                            this.isArrayLength = true;
                            break block16;
                        }
                        messages.addMessage(this, 2, "No such attribute: '" + this.property + "' (neither " + getMethodName + " nor " + isMethodName + ", nor " + this.property + " field on object " + objType.getName() + ").");
                        return false;
                    }
                }
            }
        }
        if (this.get != null) {
            if ((this.get.getModifiers() & 1) == 0) {
                messages.addMessage(this, 2, "Getter method is not public: " + this.get);
                return false;
            }
            String setMethodName = "set" + Character.toUpperCase(this.property.charAt(0)) + this.property.substring(1);
            try {
                this.set = objType.getMethod(setMethodName, this.get.getReturnType());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.set != null && (this.set.getModifiers() & 1) == 0) {
                messages.addMessage(this, 1, "Setter method is not public: " + this.set);
                this.set = null;
            }
        } else if (this.field != null && (this.field.getModifiers() & 1) == 0) {
            messages.addMessage(this, 2, "Field not public: " + this.field);
            return false;
        }
        return true;
    }

    @Override
    public Object invoke(IEvaluationContext iContext) throws Exception {
        Object obj = this.prefix.invoke(iContext);
        if (this.get != null) {
            try {
                return this.get.invoke(obj, NO_ARG);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Exception) {
                    throw (Exception)e.getTargetException();
                }
                if (e.getTargetException() instanceof Error) {
                    throw (Error)e.getTargetException();
                }
                throw e;
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
            }
        }
        if (this.field != null) {
            try {
                return this.field.get(obj);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
            }
        }
        if (this.isArrayLength) {
            return Array.getLength(obj);
        }
        return null;
    }

    @Override
    public Type getGenericType() {
        if (this.genType == null) {
            if (this.get != null) {
                this.genType = this.get.getGenericReturnType();
            } else if (this.field != null) {
                this.genType = this.field.getGenericType();
            } else if (this.isArrayLength) {
                this.genType = Integer.TYPE;
            } else {
                return null;
            }
            if (this.genType instanceof ParameterizedType && this.prefix.getGenericType() instanceof ParameterizedType) {
                this.genType = ParameterizedTypeNoVariable.getNoVariable((ParameterizedType)this.genType, (ParameterizedType)this.prefix.getGenericType());
            }
        }
        return this.genType;
    }

    @Override
    public Class<?> getType() {
        if (this.get != null) {
            return this.get.getReturnType();
        }
        if (this.field != null) {
            return this.field.getType();
        }
        if (this.isArrayLength) {
            return Integer.TYPE;
        }
        return null;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        if (this.set != null) {
            return false;
        }
        if (this.field != null) {
            return false;
        }
        if (this.isArrayLength) {
            return true;
        }
        return true;
    }

    @Override
    public void set(IEvaluationContext iContext, Object iValue) throws Exception {
        if (this.isReadOnly()) {
            return;
        }
        Object obj = this.prefix.invoke(iContext);
        Class<?> type = this.getType();
        iValue = this.converter.convert(iValue, type);
        if (this.set != null) {
            try {
                this.set.invoke(obj, iValue);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Exception) {
                    throw (Exception)e.getTargetException();
                }
                if (e.getTargetException() instanceof Error) {
                    throw (Error)e.getTargetException();
                }
                throw e;
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
            }
        }
        if (this.field != null) {
            try {
                this.field.set(obj, iValue);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
            }
        }
    }

    @Override
    protected void appendExpressionString(StringBuilder builder) {
        this.prefix.appendExpressionString(builder);
        builder.append('.');
        builder.append(this.property);
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendTypeExpr(builder, this.getGenericType());
    }
}

