/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.IExpression;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstInvocation;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstFunction
extends AstInvocation {
    private static final IExpression[] EXPR_ARRAY_TYPE = new IExpression[0];
    protected ICompilationContext.IFunctionContext function;

    public AstFunction(int position, String name, List<AstNode> nodes) {
        super(position, name, nodes);
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext context, final ICompilationResultWriter messages) {
        List<ICompilationContext.IFunctionContext> functions;
        if (!super.compile(converter, context, messages)) {
            return false;
        }
        String fnPrefix = null;
        String fnName = this.name;
        int idxColon = this.name.indexOf(58);
        if (idxColon >= 0) {
            fnPrefix = this.name.substring(0, idxColon);
            fnName = this.name.substring(idxColon + 1);
        }
        if ((functions = context.getFunctions(fnPrefix, fnName)) == null || functions.size() == 0) {
            messages.addMessage(this, 2, "No function '" + this.name + "' declared.");
            return false;
        }
        for (int i = 0; i < functions.size(); ++i) {
            Method m = functions.get(i).getMethod();
            if (!this.matchesParamTypes(m)) continue;
            this.function = functions.get(i);
            break;
        }
        if (this.function == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("No function method matching parameter types: ");
            sb.append(this.name);
            sb.append("(");
            if (this.args != null) {
                for (int i = 0; i < this.args.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(((AstNode)this.args.get(i)).getType().getName());
                }
            }
            sb.append(")");
            messages.addMessage(this, 2, sb.toString());
            return false;
        }
        if ((this.function.getMethod().getModifiers() & 1) == 0) {
            messages.addMessage(this, 2, "Function method is not public: " + this.function.getMethod());
        }
        ArrayList<IExpression> argExpr = new ArrayList<IExpression>(this.args);
        this.function.compile(argExpr, new ICompilationContext.ICompilationLogger(){

            public void addMessage(int level, String message) {
                messages.addMessage(AstFunction.this, level, message);
            }
        });
        return true;
    }

    @Override
    public Class<?> getType() {
        return this.function == null ? null : this.function.getMethod().getReturnType();
    }

    @Override
    public Type getGenericType() {
        return this.function == null ? null : this.function.getMethod().getGenericReturnType();
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws Exception {
        Object obj = context.getFunctionObject(this.function);
        return this.invoke(context, this.function.getMethod(), obj);
    }

    @Override
    protected void appendExpressionString(StringBuilder b) {
        b.append(this.name);
        b.append("(");
        if (this.args != null) {
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                ((AstNode)this.args.get(i)).appendExpressionString(b);
            }
        }
        b.append(")");
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        ArrayList<IExpression> argExpr = new ArrayList<IExpression>(this.args);
        String valuePattern = this.function.getValuePattern(argExpr);
        if (valuePattern != null) {
            builder.append(valuePattern);
        } else {
            RegExpBuilder.appendTypeExpr(builder, this.getGenericType());
        }
    }
}

