/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstIdentifier
extends AstNode {
    private final String name;
    private Class<?> varClass;
    private Type varType;

    public AstIdentifier(int position, String name) {
        super(position);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        try {
            this.varClass = ctx.getVariableType(this.name);
            this.varType = ctx.getVariableGenericType(this.name);
            if (this.varType == null) {
                messages.addMessage(this, 2, "No such object: '" + this.name + "'.");
                return false;
            }
            return true;
        }
        catch (ICompilationContext.UnresolvedVariableError e) {
            messages.addMessage(this, 1, "Unresolved object: '" + this.name + "'.");
            return false;
        }
    }

    @Override
    public Type getGenericType() {
        return this.varType;
    }

    @Override
    public Class<?> getType() {
        return this.varClass;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException {
        try {
            return context.getVariable(this.name);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    protected void appendExpressionString(StringBuilder builder) {
        builder.append(this.name);
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendTypeExpr(builder, this.getGenericType());
    }

    @Override
    public void set(IEvaluationContext context, Object value) throws ExpressionEvaluationException {
    }
}

