/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstRightValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstInvocation
extends AstRightValue {
    protected ITypeConverter converter;
    protected final List<AstNode> args;
    protected final String name;

    public AstInvocation(int position, String name, List<AstNode> args) {
        super(position);
        this.name = name;
        this.args = args;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext context, ICompilationResultWriter results) {
        this.converter = converter;
        boolean compiled = true;
        if (this.args != null) {
            for (AstNode child : this.args) {
                compiled = child.compile(converter, context, results) && compiled;
            }
        }
        return compiled;
    }

    protected boolean matchesParamTypes(Method method) {
        int nbArgs;
        Class<?>[] methodArgTypes = method.getParameterTypes();
        int n = nbArgs = this.args == null ? 0 : this.args.size();
        if (method.isVarArgs()) {
            if (nbArgs < methodArgTypes.length - 1) {
                return false;
            }
            for (int j = 0; j < methodArgTypes.length - 1; ++j) {
                if (this.converter.isConvertible(this.args.get(j).getType(), methodArgTypes[j])) continue;
                return false;
            }
            Class<?> methodVarArgType = methodArgTypes[methodArgTypes.length - 1].getComponentType();
            for (int j = methodArgTypes.length - 1; j < nbArgs; ++j) {
                if (this.converter.isConvertible(this.args.get(j).getType(), methodVarArgType)) continue;
                return false;
            }
            return true;
        }
        if (methodArgTypes.length != nbArgs) {
            return false;
        }
        for (int j = 0; j < methodArgTypes.length; ++j) {
            if (this.converter.isConvertible(this.args.get(j).getType(), methodArgTypes[j])) continue;
            return false;
        }
        return true;
    }

    protected Object invoke(IEvaluationContext context, Method method, Object obj) throws Exception {
        try {
            Object[] argsArray = null;
            if (this.args != null) {
                Class<?>[] methodArgTypes = method.getParameterTypes();
                if (method.isVarArgs()) {
                    argsArray = new Object[methodArgTypes.length];
                    for (int i = 0; i < methodArgTypes.length - 1; ++i) {
                        Object argVal = this.args.get(i).invoke(context);
                        try {
                            argsArray[i] = this.converter.convert(argVal, methodArgTypes[i]);
                            continue;
                        }
                        catch (Exception e) {
                            throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
                        }
                    }
                    Class<?> methodVarArgType = methodArgTypes[methodArgTypes.length - 1].getComponentType();
                    Object varArgs = Array.newInstance(methodVarArgType, this.args.size() - methodArgTypes.length + 1);
                    for (int j = methodArgTypes.length - 1; j < this.args.size(); ++j) {
                        Array.set(varArgs, j - methodArgTypes.length + 1, this.converter.convert(this.args.get(j).invoke(context), methodVarArgType));
                    }
                    argsArray[methodArgTypes.length - 1] = varArgs;
                } else {
                    argsArray = new Object[methodArgTypes.length];
                    for (int i = 0; i < methodArgTypes.length; ++i) {
                        argsArray[i] = this.converter.convert(this.args.get(i).invoke(context), methodArgTypes[i]);
                    }
                }
            }
            return method.invoke(obj, argsArray);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
        }
    }
}

