/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.ParameterizedTypeNoVariable;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstInvocation;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstMethod
extends AstInvocation {
    protected final AstNode prefix;
    protected Method method;
    private Type genType;

    public AstMethod(int position, AstNode prefix, String name, List<AstNode> args) {
        super(position, name, args);
        this.prefix = prefix;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext context, ICompilationResultWriter messages) {
        int i;
        boolean compiled = super.compile(converter, context, messages);
        boolean bl = compiled = this.prefix.compile(converter, context, messages) && compiled;
        if (!compiled) {
            return false;
        }
        Class<?> objType = this.prefix.getType();
        int nbArgs = this.args == null ? 0 : this.args.size();
        Class[] argTypes = new Class[nbArgs];
        for (int i2 = 0; i2 < nbArgs; ++i2) {
            argTypes[i2] = ((AstNode)this.args.get(i2)).getType();
        }
        try {
            this.method = objType.getMethod(this.name, argTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.method == null) {
            Method[] methods = objType.getMethods();
            for (i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(this.name) || !this.matchesParamTypes(methods[i])) continue;
                this.method = methods[i];
                break;
            }
        }
        if (this.method == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("No such method: ");
            sb.append(objType.getName());
            sb.append(".");
            sb.append(this.name);
            sb.append("(");
            if (this.args != null) {
                for (i = 0; i < this.args.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(((AstNode)this.args.get(i)).getType().getName());
                }
            }
            sb.append(")");
            messages.addMessage(this, 2, sb.toString());
            return false;
        }
        if ((this.method.getModifiers() & 1) == 0) {
            messages.addMessage(this, 2, "Method is not public: " + this.method);
            return false;
        }
        return true;
    }

    @Override
    public Class<?> getType() {
        return this.method == null ? null : this.method.getReturnType();
    }

    @Override
    public Type getGenericType() {
        if (this.method == null) {
            return null;
        }
        if (this.genType == null) {
            this.genType = this.method.getGenericReturnType();
            if (this.genType instanceof ParameterizedType && this.prefix.getGenericType() instanceof ParameterizedType) {
                this.genType = ParameterizedTypeNoVariable.getNoVariable((ParameterizedType)this.genType, (ParameterizedType)this.prefix.getGenericType());
            }
        }
        return this.genType;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws Exception {
        Object obj = this.prefix.invoke(context);
        return this.invoke(context, this.method, obj);
    }

    @Override
    protected void appendExpressionString(StringBuilder b) {
        this.prefix.appendExpressionString(b);
        b.append(".");
        b.append(this.name);
        b.append("(");
        if (this.args != null) {
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                ((AstNode)this.args.get(i)).appendExpressionString(b);
            }
        }
        b.append(")");
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendTypeExpr(builder, this.getGenericType());
    }
}

