/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstString
extends AstLiteral {
    private final String value;

    public AstString(int position, String value) {
        super(position);
        this.value = value;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException {
        return this.value;
    }

    @Override
    public Class<?> getType() {
        return String.class;
    }

    @Override
    public Type getGenericType() {
        return String.class;
    }

    @Override
    protected void appendExpressionString(StringBuilder b) {
        b.append("'");
        int length = this.value.length();
        for (int i = 0; i < length; ++i) {
            char c = this.value.charAt(i);
            if (c == '\\' || c == '\'') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append("'");
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendString(builder, this.value);
    }
}

