/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstText
extends AstNode {
    private final String value;

    public AstText(int position, String value) {
        super(position);
        this.value = value;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        return true;
    }

    @Override
    public Class<?> getType() {
        return String.class;
    }

    @Override
    public Type getGenericType() {
        return String.class;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return true;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException {
        return this.value;
    }

    @Override
    public void set(IEvaluationContext context, Object value) throws ExpressionEvaluationException {
    }

    @Override
    protected void appendExpressionString(StringBuilder b) {
        int end = this.value.length() - 1;
        for (int i = 0; i < end; ++i) {
            char c = this.value.charAt(i);
            if ((c == '#' || c == '$') && this.value.charAt(i + 1) == '{') {
                b.append('\\');
            }
            b.append(c);
        }
        if (end >= 0) {
            b.append(this.value.charAt(end));
        }
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendString(builder, this.value);
    }
}

