/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.BooleanOperations;
import org.ow2.opensuit.cel.impl.misc.NumberOperations;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstRightValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstUnaryOperation
extends AstRightValue {
    private ITypeConverter converter;
    private final Operator operator;
    private final AstNode child;
    public static final Operator EMPTY = new Operator(){

        @Override
        public boolean checkType(ITypeConverter converter, Class<?> t) {
            return true;
        }

        @Override
        public Class<?> getType(Class<?> t) {
            return Boolean.class;
        }

        @Override
        public Object apply(ITypeConverter converter, Object o) throws Exception {
            return BooleanOperations.empty(converter, o);
        }

        public String toString() {
            return "empty";
        }
    };
    public static final Operator NEG = new Operator(){

        @Override
        public boolean checkType(ITypeConverter converter, Class<?> t) {
            return NumberOperations.checkType(converter, t);
        }

        @Override
        public Class<?> getType(Class<?> t) {
            return t;
        }

        @Override
        public Object apply(ITypeConverter converter, Object o) throws Exception {
            return NumberOperations.neg(converter, o);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator NOT = new Operator(){

        @Override
        public boolean checkType(ITypeConverter converter, Class<?> t) {
            return converter.isConvertible(t, Boolean.class);
        }

        @Override
        public Class<?> getType(Class<?> t) {
            return Boolean.class;
        }

        @Override
        public Object apply(ITypeConverter converter, Object o) throws Exception {
            return BooleanOperations.not(converter, o);
        }

        public String toString() {
            return "!";
        }
    };

    public AstUnaryOperation(int position, AstNode child, Operator operator) {
        super(position);
        this.child = child;
        this.operator = operator;
    }

    @Override
    public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages) {
        this.converter = converter;
        boolean compiled = this.child.compile(converter, ctx, messages);
        if (!compiled) {
            return false;
        }
        if (!this.operator.checkType(converter, this.child.getType())) {
            messages.addMessage(this, 2, "Unsupported type for operation " + this.operator + ".");
            return false;
        }
        return true;
    }

    @Override
    public Class<?> getType() {
        return this.operator.getType(this.child.getType());
    }

    @Override
    public Type getGenericType() {
        return this.operator.getType(this.child.getType());
    }

    @Override
    public boolean isStaticValue() {
        return this.child.isStaticValue();
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object invoke(IEvaluationContext context) throws Exception {
        try {
            return this.operator.apply(this.converter, this.child.invoke(context));
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((IExprNode)this, (Throwable)e);
        }
    }

    @Override
    protected void appendExpressionString(StringBuilder b) {
        b.append(this.operator);
        b.append(' ');
        this.child.appendExpressionString(b);
    }

    @Override
    protected void appendValuePattern(StringBuilder builder) {
        RegExpBuilder.appendTypeExpr(builder, this.getGenericType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operator {
        public boolean checkType(ITypeConverter var1, Class<?> var2);

        public Class<?> getType(Class<?> var1);

        public Object apply(ITypeConverter var1, Object var2) throws Exception;
    }
}

