/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCompilationContext
implements ICompilationContext {
    private HashMap<String, Class<?>> name2class = new HashMap();
    private HashMap<String, List<ICompilationContext.IFunctionContext>> name2function = new HashMap();

    public void declareVariable(String name, Class<?> clazz) {
        this.name2class.put(name, clazz);
    }

    public void declareFunction(String prefix, String name, Method function) {
        String fullName = prefix == null || prefix.length() == 0 ? name : prefix + ":" + name;
        List<ICompilationContext.IFunctionContext> list = this.name2function.get(fullName);
        if (list == null) {
            list = new ArrayList<ICompilationContext.IFunctionContext>(1);
            this.name2function.put(fullName, list);
        } else if (list.contains(function)) {
            return;
        }
        list.add(new FunctionContextImpl(function));
    }

    @Override
    public Type getVariableGenericType(String name) throws ICompilationContext.UnresolvedVariableError {
        return this.name2class.get(name);
    }

    @Override
    public Class<?> getVariableType(String name) throws ICompilationContext.UnresolvedVariableError {
        return this.name2class.get(name);
    }

    @Override
    public List<ICompilationContext.IFunctionContext> getFunctions(String prefix, String name) {
        String fullName = prefix == null || prefix.length() == 0 ? name : prefix + ":" + name;
        return this.name2function.get(fullName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionContextImpl
    implements ICompilationContext.IFunctionContext {
        private Method method;

        public FunctionContextImpl(Method method) {
            this.method = method;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public void compile(List<IExpression> arguments, ICompilationContext.ICompilationLogger logger) {
        }

        @Override
        public String getValuePattern(List<IExpression> arguments) {
            return null;
        }
    }
}

