/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.util.ConversionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictTypeConverter
implements ITypeConverter {
    private static final long serialVersionUID = 1L;
    protected static final Long LONG_ZERO = 0L;
    protected static final Map<Class<?>, Class<?>> WRAPPER_TYPES;

    private Boolean coerceToBoolean(Object value) throws ConversionError {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return ((String)value).length() > 0;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue() != 0.0f;
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), Boolean.class));
    }

    private Character coerceToCharacter(Object value) throws ConversionError {
        if (value == null || "".equals(value)) {
            return Character.valueOf('\u0000');
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Number) {
            return Character.valueOf((char)((Number)value).shortValue());
        }
        if (value instanceof String) {
            return Character.valueOf(((String)value).charAt(0));
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), Character.class));
    }

    private Number coerceNumberToNumber(Number value, Class<? extends Number> type) throws ConversionError {
        if (type.isInstance(value)) {
            return value;
        }
        if (type == BigInteger.class) {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            return BigInteger.valueOf(value.longValue());
        }
        if (type == BigDecimal.class) {
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            return new BigDecimal(value.doubleValue());
        }
        if (type == Byte.class) {
            return value.byteValue();
        }
        if (type == Short.class) {
            return value.shortValue();
        }
        if (type == Integer.class) {
            return value.intValue();
        }
        if (type == Long.class) {
            return value.longValue();
        }
        if (type == Float.class) {
            return Float.valueOf(value.floatValue());
        }
        if (type == Double.class) {
            return value.doubleValue();
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), type));
    }

    private <T extends Number> T coerceToNumber(Object value, Class<T> type) throws ConversionError {
        if (value == null) {
            return (T)this.coerceNumberToNumber(LONG_ZERO, type);
        }
        if (value instanceof Number) {
            return (T)this.coerceNumberToNumber((Number)value, type);
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), type));
    }

    private String coerceToString(Object value) {
        return this.coerceToString(value, false);
    }

    private String coerceToString(Object value, boolean inList) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value.getClass().isArray()) {
            int l = Array.getLength(value);
            if (l == 0) {
                return "";
            }
            StringBuffer array = new StringBuffer();
            if (inList) {
                array.append('(');
            }
            for (int i = 0; i < l; ++i) {
                if (i > 0) {
                    array.append(", ");
                }
                array.append(this.coerceToString(Array.get(value, i), true));
            }
            if (inList) {
                array.append(')');
            }
            return array.toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int l = coll.size();
            if (l == 0) {
                return "";
            }
            StringBuffer array = new StringBuffer();
            if (inList) {
                array.append('(');
            }
            int i = 0;
            for (Object o : coll) {
                if (i > 0) {
                    array.append(", ");
                }
                array.append(this.coerceToString(o, true));
                ++i;
            }
            if (inList) {
                array.append(')');
            }
            return array.toString();
        }
        return value.toString();
    }

    private Date coerceToDate(Object value) throws ConversionError {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), Date.class));
    }

    private Calendar coerceToCalendar(Object value) throws ConversionError {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            return cal;
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), Calendar.class));
    }

    private <T extends Enum<T>> T coerceToEnum(Object value, Class<T> type) throws ConversionError {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(type, (String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionError(String.format("Cannot coerce '%s' to %s", value, type));
            }
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), type));
    }

    @Override
    public boolean isConvertible(Class<?> sourceType, Class<?> targetType) {
        if (targetType == null || sourceType == null) {
            return false;
        }
        if (targetType == Object.class) {
            return true;
        }
        if (targetType == String.class) {
            return true;
        }
        if (sourceType.isPrimitive()) {
            sourceType = WRAPPER_TYPES.get(sourceType);
        }
        if (targetType.isPrimitive()) {
            targetType = WRAPPER_TYPES.get(targetType);
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (Number.class.isAssignableFrom(targetType)) {
            return Number.class.isAssignableFrom(sourceType);
        }
        if (targetType == Boolean.class) {
            return sourceType == Boolean.class || sourceType == Boolean.TYPE;
        }
        if (Date.class.isAssignableFrom(targetType)) {
            return Calendar.class.isAssignableFrom(sourceType);
        }
        if (Calendar.class.isAssignableFrom(targetType)) {
            return Date.class.isAssignableFrom(sourceType);
        }
        return false;
    }

    @Override
    public <T> T convert(Object value, Class<T> type) throws ConversionError {
        if (value == null && !type.isPrimitive()) {
            return null;
        }
        if (type == Object.class) {
            return (T)value;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (type == String.class) {
            return (T)this.coerceToString(value);
        }
        if (type.isPrimitive()) {
            type = WRAPPER_TYPES.get(type);
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.coerceToNumber(value, type);
        }
        if (type == Character.class) {
            return (T)this.coerceToCharacter(value);
        }
        if (type == Boolean.class) {
            return (T)this.coerceToBoolean(value);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.coerceToEnum(value, type);
        }
        if (Date.class.isAssignableFrom(type)) {
            return (T)this.coerceToDate(value);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (T)this.coerceToCalendar(value);
        }
        throw new ConversionError(String.format("Cannot coerce from %s to %s", value.getClass(), type));
    }

    public static void main(String[] args) throws ConversionError {
        StrictTypeConverter c = new StrictTypeConverter();
        boolean val = c.convert(null, Boolean.TYPE);
        System.out.println("value: " + val);
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> wrapperTypes = new HashMap<Class<Comparable<Boolean>>, Class>();
        wrapperTypes = new HashMap();
        wrapperTypes.put(Boolean.TYPE, Boolean.class);
        wrapperTypes.put(Character.TYPE, Character.class);
        wrapperTypes.put(Byte.TYPE, Byte.class);
        wrapperTypes.put(Short.TYPE, Short.class);
        wrapperTypes.put(Integer.TYPE, Integer.class);
        wrapperTypes.put(Long.TYPE, Long.class);
        wrapperTypes.put(Float.TYPE, Float.class);
        wrapperTypes.put(Double.TYPE, Double.class);
        WRAPPER_TYPES = Collections.unmodifiableMap(wrapperTypes);
    }
}

