/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.xml.chart;

import javax.servlet.http.HttpServletRequest;

import org.jfree.chart.plot.Plot;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

public class CustomChart extends BaseChart
{
	@XmlChild(name="Plot")
	protected Expression plot;
	
	@Override
	public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext)
	{
		super.initialize(initSupport, instContext);
		if(plot != null && initSupport.initialize(plot))
		{
			if(!plot.isConvertible(Plot.class)){
		    	initSupport.addValidationMessage(this, "Plot", IInitializationSupport.ERROR, "Expression 'Plot' must return a org.jfree.chart.plot.Plot.");
			}
		}
	}
	@Override
	public Plot makePlot(HttpServletRequest request) throws Exception
	{
		return plot.invoke(request, Plot.class);
	}
}
