/**
 * Reloads the chart image and map
 */
function Chart_reload(imgName, getMapUrl)
{
	var img = document.images[imgName];
	if(img == null)
		return;
	// --- save original image source
	if(!img.origSrc)
		img.origSrc = img.src;
	
	var map = document.getElementById(imgName+"_map");
	// --- reload map
	if(map != null)
	{
		var req = newXHR();
		req.open("GET", getMapUrl , true);//asynchronous
		req.onreadystatechange = function()
		{
			if(req.readyState == 4)
			{
				if(req.status == 200 || req.status == 0)
				{
					// --- replace image map html
					map.outerHTML = req.responseText;
					
					// --- finally reload image
					img.src = img.origSrc+"&_time="+(new Date().getTime());
					
					// --- TODO: change map name and usemap attribute on img
				}
				else
				{
					alert("HTTP error ("+getMapUrl+"): "+req.status);
				}
			}
		}
		req.send(null);
	}
	else
	{
		// --- reload image
		img.src = img.origSrc+"&_time="+(new Date().getTime());
	}
}
