/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xml.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.plot.Plot;
import org.jfree.ui.RectangleInsets;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.session.PageContext;
import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.opensuit.core.util.UrlBuilder;
import org.ow2.opensuit.xml.base.Application;
import org.ow2.opensuit.xml.base.binding.Do;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.base.html.IFrame;
import org.ow2.opensuit.xml.base.html.IView;
import org.ow2.opensuit.xml.base.page.IPage;
import org.ow2.opensuit.xml.chart.InoperantGraphics;
import org.ow2.opensuit.xml.interfaces.IBeanProvider;
import org.ow2.opensuit.xmlmap.annotations.XmlAncestor;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlChildren;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlDoc(value="This is the base abstract component that enables JFreeChart integration in open SUIT.")
@XmlElement
public abstract class BaseChart
implements IView,
IInitializable,
IBeanProvider {
    protected Log logger = LogFactory.getLog(this.getClass());
    @XmlAncestor
    protected Application root;
    @XmlAncestor
    private IBeanProvider parentProvider;
    @XmlDoc(value="Image width (in pixels).")
    @XmlAttribute(name="Width", required=true)
    private int width;
    @XmlDoc(value="Image height (in pixels).")
    @XmlAttribute(name="Height", required=true)
    private int height;
    @XmlDoc(value="Determines whether the char displays the legend.Default: true.")
    @XmlAttribute(name="ShowLegend", required=false)
    private boolean showLegend = true;
    @XmlDoc(value="Enables chart auto-reload.<br>This expression returns the auto-reload time interval (in milliseconds).<br>A null value (0) disables the auto-reload behavior.<br>Note: with auto-reload behavior, the 'ChartTime' expression should always return System.currentTimeMillis()")
    @XmlChild(name="AutoReloadInterval", required=false)
    protected Expression autoReloadInterval;
    @XmlDoc(value="The chart time.<br>This expression returns a timestamp (long) representing the latest time when data required to produce the chart was computed.")
    @XmlChild(name="ChartTime")
    protected Expression chartTime;
    @XmlDoc(value="The chart title.<br>This will be displayed inside the chart image, and will also be used as the image filename.")
    @XmlChild(name="Title")
    protected Expression title;
    @XmlDoc(value="Some actions to perform at prerender time.<br>This is where you may use the $control object to invalidate() the cached chart.")
    @XmlChildren(name="OnPreRender", minOccurs=0)
    private Do[] onPreRender;
    @XmlAncestor
    private IPage page;
    @XmlAncestor
    private IFrame frame;

    public String getPathID() {
        if (this.page != null) {
            return this.page.getPath() + "/Chart";
        }
        return "/" + this.frame.getName() + "/Chart";
    }

    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        this.root.registerRequestHandler(this.getPathID(), (Object)this);
        if (this.chartTime != null && initSupport.initialize((Object)this.chartTime) && !this.chartTime.isConvertible(Long.class)) {
            initSupport.addValidationMessage((Object)this, "ChartDate", 1, "Expression 'ChartDate' must return a long (timestamp).");
        }
        if (this.autoReloadInterval != null && initSupport.initialize((Object)this.autoReloadInterval) && !this.autoReloadInterval.isConvertible(Integer.class)) {
            initSupport.addValidationMessage((Object)this, "AutoReloadInterval", 1, "Expression 'AutoReloadInterval' must return a number.");
        }
    }

    protected String getTitle(HttpServletRequest request) {
        try {
            return (String)this.title.invoke(request, String.class);
        }
        catch (Exception e) {
            return "chart";
        }
    }

    public void preRender(HttpServletRequest request) throws Exception {
        if (this.onPreRender != null) {
            for (Do d : this.onPreRender) {
                d.invoke(request);
            }
        }
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String titleStr;
        int autoReloadInterval = 0;
        if (this.autoReloadInterval != null) {
            autoReloadInterval = (Integer)this.autoReloadInterval.invoke(request, Integer.class);
        }
        String fileNameNoExt = titleStr = (String)this.title.invoke(request, String.class);
        int w = this.width;
        int h = this.height;
        UrlBuilder url = this.root.createServiceUrl(request, (Object)this, "serveImage", fileNameNoExt + ".png");
        url.setParameter("w", String.valueOf(w));
        url.setParameter("h", String.valueOf(h));
        url.setParameter("title", titleStr);
        CachedChartData data = this.getData(request, titleStr);
        ChartRenderingInfo info = this.computeInfo(data.chart, w, h);
        String imgName = HtmlUtils.formatId((String)fileNameNoExt);
        String mapName = imgName + "_map";
        PrintWriter writer = response.getWriter();
        if (autoReloadInterval > 0) {
            HtmlUtils.includeBaseJavaScript((HttpServletRequest)request, (HttpServletResponse)response, (String)"Common.js");
            HtmlUtils.includeJavaScript((HttpServletRequest)request, (HttpServletResponse)response, (String)"org/ow2/opensuit/xml/chart/Chart.js");
            UrlBuilder urlMap = this.root.createServiceUrl(request, (Object)this, "reloadMap", mapName);
            urlMap.setParameter("w", String.valueOf(w));
            urlMap.setParameter("h", String.valueOf(h));
            urlMap.setParameter("name", mapName);
            urlMap.setParameter("title", titleStr);
            writer.println("<script language=javascript>");
            writer.println("setInterval(\"Chart_reload('" + imgName + "', '" + urlMap.toUrl(response.getCharacterEncoding(), false) + "')\", " + autoReloadInterval + ");");
            writer.println("</script>");
        }
        ImageMapUtilities.writeImageMap((PrintWriter)writer, (String)mapName, (ChartRenderingInfo)info);
        writer.print("<img class='osuit-Chart'");
        writer.print(" name='");
        writer.print(imgName);
        writer.print("'");
        writer.print(" usemap='#");
        writer.print(HtmlUtils.encode2HTML((String)mapName));
        writer.print("'");
        writer.print(" width=");
        writer.print(String.valueOf(w));
        writer.print(" height=");
        writer.print(String.valueOf(h));
        writer.print(" alt='");
        writer.print(HtmlUtils.encode2HTML((String)titleStr));
        writer.print("'");
        writer.print(" src='");
        writer.print(url.toUrl(response.getCharacterEncoding(), true));
        writer.print("'");
        writer.print(">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChartRenderingInfo computeInfo(JFreeChart chart, int w, int h) {
        long start = System.currentTimeMillis();
        try {
            ChartRenderingInfo info = new ChartRenderingInfo();
            BufferedImage img = new BufferedImage(1, 1, 2);
            InoperantGraphics g2 = new InoperantGraphics(img.createGraphics());
            chart.draw((Graphics2D)g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h), info);
            ChartRenderingInfo chartRenderingInfo = info;
            return chartRenderingInfo;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logger.debug((Object)("Chart info (" + w + "x" + h + ") computed in " + (end - start) + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage makeImage(JFreeChart chart, int w, int h, ChartRenderingInfo info) {
        long start = System.currentTimeMillis();
        try {
            BufferedImage bufferedImage = chart.createBufferedImage(w, h, info);
            return bufferedImage;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logger.debug((Object)("Chart image (" + w + "x" + h + ") computed in " + (end - start) + " ms"));
        }
    }

    private JFreeChart makeChart(HttpServletRequest request, String title) throws Exception {
        this.logger.debug((Object)("makeChart('" + title + "')"));
        Plot plot = this.makePlot(request);
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, this.showLegend);
        return chart;
    }

    private CachedChartData getData(HttpServletRequest request, String title) throws Exception {
        CachedChartData data = this.getCache(request);
        if (data != null && data.newImage != null) {
            this.logger.debug((Object)"getData(): a new image is waiting to be served: use cached image.");
            return data;
        }
        long time = (Long)this.chartTime.invoke(request, Long.class);
        if (data != null && data.time >= time) {
            this.logger.debug((Object)"getData(): cached chart still valid. Reuse cache.");
            return data;
        }
        this.logger.debug((Object)"getData(): compute chart.");
        Plot plot = this.makePlot(request);
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        data = new CachedChartData();
        data.chart = this.makeChart(request, title);
        data.time = time;
        this.setCache(request, data);
        return data;
    }

    public void reloadMap(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int w = Integer.parseInt(request.getParameter("w"));
        int h = Integer.parseInt(request.getParameter("h"));
        String mapName = request.getParameter("name");
        String title = request.getParameter("title");
        this.removeCache(request);
        CachedChartData data = this.getData(request, title);
        ChartRenderingInfo info = new ChartRenderingInfo();
        data.newImage = this.makeImage(data.chart, w, h, info);
        OpenSuitSession session = OpenSuitSession.getSession((HttpServletRequest)request);
        response.setContentType("text/html;charset=" + session.getLocaleConfig().getCharSet());
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        PrintWriter writer = response.getWriter();
        ImageMapUtilities.writeImageMap((PrintWriter)writer, (String)mapName, (ChartRenderingInfo)info);
        writer.flush();
        writer.close();
    }

    public void serveWaiting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince > 0L) {
            response.setStatus(304);
            return;
        }
        int w = Integer.parseInt(request.getParameter("w"));
        int h = Integer.parseInt(request.getParameter("h"));
        BufferedImage img = new BufferedImage(w, h, 5);
        Graphics g = img.getGraphics();
        g.setColor(Color.red);
        g.fillRect(0, 0, w, h);
        long now = System.currentTimeMillis();
        response.setHeader("Pragma", "");
        response.setHeader("Cache-Control", "public");
        response.addHeader("Cache-Control", "max-age=86400");
        response.setDateHeader("Last-Modified", now);
        response.setDateHeader("Date", now);
        response.setContentType("image/png");
        ServletOutputStream output = response.getOutputStream();
        EncoderUtil.writeBufferedImage((BufferedImage)img, (String)"png", (OutputStream)output);
        output.flush();
        output.close();
    }

    public void serveImage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String titleStr = request.getParameter("title");
        int w = Integer.parseInt(request.getParameter("w"));
        int h = Integer.parseInt(request.getParameter("h"));
        CachedChartData data = this.getData(request, titleStr);
        BufferedImage cachedImage = data.newImage;
        data.newImage = null;
        long lastModified = data.time;
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (lastModified / 1000L <= ifModifiedSince / 1000L) {
            this.logger.debug((Object)"serveImage(): client cache still valid: not modified (304)");
            response.setStatus(304);
            return;
        }
        if (ifModifiedSince == 0L) {
            this.logger.debug((Object)"serveImage(): no client cache: serve.");
        } else {
            this.logger.debug((Object)"serveImage(): client cache obsolete: serve.");
        }
        long now = System.currentTimeMillis();
        response.setHeader("Pragma", "");
        response.setHeader("Cache-Control", "public");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Cache-Control", "max-age=0");
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("Date", now);
        response.setContentType("image/png");
        ServletOutputStream output = response.getOutputStream();
        if (cachedImage == null) {
            cachedImage = this.makeImage(data.chart, w, h, null);
        }
        EncoderUtil.writeBufferedImage((BufferedImage)cachedImage, (String)"png", (OutputStream)output);
        output.flush();
        output.close();
    }

    public abstract Plot makePlot(HttpServletRequest var1) throws Exception;

    private CachedChartData getCache(HttpServletRequest request) {
        OpenSuitSession session = OpenSuitSession.getSession((HttpServletRequest)request);
        PageContext ctx = session.getCurrentPageContext();
        HashMap obj2Cache = (HashMap)ctx.getAttribute("_chartCache_");
        if (obj2Cache == null) {
            return null;
        }
        return (CachedChartData)obj2Cache.get(this);
    }

    private void setCache(HttpServletRequest request, CachedChartData cache) {
        OpenSuitSession session = OpenSuitSession.getSession((HttpServletRequest)request);
        PageContext ctx = session.getCurrentPageContext();
        HashMap<BaseChart, CachedChartData> obj2Cache = (HashMap<BaseChart, CachedChartData>)ctx.getAttribute("_chartCache_");
        if (obj2Cache == null) {
            obj2Cache = new HashMap<BaseChart, CachedChartData>(1);
            ctx.setAttribute("_chartCache_", obj2Cache);
        }
        obj2Cache.put(this, cache);
    }

    private void removeCache(HttpServletRequest request) {
        OpenSuitSession session = OpenSuitSession.getSession((HttpServletRequest)request);
        PageContext ctx = session.getCurrentPageContext();
        HashMap obj2Cache = (HashMap)ctx.getAttribute("_chartCache_");
        if (obj2Cache == null) {
            return;
        }
        obj2Cache.remove(this);
    }

    public Class<?> getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.parentProvider != null) {
            return this.parentProvider.getBeanType(iName);
        }
        return null;
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.parentProvider != null) {
            return this.parentProvider.getBeanGenericType(iName);
        }
        return null;
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this.parentProvider != null) {
            return this.parentProvider.getBeanValue(iRequest, iName);
        }
        return null;
    }

    public List<String> getBeanNames() {
        if (this.parentProvider != null) {
            return this.parentProvider.getBeanNames();
        }
        return new ArrayList<String>();
    }

    public String getBeanDescription(String name) {
        if (this.parentProvider != null) {
            return this.parentProvider.getBeanDescription(name);
        }
        return null;
    }

    private static class CachedChartData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public BufferedImage newImage;
        public JFreeChart chart;
        public long time;

        private CachedChartData() {
        }
    }
}

