/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xml.chart;

import java.awt.Color;
import java.awt.Paint;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.SortOrder;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.ReflectionHelper;
import org.ow2.opensuit.xml.base.action.IAction;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.chart.BaseChart;
import org.ow2.opensuit.xml.chart.CategoryChartStyle;
import org.ow2.opensuit.xml.chart.Orientation;
import org.ow2.opensuit.xml.interfaces.IBeanProvider;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlElement
public class CategoryChart
extends BaseChart
implements IBeanProvider {
    @XmlDoc(value="The name of the category contextual bean.<br>This bean is available at render-time only.<br>Default: $category.")
    @XmlAttribute(name="CategoryVar", required=false)
    private String categoryVar = "$category";
    @XmlDoc(value="The name of the serie contextual bean.<br>This bean is available at render-time only.<br>Default: $serie.")
    @XmlAttribute(name="SerieVar", required=false)
    private String serieVar = "$serie";
    @XmlDoc(value="The name of the value contextual bean.<br>This bean is available at render-time only.<br>Default: $value.")
    @XmlAttribute(name="ValueVar", required=false)
    private String valueVar = "$value";
    @XmlDoc(value="Determines the chart orientation.<br>Default: horizontal.")
    @XmlAttribute(name="Orientation", required=false)
    private Orientation orientation = Orientation.Horizontal;
    @XmlDoc(value="Determines the chart style.<br>Default: Bar.")
    @XmlAttribute(name="Style", required=false)
    private CategoryChartStyle style = CategoryChartStyle.Bar;
    @XmlDoc(value="Defines the category axis label.")
    @XmlChild(name="CategoryAxisLabel")
    protected Expression categoryAxisLabel;
    @XmlDoc(value="Defines the value axis label.")
    @XmlChild(name="ValueAxisLabel")
    protected Expression valueAxisLabel;
    @XmlDoc(value="Gives a vector of items representing the categories.")
    @XmlChild(name="Categories")
    protected Expression categories;
    @XmlDoc(value="Gives a single category name.<br>Supported contextual beans: $category")
    @XmlChild(name="CategoryName")
    protected Expression categoryName;
    @XmlDoc(value="Gives a vector of items representing the series.")
    @XmlChild(name="Series")
    protected Expression series;
    @XmlDoc(value="Gives a single serie name.<br>Supported contextual beans: $serie")
    @XmlChild(name="SerieName")
    protected Expression serieName;
    @XmlDoc(value="Gives a value for a given category and a serie.<br>Supported contextual beans: $category, $serie")
    @XmlChild(name="Value")
    protected Expression value;
    @XmlDoc(value="Defines the tooltip for a given chart value.<br>Supported contextual beans: $category, $serie, $value")
    @XmlChild(name="ValueTooltip", required=false)
    protected Expression valueTooltip;
    @XmlDoc(value="Defines the action to perform when a given chart value is clicked.<br>Supported contextual beans: $category, $serie, $value")
    @XmlChild(name="OnClickValue", required=false)
    protected IAction onClickValue;
    private Type categoryType;
    private Class<?> categoryClass;
    private Type serieType;
    private Class<?> serieClass;
    private Type valueType;
    private Class<?> valueClass;

    @Override
    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        super.initialize(initSupport, instContext);
        if (initSupport.initialize((Object)this.categories)) {
            this.categoryClass = ReflectionHelper.getVectorElementClass((Type)this.categories.getGenericType());
            if (this.categoryClass == null) {
                initSupport.addValidationMessage((Object)this, "Categories", 1, "Expression 'Categories' must return vector data.");
            } else {
                this.categoryType = ReflectionHelper.getVectorElementType((Type)this.categories.getGenericType());
            }
        }
        if (initSupport.initialize((Object)this.series)) {
            this.serieClass = ReflectionHelper.getVectorElementClass((Type)this.series.getGenericType());
            if (this.serieClass == null) {
                initSupport.addValidationMessage((Object)this, "Series", 1, "Expression 'Series' must return vector data.");
            } else {
                this.serieType = ReflectionHelper.getVectorElementType((Type)this.series.getGenericType());
            }
        }
        if (initSupport.initialize((Object)this.value)) {
            if (!this.value.isConvertible(Number.class)) {
                initSupport.addValidationMessage((Object)this, "Value", 1, "Expression 'Value' must return a Number.");
            } else {
                this.valueClass = this.value.getType();
                this.valueType = this.value.getGenericType();
            }
        }
    }

    @Override
    public Plot makePlot(HttpServletRequest request) throws Exception {
        AreaRenderer renderer;
        NumberAxis valueAxis;
        CategoryAxis categoryAxis;
        Collection categoriesObjs = ReflectionHelper.obj2Collection((Object)this.categories.invoke(request));
        if (categoriesObjs == null) {
            return null;
        }
        Collection seriesObjs = ReflectionHelper.obj2Collection((Object)this.series.invoke(request));
        if (seriesObjs == null) {
            return null;
        }
        String categoryAxisLabel = (String)this.categoryAxisLabel.invoke(request, String.class);
        String valueAxisLabel = (String)this.valueAxisLabel.invoke(request, String.class);
        PlotOrientation orientation = this.orientation.getPlotOrientation();
        ArrayList<Key> categoryKeys = new ArrayList<Key>();
        int i = 0;
        for (Object category : categoriesObjs) {
            request.setAttribute(this.categoryVar, category);
            Key catKey = new Key();
            catKey.item = category;
            catKey.name = (String)this.categoryName.invoke(request, String.class);
            catKey.index = i++;
            categoryKeys.add(catKey);
        }
        ArrayList<Key> serieKeys = new ArrayList<Key>();
        i = 0;
        for (Object serie : seriesObjs) {
            request.setAttribute(this.serieVar, serie);
            Key serKey = new Key();
            serKey.item = serie;
            serKey.name = (String)this.serieName.invoke(request, String.class);
            serKey.index = i++;
            serieKeys.add(serKey);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Key catKey : categoryKeys) {
            request.setAttribute(this.categoryVar, catKey.item);
            for (Key serKey : serieKeys) {
                request.setAttribute(this.serieVar, serKey.item);
                Number val = (Number)this.value.invoke(request, Number.class);
                dataset.setValue(val, (Comparable)serKey, (Comparable)catKey);
            }
        }
        CategoryPlot plot = null;
        if (this.style == CategoryChartStyle.Area) {
            categoryAxis = new CategoryAxis(categoryAxisLabel);
            categoryAxis.setCategoryMargin(0.0);
            valueAxis = new NumberAxis(valueAxisLabel);
            renderer = new AreaRenderer();
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(orientation);
        } else if (this.style == CategoryChartStyle.Bar) {
            ItemLabelPosition position1;
            categoryAxis = new CategoryAxis(categoryAxisLabel);
            valueAxis = new NumberAxis(valueAxisLabel);
            renderer = new BarRenderer();
            if (orientation == PlotOrientation.HORIZONTAL) {
                position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
                renderer.setBasePositiveItemLabelPosition(position1);
                ItemLabelPosition position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
                renderer.setBaseNegativeItemLabelPosition(position2);
            } else if (orientation == PlotOrientation.VERTICAL) {
                position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
                renderer.setBasePositiveItemLabelPosition(position1);
                ItemLabelPosition position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
                renderer.setBaseNegativeItemLabelPosition(position2);
            }
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(orientation);
        } else if (this.style == CategoryChartStyle.Bar3D) {
            categoryAxis = new CategoryAxis3D(categoryAxisLabel);
            valueAxis = new NumberAxis3D(valueAxisLabel);
            renderer = new BarRenderer3D();
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(orientation);
            if (orientation == PlotOrientation.HORIZONTAL) {
                plot.setRowRenderingOrder(SortOrder.DESCENDING);
                plot.setColumnRenderingOrder(SortOrder.DESCENDING);
            }
            plot.setForegroundAlpha(0.75f);
        } else if (this.style == CategoryChartStyle.Line) {
            categoryAxis = new CategoryAxis(categoryAxisLabel);
            valueAxis = new NumberAxis(valueAxisLabel);
            renderer = new LineAndShapeRenderer(true, false);
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(orientation);
        } else if (this.style == CategoryChartStyle.Line3D) {
            categoryAxis = new CategoryAxis3D(categoryAxisLabel);
            valueAxis = new NumberAxis3D(valueAxisLabel);
            renderer = new LineRenderer3D();
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(orientation);
        } else if (this.style == CategoryChartStyle.StackedBar) {
            categoryAxis = new CategoryAxis(categoryAxisLabel);
            valueAxis = new NumberAxis(valueAxisLabel);
            renderer = new StackedBarRenderer();
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(orientation);
        } else if (this.style == CategoryChartStyle.StackedBar3D) {
            categoryAxis = new CategoryAxis3D(categoryAxisLabel);
            valueAxis = new NumberAxis3D(valueAxisLabel);
            renderer = new StackedBarRenderer3D();
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(orientation);
            if (orientation == PlotOrientation.HORIZONTAL) {
                plot.setColumnRenderingOrder(SortOrder.DESCENDING);
            }
        } else {
            ItemLabelPosition position;
            categoryAxis = new CategoryAxis(categoryAxisLabel);
            categoryAxis.setCategoryMargin(0.0);
            valueAxis = new NumberAxis(valueAxisLabel);
            renderer = new WaterfallBarRenderer();
            if (orientation == PlotOrientation.HORIZONTAL) {
                position = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 1.5707963267948966);
                renderer.setBasePositiveItemLabelPosition(position);
                renderer.setBaseNegativeItemLabelPosition(position);
            } else if (orientation == PlotOrientation.VERTICAL) {
                position = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
                renderer.setBasePositiveItemLabelPosition(position);
                renderer.setBaseNegativeItemLabelPosition(position);
            }
            plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.clearRangeMarkers();
            ValueMarker baseline = new ValueMarker(0.0);
            baseline.setPaint((Paint)Color.black);
            plot.addRangeMarker((Marker)baseline, Layer.FOREGROUND);
            plot.setOrientation(orientation);
        }
        if (this.valueTooltip != null) {
            plot.getRenderer().setBaseToolTipGenerator((CategoryToolTipGenerator)new TooltipGenerator());
        } else {
            plot.getRenderer().setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (this.onClickValue != null) {
            plot.getRenderer().setBaseItemURLGenerator((CategoryURLGenerator)new URLGenerator());
        }
        return plot;
    }

    @Override
    public Class<?> getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.categoryVar.equals(iName)) {
            if (this.categoryClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.categoryClass;
        }
        if (this.serieVar.equals(iName)) {
            if (this.serieClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.serieClass;
        }
        if (this.valueVar.equals(iName)) {
            if (this.valueClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.valueClass;
        }
        return super.getBeanType(iName);
    }

    @Override
    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.categoryVar.equals(iName)) {
            if (this.categoryType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.categoryType;
        }
        if (this.serieVar.equals(iName)) {
            if (this.serieType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.serieType;
        }
        if (this.valueVar.equals(iName)) {
            if (this.valueType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.valueType;
        }
        return super.getBeanGenericType(iName);
    }

    @Override
    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this.categoryVar.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        if (this.serieVar.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        if (this.valueVar.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return super.getBeanValue(iRequest, iName);
    }

    @Override
    public List<String> getBeanNames() {
        List<String> names = super.getBeanNames();
        names.add(this.categoryVar);
        names.add(this.serieVar);
        names.add(this.valueVar);
        return names;
    }

    @Override
    public String getBeanDescription(String name) {
        if (this.categoryVar.equals(name)) {
            return "The &lt;CategoryChart&gt; category contextual bean.<br>This bean is available at render-time only.<br>Class: " + (this.categoryClass == null ? "unresolved!" : this.categoryClass.getName());
        }
        if (this.serieVar.equals(name)) {
            return "The &lt;CategoryChart&gt; series contextual bean.<br>This bean is available at render-time only.<br>Class: " + (this.serieClass == null ? "unresolved!" : this.serieClass.getName());
        }
        if (this.valueVar.equals(name)) {
            return "The &lt;CategoryChart&gt; value contextual bean.<br>This bean is available at render-time only.<br>Class: " + (this.valueClass == null ? "unresolved!" : this.valueClass.getName());
        }
        return super.getBeanDescription(name);
    }

    private class URLGenerator
    implements CategoryURLGenerator {
        private URLGenerator() {
        }

        public String generateURL(CategoryDataset dataset, int series, int category) {
            HttpServletRequest request = OpenSuitSession.getCurrentRequest();
            Key catKey = (Key)dataset.getColumnKey(category);
            Key serieKey = (Key)dataset.getRowKey(series);
            Number value = dataset.getValue(series, category);
            request.setAttribute(CategoryChart.this.categoryVar, catKey.item);
            request.setAttribute(CategoryChart.this.serieVar, serieKey.item);
            request.setAttribute(CategoryChart.this.valueVar, (Object)value);
            try {
                return CategoryChart.this.onClickValue.getURL(request, true);
            }
            catch (Exception e) {
                CategoryChart.this.logger.error((Object)"Error while evaluating onclick action.", (Throwable)e);
                return null;
            }
        }

        public boolean equals(Object obj) {
            CategoryChart.this.logger.debug((Object)"URLGenerator.equals()");
            return obj != null && obj instanceof URLGenerator;
        }
    }

    private class TooltipGenerator
    implements CategoryToolTipGenerator {
        private TooltipGenerator() {
        }

        public String generateToolTip(CategoryDataset dataset, int series, int category) {
            HttpServletRequest request = OpenSuitSession.getCurrentRequest();
            Key catKey = (Key)dataset.getColumnKey(category);
            Key serieKey = (Key)dataset.getRowKey(series);
            Number value = dataset.getValue(series, category);
            request.setAttribute(CategoryChart.this.categoryVar, catKey.item);
            request.setAttribute(CategoryChart.this.serieVar, serieKey.item);
            request.setAttribute(CategoryChart.this.valueVar, (Object)value);
            try {
                return (String)CategoryChart.this.valueTooltip.invoke(request, String.class);
            }
            catch (Exception e) {
                CategoryChart.this.logger.error((Object)"Error while evaluating item tooltip.", (Throwable)e);
                return null;
            }
        }

        public boolean equals(Object obj) {
            CategoryChart.this.logger.debug((Object)"TooltipGenerator.equals()");
            return obj != null && obj instanceof TooltipGenerator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key
    implements Comparable<Key> {
        private int index;
        private String name;
        private Object item;

        private Key() {
        }

        @Override
        public int compareTo(Key o) {
            return this.index - o.index;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Key)) {
                return false;
            }
            return this.item.equals(((Key)obj).item);
        }

        public int hashCode() {
            return this.item.hashCode();
        }
    }
}

