/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xml.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.ow2.opensuit.xml.chart.InoperantGraphics;

public class Test {
    private static final int CATEROGIES = 10;
    private static final int SERIES = 10;
    private static final int COMPUTATIONS = 10;
    private static final int WIDTH = 1000;
    private static final int HEIGHT = 500;

    public static void main(String[] args) {
        int i;
        ChartRenderingInfo info = Test.computeInfo1(Test.makeChart(Test.makeDataSet()), 1000, 500);
        System.out.println("image map: " + ImageMapUtilities.getImageMap((String)"map", (ChartRenderingInfo)info));
        System.out.println("Compute Info method 2 (inoperant Graphics object):");
        for (i = 0; i < 10; ++i) {
            Test.computeInfo2(Test.makeChart(Test.makeDataSet()), 1000, 500);
        }
        System.out.println("Compute Info method 1 (real Graphics object):");
        for (i = 0; i < 10; ++i) {
            Test.computeInfo1(Test.makeChart(Test.makeDataSet()), 1000, 500);
        }
        System.out.println("Compute Image:");
        for (i = 0; i < 10; ++i) {
            Test.makeImage(Test.makeChart(Test.makeDataSet()), 1000, 500, null);
        }
    }

    private static CategoryDataset makeDataSet() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        ArrayList<String> catKeys = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            catKeys.add("Category " + i);
        }
        ArrayList<String> serieKeys = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            serieKeys.add("Serie " + i);
        }
        for (int icat = 0; icat < catKeys.size(); ++icat) {
            for (int iser = 0; iser < serieKeys.size(); ++iser) {
                dataset.setValue((double)(icat * iser), (Comparable)serieKeys.get(iser), (Comparable)catKeys.get(icat));
            }
        }
        return dataset;
    }

    private static JFreeChart makeChart(CategoryDataset dataset) {
        return ChartFactory.createBarChart((String)"test", (String)"category", (String)"value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChartRenderingInfo computeInfo1(JFreeChart chart, int w, int h) {
        long start = System.currentTimeMillis();
        try {
            ChartRenderingInfo info = new ChartRenderingInfo();
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D g2 = img.createGraphics();
            chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h), info);
            ChartRenderingInfo chartRenderingInfo = info;
            return chartRenderingInfo;
        }
        finally {
            long end = System.currentTimeMillis();
            System.out.println(" - Chart info (" + w + "x" + h + ") computed in " + (end - start) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChartRenderingInfo computeInfo2(JFreeChart chart, int w, int h) {
        long start = System.currentTimeMillis();
        try {
            ChartRenderingInfo info = new ChartRenderingInfo();
            BufferedImage img = new BufferedImage(1, 1, 2);
            InoperantGraphics g2 = new InoperantGraphics(img.createGraphics());
            chart.draw((Graphics2D)g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h), info);
            ChartRenderingInfo chartRenderingInfo = info;
            return chartRenderingInfo;
        }
        finally {
            long end = System.currentTimeMillis();
            System.out.println(" - Chart info (" + w + "x" + h + ") computed in " + (end - start) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage makeImage(JFreeChart chart, int w, int h, ChartRenderingInfo info) {
        long start = System.currentTimeMillis();
        try {
            BufferedImage bufferedImage = chart.createBufferedImage(w, h, info);
            return bufferedImage;
        }
        finally {
            long end = System.currentTimeMillis();
            System.out.println(" - Chart image (" + w + "x" + h + ") computed in " + (end - start) + " ms");
        }
    }
}

