package org.ow2.opensuit.xml.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class Test
{
	private static int CATEROGIES = 10;
	private static int SERIES = 10;
	private static int COMPUTATIONS = 10;
	private static int WIDTH = 1000;
	private static int HEIGHT = 500;
	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		ChartRenderingInfo info = computeInfo1(makeChart(makeDataSet()), WIDTH, HEIGHT);
		System.out.println("image map: "+ImageMapUtilities.getImageMap("map", info));
		
		System.out.println("Compute Info method 2 (inoperant Graphics object):");
		for(int i=0; i<COMPUTATIONS; i++)
			computeInfo2(makeChart(makeDataSet()), WIDTH, HEIGHT);
		
		System.out.println("Compute Info method 1 (real Graphics object):");
		for(int i=0; i<COMPUTATIONS; i++)
			computeInfo1(makeChart(makeDataSet()), WIDTH, HEIGHT);
		
		System.out.println("Compute Image:");
		for(int i=0; i<COMPUTATIONS; i++)
			makeImage(makeChart(makeDataSet()), WIDTH, HEIGHT, null);
		
		
	}
	private static CategoryDataset makeDataSet()
	{
		DefaultCategoryDataset dataset = new DefaultCategoryDataset();
		
		List<String> catKeys = new ArrayList<String>();
		for(int i=0; i<CATEROGIES; i++)
			catKeys.add("Category "+i);
		
		List<String> serieKeys = new ArrayList<String>();
		for(int i=0; i<SERIES; i++)
			serieKeys.add("Serie "+i);
		
		for(int icat = 0; icat<catKeys.size(); icat++)
		{
			for(int iser = 0; iser<serieKeys.size(); iser++)
			{
				dataset.setValue(icat*iser, serieKeys.get(iser), catKeys.get(icat));
			}
		}
		
		return dataset;
	}
	private static JFreeChart makeChart(CategoryDataset dataset)
	{
		return ChartFactory.createBarChart("test", "category", "value", dataset, PlotOrientation.VERTICAL, true, true, false);
	}
	private static ChartRenderingInfo computeInfo1(JFreeChart chart, int w, int h)
	{
		long start = System.currentTimeMillis();
		try
		{
			ChartRenderingInfo info = new ChartRenderingInfo();
			BufferedImage img = new BufferedImage(1,1,BufferedImage.TYPE_INT_ARGB);
			Graphics2D g2 = img.createGraphics();
			chart.draw(g2, new Rectangle2D.Double(0, 0, w, h), info);
			return info;
		}
		finally
		{
			long end = System.currentTimeMillis();
			System.out.println(" - Chart info ("+w+"x"+h+") computed in "+(end-start)+" ms");
		}
	}
	private static ChartRenderingInfo computeInfo2(JFreeChart chart, int w, int h)
	{
		long start = System.currentTimeMillis();
		try
		{
			ChartRenderingInfo info = new ChartRenderingInfo();
			BufferedImage img = new BufferedImage(1,1,BufferedImage.TYPE_INT_ARGB);
			Graphics2D g2 = new InoperantGraphics(img.createGraphics());
			chart.draw(g2, new Rectangle2D.Double(0, 0, w, h), info);
			return info;
		}
		finally
		{
			long end = System.currentTimeMillis();
			System.out.println(" - Chart info ("+w+"x"+h+") computed in "+(end-start)+" ms");
		}
	}
	private static BufferedImage makeImage(JFreeChart chart, int w, int h, ChartRenderingInfo info)
	{
		long start = System.currentTimeMillis();
		try
		{
			return chart.createBufferedImage(w, h, info);
		}
		finally
		{
			long end = System.currentTimeMillis();
			System.out.println(" - Chart image ("+w+"x"+h+") computed in "+(end-start)+" ms");
		}
	}
}
