/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xml.chart;

import java.lang.reflect.Type;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.ReflectionHelper;
import org.ow2.opensuit.xml.base.action.IAction;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.chart.BaseChart;
import org.ow2.opensuit.xml.chart.PieChartStyle;
import org.ow2.opensuit.xml.interfaces.IBeanProvider;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlElement
public class PieChart
extends BaseChart
implements IBeanProvider {
    @XmlDoc(value="The name of the item contextual bean.<br>This bean is available at render-time only.<br>Default: $item.")
    @XmlAttribute(name="IteratorVar", required=false)
    private String iteratorVar = "$item";
    @XmlDoc(value="The name of the value contextual bean.<br>This bean is available at render-time only.<br>Default: $value.")
    @XmlAttribute(name="ValueVar", required=false)
    private String valueVar = "$value";
    @XmlDoc(value="Determines the pie style.<br>Default: TwoD.")
    @XmlAttribute(name="Style", required=false)
    private PieChartStyle style = PieChartStyle.TwoD;
    @XmlDoc(value="Gives a vector of items representing pie sectors.")
    @XmlChild(name="Items")
    protected Expression items;
    @XmlDoc(value="Evaluates the name of a given pie item.<br>Supported contextual beans: $item")
    @XmlChild(name="ItemName")
    protected Expression itemName;
    @XmlDoc(value="Evaluates the value of a given pie item.<br>Supported contextual beans: $item")
    @XmlChild(name="ItemValue")
    protected Expression itemValue;
    @XmlDoc(value="Defines the tooltip for a given pie item.<br>Supported contextual beans: $item, $value")
    @XmlChild(name="ItemTooltip", required=false)
    protected Expression itemTooltip;
    @XmlDoc(value="Defines the action to perform when a given pie item is clicked.<br>Supported contextual beans: $item, $value")
    @XmlChild(name="OnClickItem", required=false)
    protected IAction onClickItem;
    private Type itemType;
    private Class<?> itemClass;
    private Type valueType;
    private Class<?> valueClass;

    @Override
    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        super.initialize(initSupport, instContext);
        if (initSupport.initialize((Object)this.items)) {
            this.itemClass = ReflectionHelper.getVectorElementClass((Type)this.items.getGenericType());
            if (this.itemClass == null) {
                initSupport.addValidationMessage((Object)this, "Items", 1, "Expression 'Items' must return vector data.");
            } else {
                this.itemType = ReflectionHelper.getVectorElementType((Type)this.items.getGenericType());
                if (this.itemValue != null && initSupport.initialize((Object)this.itemValue)) {
                    if (!this.itemValue.isConvertible(Number.class)) {
                        initSupport.addValidationMessage((Object)this, "ItemValue", 1, "Expression 'ItemValue' must return a Number.");
                    } else {
                        this.valueType = this.itemValue.getGenericType();
                        this.valueClass = this.itemValue.getType();
                    }
                }
            }
        }
    }

    public PiePlot makePlot(HttpServletRequest request) throws Exception {
        Collection itemObjs = ReflectionHelper.obj2Collection((Object)this.items.invoke(request));
        if (itemObjs == null) {
            return null;
        }
        DefaultPieDataset dataset = new DefaultPieDataset();
        int i = 0;
        for (Object item : itemObjs) {
            request.setAttribute(this.iteratorVar, item);
            Key key = new Key();
            key.item = item;
            key.name = (String)this.itemName.invoke(request, String.class);
            key.index = i++;
            Number value = (Number)this.itemValue.invoke(request, Number.class);
            dataset.setValue((Comparable)key, value);
        }
        Object plot = null;
        plot = this.style == PieChartStyle.ThreeD ? new PiePlot3D((PieDataset)dataset) : (this.style == PieChartStyle.Ring ? new RingPlot((PieDataset)dataset) : new PiePlot((PieDataset)dataset));
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
        if (this.itemTooltip != null) {
            plot.setToolTipGenerator((PieToolTipGenerator)new TooltipGenerator());
        } else {
            OpenSuitSession session = OpenSuitSession.getSession((HttpServletRequest)request);
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator(session.getLocale()));
        }
        if (this.onClickItem != null) {
            plot.setURLGenerator((PieURLGenerator)new URLGenerator());
        }
        return plot;
    }

    @Override
    public Class<?> getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.iteratorVar.equals(iName)) {
            if (this.itemClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemClass;
        }
        if (this.valueVar.equals(iName)) {
            if (this.valueClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.valueClass;
        }
        return super.getBeanType(iName);
    }

    @Override
    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.iteratorVar.equals(iName)) {
            if (this.itemType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemType;
        }
        if (this.valueVar.equals(iName)) {
            if (this.valueType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.valueType;
        }
        return super.getBeanGenericType(iName);
    }

    @Override
    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this.iteratorVar.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        if (this.valueVar.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return super.getBeanValue(iRequest, iName);
    }

    private class URLGenerator
    implements PieURLGenerator {
        private URLGenerator() {
        }

        public String generateURL(PieDataset dataset, Comparable key, int pieIndex) {
            HttpServletRequest request = OpenSuitSession.getCurrentRequest();
            Key k = (Key)key;
            request.setAttribute(PieChart.this.iteratorVar, k.item);
            request.setAttribute(PieChart.this.valueVar, (Object)dataset.getValue(key));
            try {
                return PieChart.this.onClickItem.getURL(request, true);
            }
            catch (Exception e) {
                PieChart.this.logger.error((Object)"Error while evaluating onclick action.", (Throwable)e);
                return null;
            }
        }
    }

    private class TooltipGenerator
    implements PieToolTipGenerator {
        private TooltipGenerator() {
        }

        public String generateToolTip(PieDataset dataset, Comparable key) {
            HttpServletRequest request = OpenSuitSession.getCurrentRequest();
            Key k = (Key)key;
            request.setAttribute(PieChart.this.iteratorVar, k.item);
            request.setAttribute(PieChart.this.valueVar, (Object)dataset.getValue(key));
            try {
                return (String)PieChart.this.itemTooltip.invoke(request, String.class);
            }
            catch (Exception e) {
                PieChart.this.logger.error((Object)"Error while evaluating item tooltip.", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key
    implements Comparable<Key> {
        private String name;
        private Object item;
        private int index;

        private Key() {
        }

        @Override
        public int compareTo(Key o) {
            return this.index - o.index;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Key)) {
                return false;
            }
            return this.item.equals(((Key)obj).item);
        }

        public int hashCode() {
            return this.item.hashCode();
        }
    }
}

