/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xml.chart;

import java.lang.reflect.Type;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.ReflectionHelper;
import org.ow2.opensuit.xml.base.action.IAction;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.chart.BaseChart;
import org.ow2.opensuit.xml.chart.Orientation;
import org.ow2.opensuit.xml.chart.XYChartStyle;
import org.ow2.opensuit.xml.interfaces.IBeanProvider;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlElement
public class XYChart
extends BaseChart
implements IBeanProvider {
    @XmlDoc(value="The name of the serie contextual bean.<br>This bean is available at render-time only.<br>Default: $serie.")
    @XmlAttribute(name="SerieVar", required=false)
    private String serieVar = "$serie";
    @XmlDoc(value="The name of the x value contextual bean.<br>This bean is available at render-time only.<br>Default: $x.")
    @XmlAttribute(name="XVar", required=false)
    private String xVar = "$x";
    @XmlDoc(value="The name of the y value contextual bean.<br>This bean is available at render-time only.<br>Default: $y.")
    @XmlAttribute(name="YVar", required=false)
    private String yVar = "$y";
    @XmlDoc(value="Determines the chart style.<br>Default: XYLine.")
    @XmlAttribute(name="Style", required=false)
    private XYChartStyle style = XYChartStyle.XYLine;
    @XmlDoc(value="Determines the chart orientation.<br>Default: horizontal.")
    @XmlAttribute(name="Orientation", required=false)
    private Orientation orientation = Orientation.Horizontal;
    @XmlDoc(value="Defines the x axis label.")
    @XmlChild(name="XAxisLabel")
    protected Expression xAxisLabel;
    @XmlDoc(value="Defines the y axis label.")
    @XmlChild(name="YAxisLabel")
    protected Expression yAxisLabel;
    @XmlDoc(value="Gives a vector of items representing x,y series to display.")
    @XmlChild(name="Series")
    protected Expression series;
    @XmlDoc(value="Evaluates the name of a given serie.<br>Supported contextual beans: $serie")
    @XmlChild(name="SerieName")
    protected Expression serieName;
    @XmlDoc(value="Returns the x,y values of a given serie.<br>The expected return type is double[][].Supported contextual beans: $serie")
    @XmlChild(name="SerieValues")
    protected Expression serieValues;
    @XmlDoc(value="Defines the tooltip for a given x,y value.<br>Supported contextual beans: $serie, $x, $y")
    @XmlChild(name="ValueTooltip", required=false)
    protected Expression valueTooltip;
    @XmlDoc(value="Defines the action to perform when a given x,y value is clicked.<br>Supported contextual beans: $serie, $x, $y")
    @XmlChild(name="OnClickValue", required=false)
    protected IAction onClickValue;
    private Type itemType;
    private Class<?> itemClass;

    @Override
    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        super.initialize(initSupport, instContext);
        if (initSupport.initialize((Object)this.series)) {
            this.itemClass = ReflectionHelper.getVectorElementClass((Type)this.series.getGenericType());
            if (this.itemClass == null) {
                initSupport.addValidationMessage((Object)this, "IterateOn", 1, "Expression 'IterateOn' must return vector data.");
            } else {
                this.itemType = ReflectionHelper.getVectorElementType((Type)this.series.getGenericType());
            }
        }
    }

    @Override
    public Plot makePlot(HttpServletRequest request) throws Exception {
        XYLineAndShapeRenderer renderer;
        NumberAxis yAxis;
        NumberAxis xAxis;
        Collection itemObjs = ReflectionHelper.obj2Collection((Object)this.series.invoke(request));
        if (itemObjs == null) {
            return null;
        }
        String xAxisLabel = (String)this.xAxisLabel.invoke(request, String.class);
        String yAxisLabel = (String)this.yAxisLabel.invoke(request, String.class);
        PlotOrientation orientation = this.orientation.getPlotOrientation();
        DefaultXYDataset dataset = new DefaultXYDataset();
        int i = 0;
        for (Object item : itemObjs) {
            request.setAttribute(this.serieVar, item);
            Key key = new Key();
            key.item = item;
            key.name = (String)this.serieName.invoke(request, String.class);
            key.index = i++;
            double[][] values = (double[][])this.serieValues.invoke(request);
            dataset.addSeries((Comparable)key, values);
        }
        if (this.style == XYChartStyle.Polar) {
            PolarPlot pplot = new PolarPlot();
            pplot.setDataset((XYDataset)dataset);
            NumberAxis rangeAxis = new NumberAxis();
            rangeAxis.setAxisLineVisible(false);
            rangeAxis.setTickMarksVisible(false);
            rangeAxis.setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
            pplot.setAxis((ValueAxis)rangeAxis);
            pplot.setRenderer((PolarItemRenderer)new DefaultPolarItemRenderer());
            return pplot;
        }
        XYPlot plot = null;
        if (this.style == XYChartStyle.Scatter) {
            xAxis = new NumberAxis(xAxisLabel);
            xAxis.setAutoRangeIncludesZero(false);
            yAxis = new NumberAxis(yAxisLabel);
            yAxis.setAutoRangeIncludesZero(false);
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
            renderer = new XYLineAndShapeRenderer(false, true);
            plot.setRenderer((XYItemRenderer)renderer);
            plot.setOrientation(orientation);
        } else if (this.style == XYChartStyle.TimeSeries) {
            DateAxis timeAxis = new DateAxis(xAxisLabel);
            timeAxis.setLowerMargin(0.02);
            timeAxis.setUpperMargin(0.02);
            NumberAxis valueAxis = new NumberAxis(yAxisLabel);
            valueAxis.setAutoRangeIncludesZero(false);
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
            renderer = new XYLineAndShapeRenderer(true, false);
            plot.setRenderer((XYItemRenderer)renderer);
        } else if (this.style == XYChartStyle.XYArea) {
            xAxis = new NumberAxis(xAxisLabel);
            xAxis.setAutoRangeIncludesZero(false);
            yAxis = new NumberAxis(yAxisLabel);
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
            plot.setOrientation(orientation);
            plot.setForegroundAlpha(0.5f);
            plot.setRenderer((XYItemRenderer)new XYAreaRenderer(4));
        } else if (this.style == XYChartStyle.XYLine) {
            xAxis = new NumberAxis(xAxisLabel);
            xAxis.setAutoRangeIncludesZero(false);
            yAxis = new NumberAxis(yAxisLabel);
            renderer = new XYLineAndShapeRenderer(true, false);
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
            plot.setOrientation(orientation);
        } else if (this.style == XYChartStyle.XYStepArea) {
            xAxis = new NumberAxis(xAxisLabel);
            xAxis.setAutoRangeIncludesZero(false);
            yAxis = new NumberAxis(yAxisLabel);
            renderer = new XYStepAreaRenderer(3);
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
            plot.setRenderer((XYItemRenderer)renderer);
            plot.setOrientation(orientation);
            plot.setDomainCrosshairVisible(false);
            plot.setRangeCrosshairVisible(false);
        } else {
            xAxis = new DateAxis(xAxisLabel);
            yAxis = new NumberAxis(yAxisLabel);
            yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            renderer = new XYStepRenderer();
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
            plot.setRenderer((XYItemRenderer)renderer);
            plot.setOrientation(orientation);
            plot.setDomainCrosshairVisible(false);
            plot.setRangeCrosshairVisible(false);
        }
        if (this.valueTooltip != null) {
            plot.getRenderer().setBaseToolTipGenerator((XYToolTipGenerator)new TooltipGenerator());
        } else {
            plot.getRenderer().setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        }
        if (this.onClickValue != null) {
            plot.getRenderer().setURLGenerator((XYURLGenerator)new URLGenerator());
        }
        return plot;
    }

    @Override
    public Class<?> getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.serieVar.equals(iName)) {
            if (this.itemClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemClass;
        }
        if (this.xVar.equals(iName) || this.yVar.equals(iName)) {
            return Number.class;
        }
        return super.getBeanType(iName);
    }

    @Override
    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this.serieVar.equals(iName)) {
            if (this.itemType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemType;
        }
        if (this.xVar.equals(iName) || this.yVar.equals(iName)) {
            return Number.class;
        }
        return super.getBeanGenericType(iName);
    }

    @Override
    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this.serieVar.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        if (this.xVar.equals(iName) || this.yVar.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return super.getBeanValue(iRequest, iName);
    }

    private class URLGenerator
    implements XYURLGenerator {
        private URLGenerator() {
        }

        public String generateURL(XYDataset dataset, int series, int item) {
            HttpServletRequest request = OpenSuitSession.getCurrentRequest();
            Key serieKey = (Key)dataset.getSeriesKey(series);
            Number x = dataset.getX(series, item);
            Number y = dataset.getY(series, item);
            request.setAttribute(XYChart.this.serieVar, serieKey.item);
            request.setAttribute(XYChart.this.xVar, (Object)x);
            request.setAttribute(XYChart.this.yVar, (Object)y);
            try {
                return XYChart.this.onClickValue.getURL(request, true);
            }
            catch (Exception e) {
                XYChart.this.logger.error((Object)"Error while evaluating onclick action.", (Throwable)e);
                return null;
            }
        }
    }

    private class TooltipGenerator
    implements XYToolTipGenerator {
        private TooltipGenerator() {
        }

        public String generateToolTip(XYDataset dataset, int series, int item) {
            HttpServletRequest request = OpenSuitSession.getCurrentRequest();
            Key serieKey = (Key)dataset.getSeriesKey(series);
            Number x = dataset.getX(series, item);
            Number y = dataset.getY(series, item);
            request.setAttribute(XYChart.this.serieVar, serieKey.item);
            request.setAttribute(XYChart.this.xVar, (Object)x);
            request.setAttribute(XYChart.this.yVar, (Object)y);
            try {
                return (String)XYChart.this.valueTooltip.invoke(request, String.class);
            }
            catch (Exception e) {
                XYChart.this.logger.error((Object)"Error while evaluating item tooltip.", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key
    implements Comparable<Key> {
        private String name;
        private Object item;
        private int index;

        private Key() {
        }

        @Override
        public int compareTo(Key o) {
            return this.index - o.index;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Key)) {
                return false;
            }
            return this.item.equals(((Key)obj).item);
        }

        public int hashCode() {
            return this.item.hashCode();
        }
    }
}

