package org.ow2.opensuit.samples.movies_db.uibeans;

import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;



/**
 * This bean holds a list of movies.
 * 
 * It is initilized either by loading all movies from the database, or
 * by searching movies by title or director name.
 * 
 * <p>This version of the bean performs the search when loading, then
 * lets the framework manage sort and pagination.
 * This design may only be used if you're sure the amount of data is "reasonable"
 * and under control.
 */
public class ListOfMoviesBean3
{
	// ==========================================================
	// === Attributes
	// ==========================================================
	private String title;
	private String director;
	private MovieTO[] movies;
	
	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads all movies from the database
	 */
	public void loadAll() throws LocalizedError
	{
		try
        {
	        movies = MoviesDataBase.getDataBase().getAllMovies(null);
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
	}
	/**
	 * Searches movies by title
	 */
	public String searchByTitle() throws LocalizedError
	{
		try
        {
	        movies = MoviesDataBase.getDataBase().searchMovieByTitle(title, null);
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		
        if(movies == null || movies.length == 0){
			return "zero";
		}
		
		if(movies.length == 1){
			return "one";
		}
		
		return "several";
	}
	/**
	 * Searches movies by director name
	 */
	public String searchByDirector() throws LocalizedError
	{
		try
        {
	        movies = MoviesDataBase.getDataBase().searchMoviesByDirector(director, null);
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		
        if(movies == null || movies.length == 0){
			return "zero";
		}
		
		if(movies.length == 1){
			return "one";
		}
		
		return "several";
	}
	/**
	 * Resets the list
	 */
	public void reset()
	{
		movies = null;
		director = null;
		title = null;
	}
	/**
	 * Determines whether a list should be displayed
	 */
	public boolean hasList()
	{
		return movies != null;
	}
	// ==========================================================
	// === Attributes Getters & Setters
	// ==========================================================
	public String getDirector()
    {
    	return director;
    }

	public void setDirector(String author)
    {
    	this.director = author;
    }

	public String getTitle()
    {
    	return title;
    }

	public void setTitle(String title)
    {
    	this.title = title;
    }

	public MovieTO[] getMovies() throws LocalizedError
    {
		return movies;
    }
}
