package org.ow2.opensuit.samples.movies_db.uibeans;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;



/**
 * This is a UI bean that represents a movie.
 */
public class MovieBean
{
	// ==========================================================
	// === Attributes
	// ==========================================================
	private MovieTO movie;
	private int directorId;
	private String frenchTitle;
	private String originalTitle;
	private Date releaseDate;
	
	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads a movie from the request parameted 'id'.
	 */
	public void load(HttpServletRequest iRequest) throws LocalizedError
	{
		int id = Integer.parseInt(iRequest.getParameter("id"));
		try
        {
	        movie = MoviesDataBase.getDataBase().getMovie(id);
        }
        catch(DataBaseError e)
        {
			if(e.getCode() == DataBaseError.DATA_NOT_FOUND_ERROR){
				throw new LocalizedError("movie_not_found", new Object[]{id});
			}

			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		
		reset();
	}
	/**
	 * Saves the current movie with changes.
	 */
	public String save() throws LocalizedError
	{
		PersonTO director = null;
        try
        {
	        director = MoviesDataBase.getDataBase().getDirector(directorId);
        }
        catch(DataBaseError e)
        {
			if(e.getCode() == DataBaseError.DATA_NOT_FOUND_ERROR){
				throw new LocalizedError("director_not_found", new Object[]{directorId});
			}

			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		MovieTO newMovie = new MovieTO();
		newMovie.setId(movie.getId());
		// TODO: il ne devrait pas y avoir besoin de faire un appel en base
		newMovie.setDirector(director);
		newMovie.setFrenchTitle(frenchTitle);
		newMovie.setOriginalTitle(originalTitle);
		newMovie.setReleaseDate(releaseDate);
		
		try
        {
	        MoviesDataBase.getDataBase().setMovie(newMovie);
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		
		movie = newMovie;
		return "success";
	}
	/**
	 * Creates a movie object with current attributes
	 */
	public String create() throws LocalizedError
	{
		PersonTO director = null;
        try
        {
	        director = MoviesDataBase.getDataBase().getDirector(directorId);
        }
        catch(DataBaseError e)
        {
			if(e.getCode() == DataBaseError.DATA_NOT_FOUND_ERROR){
				throw new LocalizedError("director_not_found", new Object[]{directorId});
			}

			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		MovieTO newMovie = new MovieTO();
		// TODO: il ne devrait pas y avoir besoin de faire un appel en base
		newMovie.setDirector(director);
		newMovie.setFrenchTitle(frenchTitle);
		newMovie.setOriginalTitle(originalTitle);
		newMovie.setReleaseDate(releaseDate);
		
		try
        {
	        MoviesDataBase.getDataBase().setMovie(newMovie);
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		
		movie = newMovie;
		return "success";
	}
	/**
	 * Deletes the current movie from the database
	 */
	public String delete() throws LocalizedError
	{
		try
        {
	        MoviesDataBase.getDataBase().removeMovie(movie.getId());
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		return "success";
	}
	/**
	 * Resets changes made to the current movie attributes.
	 */
	public void reset()
	{
		directorId = movie.getDirector() == null ? 0 : movie.getDirector().getId();
		frenchTitle = movie.getFrenchTitle();
		originalTitle = movie.getOriginalTitle();
		releaseDate = movie.getReleaseDate();
	}
	/**
	 * Clears the movie.
	 */
	public void clear()
	{
		movie = new MovieTO();
		reset();
	}
	// ==========================================================
	// === Attributes Getters & Setters
	// ==========================================================
	public Date getReleaseDate()
    {
    	return releaseDate;
    }

	public void setReleaseDate(Date firstEdited)
    {
    	this.releaseDate = firstEdited;
    }

	public int getId()
    {
		if(movie == null){
			return 0;
		}
		
		return movie.getId();
    }

	public String getOriginalTitle()
    {
    	return originalTitle;
    }

	public void setOriginalTitle(String language)
    {
    	this.originalTitle = language;
    }

	public String getFrenchTitle()
    {
    	return frenchTitle;
    }

	public void setFrenchTitle(String title)
    {
    	this.frenchTitle = title;
    }
	public int getDirectorId()
    {
    	return directorId;
    }
	public void setDirectorId(int directorId)
    {
    	this.directorId = directorId;
    }
	

}
