/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.uibeans;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;

public class DirectorBean2 {
    private PersonTO director;
    private MovieTO[] movies;
    private String name;
    private String nationality;
    private Date birth;
    private Date death;

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        try {
            this.director = MoviesDataBase.getDataBase().getDirector(id);
            this.movies = MoviesDataBase.getDataBase().getMoviesFromDirector(this.director.getId(), null);
            this.reset();
        }
        catch (DataBaseError e) {
            if (e.getCode() == 1) {
                throw new LocalizedError("director_not_found", new Object[]{id});
            }
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String save() throws LocalizedError {
        PersonTO newDirector = new PersonTO();
        newDirector.setId(this.director.getId());
        newDirector.setName(this.name);
        newDirector.setNationality(this.nationality);
        newDirector.setBirth(this.birth);
        newDirector.setDeath(this.death);
        try {
            MoviesDataBase.getDataBase().setDirector(newDirector);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.director = newDirector;
        return "success";
    }

    public String create() throws LocalizedError {
        PersonTO newDirector = new PersonTO();
        newDirector.setName(this.name);
        newDirector.setNationality(this.nationality);
        newDirector.setBirth(this.birth);
        newDirector.setDeath(this.death);
        try {
            MoviesDataBase.getDataBase().setDirector(newDirector);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.director = newDirector;
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            MoviesDataBase.getDataBase().removeMovie(this.director.getId());
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        this.name = this.director.getName();
        this.nationality = this.director.getNationality();
        this.birth = this.director.getBirth();
        this.death = this.director.getDeath();
    }

    public void clear() {
        this.director = new PersonTO();
        this.reset();
    }

    public void validate() throws ValidationErrors {
        if (this.birth != null && this.death != null && this.death.before(this.birth)) {
            ValidationErrors errors = new ValidationErrors();
            errors.addItemError("directorBean.death", (ValidationError)new LocalizedValidationError("validation.death_after_birth.message"));
            throw errors;
        }
    }

    public int getId() {
        if (this.director == null) {
            return 0;
        }
        return this.director.getId();
    }

    public Date getBirth() {
        return this.birth;
    }

    public void setBirth(Date birth) {
        this.birth = birth;
    }

    public Date getDeath() {
        return this.death;
    }

    public void setDeath(Date death) {
        this.death = death;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public MovieTO[] getMovies() {
        return this.movies;
    }
}

