/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.uibeans;

import java.util.ArrayList;
import java.util.List;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfMoviesBean5 {
    private String title;
    private String director;
    private MovieTO[] movies;
    private int[] selected;

    public void loadAll() throws LocalizedError {
        try {
            this.movies = MoviesDataBase.getDataBase().getAllMovies(null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String searchByTitle() throws LocalizedError {
        try {
            this.movies = MoviesDataBase.getDataBase().searchMovieByTitle(this.title, null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.movies == null || this.movies.length == 0) {
            return "zero";
        }
        if (this.movies.length == 1) {
            return "one";
        }
        return "several";
    }

    public String searchByDirector() throws LocalizedError {
        try {
            this.movies = MoviesDataBase.getDataBase().searchMoviesByDirector(this.director, null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.movies == null || this.movies.length == 0) {
            return "zero";
        }
        if (this.movies.length == 1) {
            return "one";
        }
        return "several";
    }

    public String checkDelete() {
        if (this.selected == null || this.selected.length == 0) {
            System.out.println("No movie selected");
            return "no_movie";
        }
        System.out.println("Selected movies:");
        for (int i = 0; i < this.selected.length; ++i) {
            System.out.println(" -" + i + ": " + this.selected[i]);
        }
        return "success";
    }

    public String delete() throws DataBaseError, LocalizedError {
        if (this.selected != null && this.selected.length > 0) {
            for (int i = 0; i < this.selected.length; ++i) {
                MoviesDataBase.getDataBase().removeMovie(this.selected[i]);
            }
            this.loadAll();
            this.selected = null;
        }
        return "success";
    }

    public void reset() {
        this.movies = null;
        this.director = null;
        this.title = null;
    }

    public boolean hasList() {
        return this.movies != null;
    }

    public List<String> suggestDirectorNames(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        try {
            PersonTO[] directors = MoviesDataBase.getDataBase().searchDirectorByName(name, null);
            ArrayList<String> suggestions = new ArrayList<String>(directors.length);
            for (PersonTO d : directors) {
                suggestions.add(d.getName());
            }
            return suggestions;
        }
        catch (DataBaseError dataBaseError) {
            return null;
        }
    }

    public List<String> suggestMovieTitles(String title) {
        if (title == null) {
            return null;
        }
        if ((title = title.trim()).length() == 0) {
            return null;
        }
        try {
            MovieTO[] movies = MoviesDataBase.getDataBase().searchMovieByTitle(title, null);
            ArrayList<String> suggestions = new ArrayList<String>(movies.length);
            for (MovieTO t : movies) {
                suggestions.add(t.getOriginalTitle());
            }
            return suggestions;
        }
        catch (DataBaseError dataBaseError) {
            return null;
        }
    }

    public String getDirector() {
        return this.director;
    }

    public void setDirector(String author) {
        this.director = author;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public MovieTO[] getMovies() throws LocalizedError {
        return this.movies;
    }

    public int[] getSelected() {
        return this.selected;
    }

    public void setSelected(int[] selected) {
        if (selected != null) {
            this.selected = (int[])selected.clone();
        }
    }
}

