/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.uibeans;

import java.util.ArrayList;
import java.util.List;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfDirectorsBean2 {
    private String name;
    private PersonTO[] directors;

    public void loadAll() throws LocalizedError {
        try {
            this.directors = MoviesDataBase.getDataBase().getAllDirectors(null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String searchByName() throws LocalizedError {
        try {
            this.directors = MoviesDataBase.getDataBase().searchDirectorByName(this.name, null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.directors == null || this.directors.length == 0) {
            return "zero";
        }
        if (this.directors.length == 1) {
            return "one";
        }
        return "several";
    }

    public void delete(String id) throws DataBaseError, LocalizedError {
        MoviesDataBase.getDataBase().removeDirector(Integer.parseInt(id));
        this.loadAll();
    }

    public void reset() {
        this.directors = null;
        this.name = null;
    }

    public boolean hasList() {
        return this.directors != null;
    }

    public List<String> suggestDirectorNames(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        try {
            PersonTO[] directors = MoviesDataBase.getDataBase().searchDirectorByName(name, null);
            ArrayList<String> suggestions = new ArrayList<String>(directors.length);
            for (PersonTO d : directors) {
                suggestions.add(d.getName());
            }
            return suggestions;
        }
        catch (DataBaseError dataBaseError) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PersonTO[] getDirectors() {
        return this.directors;
    }
}

