/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.uibeans;

import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;

public class ListOfMoviesBean3 {
    private String title;
    private String director;
    private MovieTO[] movies;

    public void loadAll() throws LocalizedError {
        try {
            this.movies = MoviesDataBase.getDataBase().getAllMovies(null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String searchByTitle() throws LocalizedError {
        try {
            this.movies = MoviesDataBase.getDataBase().searchMovieByTitle(this.title, null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.movies == null || this.movies.length == 0) {
            return "zero";
        }
        if (this.movies.length == 1) {
            return "one";
        }
        return "several";
    }

    public String searchByDirector() throws LocalizedError {
        try {
            this.movies = MoviesDataBase.getDataBase().searchMoviesByDirector(this.director, null);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.movies == null || this.movies.length == 0) {
            return "zero";
        }
        if (this.movies.length == 1) {
            return "one";
        }
        return "several";
    }

    public void reset() {
        this.movies = null;
        this.director = null;
        this.title = null;
    }

    public boolean hasList() {
        return this.movies != null;
    }

    public String getDirector() {
        return this.director;
    }

    public void setDirector(String author) {
        this.director = author;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public MovieTO[] getMovies() throws LocalizedError {
        return this.movies;
    }
}

