/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.uibeans;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;

public class MovieBean {
    private MovieTO movie;
    private int directorId;
    private String frenchTitle;
    private String originalTitle;
    private Date releaseDate;

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        try {
            this.movie = MoviesDataBase.getDataBase().getMovie(id);
        }
        catch (DataBaseError e) {
            if (e.getCode() == 1) {
                throw new LocalizedError("movie_not_found", new Object[]{id});
            }
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    public String save() throws LocalizedError {
        PersonTO director = null;
        try {
            director = MoviesDataBase.getDataBase().getDirector(this.directorId);
        }
        catch (DataBaseError e) {
            if (e.getCode() == 1) {
                throw new LocalizedError("director_not_found", new Object[]{this.directorId});
            }
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        MovieTO newMovie = new MovieTO();
        newMovie.setId(this.movie.getId());
        newMovie.setDirector(director);
        newMovie.setFrenchTitle(this.frenchTitle);
        newMovie.setOriginalTitle(this.originalTitle);
        newMovie.setReleaseDate(this.releaseDate);
        try {
            MoviesDataBase.getDataBase().setMovie(newMovie);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.movie = newMovie;
        return "success";
    }

    public String create() throws LocalizedError {
        PersonTO director = null;
        try {
            director = MoviesDataBase.getDataBase().getDirector(this.directorId);
        }
        catch (DataBaseError e) {
            if (e.getCode() == 1) {
                throw new LocalizedError("director_not_found", new Object[]{this.directorId});
            }
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        MovieTO newMovie = new MovieTO();
        newMovie.setDirector(director);
        newMovie.setFrenchTitle(this.frenchTitle);
        newMovie.setOriginalTitle(this.originalTitle);
        newMovie.setReleaseDate(this.releaseDate);
        try {
            MoviesDataBase.getDataBase().setMovie(newMovie);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.movie = newMovie;
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            MoviesDataBase.getDataBase().removeMovie(this.movie.getId());
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        this.directorId = this.movie.getDirector() == null ? 0 : this.movie.getDirector().getId();
        this.frenchTitle = this.movie.getFrenchTitle();
        this.originalTitle = this.movie.getOriginalTitle();
        this.releaseDate = this.movie.getReleaseDate();
    }

    public void clear() {
        this.movie = new MovieTO();
        this.reset();
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date firstEdited) {
        this.releaseDate = firstEdited;
    }

    public int getId() {
        if (this.movie == null) {
            return 0;
        }
        return this.movie.getId();
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String language) {
        this.originalTitle = language;
    }

    public String getFrenchTitle() {
        return this.frenchTitle;
    }

    public void setFrenchTitle(String title) {
        this.frenchTitle = title;
    }

    public int getDirectorId() {
        return this.directorId;
    }

    public void setDirectorId(int directorId) {
        this.directorId = directorId;
    }
}

