/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.uibeans;

import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.table.ITableRenderingContext;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.RequestOptions;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;

public class ListOfMoviesBean4 {
    private String title;
    private String director;
    private int moviesCount = -1;

    public void loadAll() throws LocalizedError {
        try {
            this.moviesCount = MoviesDataBase.getDataBase().countAllMovies();
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String searchByTitle() throws LocalizedError {
        try {
            this.moviesCount = MoviesDataBase.getDataBase().countMovieByTitle(this.title);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.moviesCount == 0) {
            return "zero";
        }
        if (this.moviesCount == 1) {
            return "one";
        }
        return "several";
    }

    public String searchByDirector() throws LocalizedError {
        try {
            this.moviesCount = MoviesDataBase.getDataBase().countMoviesByDirector(this.director);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (this.moviesCount == 0) {
            return "zero";
        }
        if (this.moviesCount == 1) {
            return "one";
        }
        return "several";
    }

    public void reset() {
        this.moviesCount = -1;
        this.director = null;
        this.title = null;
    }

    public boolean hasList() {
        return this.moviesCount >= 0;
    }

    public String getDirector() {
        return this.director;
    }

    public void setDirector(String author) {
        this.director = author;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public MovieTO[] getMovies() throws LocalizedError {
        RequestOptions options = null;
        ITableRenderingContext ctx = ITableRenderingContext.get(null);
        if (ctx != null) {
            options = new RequestOptions();
            if (ctx.hasPagination()) {
                options.setFirstResult(ctx.getFirstIndex());
                options.setNbOfResults(ctx.getRowsPerPage());
            }
            if (ctx.hasSortedColumn()) {
                switch (ctx.getSortColumn()) {
                    case 0: {
                        options.setSortCriteria(1);
                        break;
                    }
                    case 1: {
                        options.setSortCriteria(2);
                        break;
                    }
                    case 2: {
                        options.setSortCriteria(3);
                        break;
                    }
                    case 3: {
                        options.setSortCriteria(4);
                        break;
                    }
                    case 4: {
                        options.setSortCriteria(5);
                    }
                }
                options.setSortAscendingly(ctx.getSortDirection());
            }
        }
        try {
            if (this.title != null) {
                if (ctx != null) {
                    ctx.setRowsCount(MoviesDataBase.getDataBase().countMovieByTitle(this.title));
                }
                return MoviesDataBase.getDataBase().searchMovieByTitle(this.title, options);
            }
            if (this.director != null) {
                if (ctx != null) {
                    ctx.setRowsCount(MoviesDataBase.getDataBase().countMoviesByDirector(this.director));
                }
                return MoviesDataBase.getDataBase().searchMoviesByDirector(this.director, options);
            }
            if (ctx != null) {
                ctx.setRowsCount(MoviesDataBase.getDataBase().countAllMovies());
            }
            return MoviesDataBase.getDataBase().getAllMovies(options);
        }
        catch (DataBaseError e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }
}

