package org.ow2.opensuit.samples.movies_db.uibeans;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;



/**
 * This is a UI bean that represents a director.
 */
public class DirectorBean
{
	// ==========================================================
	// === Attributes
	// ==========================================================
	private PersonTO director;
	private MovieTO[] movies;
	private String name;
	private String nationality;
	private Date birth;
	private Date death;
	
	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads a director from the request parameted 'id'.
	 */
	public void load(HttpServletRequest iRequest) throws LocalizedError
	{
		int id = Integer.parseInt(iRequest.getParameter("id"));
		try
		{
			director = MoviesDataBase.getDataBase().getDirector(id);
			
			movies = MoviesDataBase.getDataBase().getMoviesFromDirector(director.getId(), null);
			
			reset();
		}
		catch(DataBaseError e)
		{
			if(e.getCode() == DataBaseError.DATA_NOT_FOUND_ERROR)
				throw new LocalizedError("director_not_found", new Object[]{id});

			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
		}
	}
	/**
	 * Saves the current director with changes.
	 */
	public String save() throws LocalizedError
	{
		PersonTO newDirector = new PersonTO();
		newDirector.setId(director.getId());
		newDirector.setName(name);
		newDirector.setNationality(nationality);
		newDirector.setBirth(birth);
		newDirector.setDeath(death);
		
		try
		{
			MoviesDataBase.getDataBase().setDirector(newDirector);
		}
		catch(DataBaseError e)
		{
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
		}
		
		director = newDirector;
		return "success";
	}
	/**
	 * Creates a director object with current attributes
	 */
	public String create() throws LocalizedError
	{
		PersonTO newDirector = new PersonTO();
		
		newDirector.setName(name);
		newDirector.setNationality(nationality);
		newDirector.setBirth(birth);
		newDirector.setDeath(death);
		
		try
		{
			MoviesDataBase.getDataBase().setDirector(newDirector);
		}
		catch(DataBaseError e)
		{
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
		}
		
		director = newDirector;
		return "success";
	}
	/**
	 * Deletes the current director from the database
	 */
	public String delete() throws LocalizedError
	{
		try
        {
	        MoviesDataBase.getDataBase().removeMovie(director.getId());
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
		return "success";
	}
	/**
	 * Resets changes made to the current director attributes.
	 */
	public void reset()
	{
		name = director.getName();
		nationality = director.getNationality();
		birth = director.getBirth();
		death = director.getDeath();
	}
	/**
	 * Clears the director.
	 */
	public void clear()
	{
		director = new PersonTO();
		reset();
	}
	// ==========================================================
	// === Attributes Getters & Setters
	// ==========================================================
	public int getId()
    {
		if(director == null)
			return 0;
		return director.getId();
    }
	public Date getBirth()
    {
    	return birth;
    }
	public void setBirth(Date birth)
    {
    	this.birth = birth;
    }
	public Date getDeath()
    {
    	return death;
    }
	public void setDeath(Date death)
    {
    	this.death = death;
    }
	public String getName()
    {
    	return name;
    }
	public void setName(String name)
    {
    	this.name = name;
    }
	public String getNationality()
    {
    	return nationality;
    }
	public void setNationality(String nationality)
    {
    	this.nationality = nationality;
    }
	public MovieTO[] getMovies()
    {
    	return movies;
    }
}
