package org.ow2.opensuit.samples.movies_db.uibeans;

import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;



/**
 * This bean holds a list of directors.
 * 
 * It initializes itself by loading all directors from the database.
 * 
 * <p>This version of the bean performs the search when loading, then
 * lets the framework manage sort and pagination.
 * This design may only be used if you're sure the amount of data is "reasonable"
 * and under control.
 * <p>See SearchMovieBean2 for a dynamic version of it (that have the model
 * layer manage sorting and pagination).
 */
public class ListOfDirectorsBean1
{
	// ==========================================================
	// === Attributes
	// ==========================================================
	private PersonTO[] directors;
	
	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads all directors from the database
	 */
	public void loadAll() throws LocalizedError
	{
		try
        {
	        directors = MoviesDataBase.getDataBase().getAllDirectors(null);
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
	}

	// ==========================================================
	// === Attributes Getters & Setters
	// ==========================================================
	public PersonTO[] getDirectors()
    {
    	return directors;
    }
}
