package org.ow2.opensuit.samples.movies_db.uibeans;

import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.table.ITableRenderingContext;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.MoviesDataBase;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.RequestOptions;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;



/**
 * This bean holds a list of movies.
 * 
 * It initializes itself by loading all movies from the database.
 * 
 * <p>This version of the bean performs the search operation at each rendering,
 * including sort and pagination.
 */
public class ListOfMoviesBean2
{
	// ==========================================================
	// === Attributes
	// ==========================================================
	private int moviesCount;
	
	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads all movies from the database
	 */
	public void loadAll() throws LocalizedError
	{
		try
        {
	        moviesCount = MoviesDataBase.getDataBase().countAllMovies();
        }
        catch(DataBaseError e)
        {
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
	}
	// ==========================================================
	// === Attributes Getters & Setters
	// ==========================================================
	public MovieTO[] getMovies() throws LocalizedError
    {
		// --- the search request is performed here, with sort and pagination options
		RequestOptions options = null;
		ITableRenderingContext ctx = ITableRenderingContext.get(null);
		if(ctx != null)
		{
			options = new RequestOptions();
			if(ctx.hasPagination())
			{
				options.setFirstResult(ctx.getFirstIndex());
				options.setNbOfResults(ctx.getRowsPerPage());
			}
			
			if(ctx.hasSortedColumn())
			{
				switch(ctx.getSortColumn())
				{
					case 0: //ID
						options.setSortCriteria(MoviesDataBase.SORT_BY_ID);
						break;
					case 1: // French Title
						options.setSortCriteria(MoviesDataBase.SORT_BY_FRENCH_TITLE);
						break;
					case 2: // Original Title
						options.setSortCriteria(MoviesDataBase.SORT_BY_ORIGINAL_TITLE);
						break;
					case 3: // Director
						options.setSortCriteria(MoviesDataBase.SORT_BY_DIRECTOR);
						break;
					case 4: // Release Date
						options.setSortCriteria(MoviesDataBase.SORT_BY_RELEASE_DATE);
						break;
				}
				options.setSortAscendingly(ctx.getSortDirection());
			}
		}
		
		try
		{
			// --- get all movies
			if(ctx != null)
				ctx.setRowsCount(MoviesDataBase.getDataBase().countAllMovies());
			return MoviesDataBase.getDataBase().getAllMovies(options);
		}
		catch(DataBaseError e)
		{
			throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
		}
    }
}
