package org.ow2.opensuit.samples.movies_db.xml;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.xml.base.validation.IValidator;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;


@XmlElement
public class IsCountry implements IValidator, IInitializable
{
	private static HashMap<String, Boolean> COUNTRIES = new HashMap<String, Boolean>();
	static
	{
		COUNTRIES.put("France", Boolean.TRUE);
		COUNTRIES.put("Japan", Boolean.TRUE);
		COUNTRIES.put("Russia", Boolean.TRUE);
		COUNTRIES.put("England", Boolean.TRUE);
		COUNTRIES.put("Poland", Boolean.TRUE);
		COUNTRIES.put("Italy", Boolean.TRUE);
		COUNTRIES.put("Denmark", Boolean.TRUE);
		COUNTRIES.put("USA", Boolean.TRUE);
		COUNTRIES.put("Germany", Boolean.TRUE);
		COUNTRIES.put("Austria", Boolean.TRUE);
		COUNTRIES.put("Sweden", Boolean.TRUE);
	}
	public void initialize(IInitializationSupport errors, IInstantiationContext instContext)
	{
	}
	/**
	 * Checks that this component is bound to a compatible value type
	 */
	public boolean isTypeValid(Class iClass)
	{
	    return iClass == String.class;
	}
	public void checkValidity(Object value) throws ValidationError
	{
		if(COUNTRIES.get(value) == null)
		{
			throw new ValidationError() {
				public String getMessage(HttpServletRequest request)
				{
					return "Unknown country";
				}
			};
		}
	}
}
