package org.ow2.opensuit.samples.movies_db.xml;

import java.io.PrintWriter;
import java.util.Locale;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.session.ILocaleConfig;
import org.ow2.opensuit.core.util.OpenSuitUrlBuilder;
import org.ow2.opensuit.core.util.UrlBuilder;
import org.ow2.opensuit.xml.base.Application;
import org.ow2.opensuit.xml.base.html.IView;
import org.ow2.opensuit.xmlmap.annotations.XmlAncestor;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;


@XmlElement
public class LanguageBar implements IView, IInitializable
{
	@XmlAncestor
	private Application application;
	
	public void initialize(IInitializationSupport errors, IInstantiationContext instContext)
	{
		// --- register this as a request handler
		application.registerRequestHandler("langbar", this);
	}
	public void preRender(HttpServletRequest request) throws Exception
	{
	}
	public void render(HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		Locale currentLocale = response.getLocale();
		ILocaleConfig[] languages = application.getAllLanguages();
		PrintWriter writer = response.getWriter();
		
		UrlBuilder changeLanguageUrl = application.createHandlerUrl(request, this, "onChange");
		
		writer.print("<div class=LanguageBar>");
		writer.println("<ul>");
		for(int i=0; i<languages.length; i++)
		{
			writer.print("<li>");
			if(currentLocale.getLanguage().equals(languages[i].getLocale().getLanguage()))
			{
				writer.print(languages[i].getLocale().getDisplayLanguage(currentLocale));
			}
			else
			{
				changeLanguageUrl.setParameter("_lang", languages[i].getLocale().getLanguage());
				writer.print("<a href='");
				writer.print(changeLanguageUrl.toUrl(response.getCharacterEncoding(), true));
				writer.print("'>");
				writer.print(languages[i].getLocale().getDisplayLanguage(currentLocale));
				writer.print("</a>");
			}
			writer.println("</li>");
		}
		writer.println("</ul></div>");
	}
	/**
	 * Callbacked method when the user selects a language.
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void onChange(HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		// --- retrieve language and set as current language (in the cookie)
		String lang = request.getParameter("_lang");
		Cookie langCookie = new Cookie("lang", lang);
		response.addCookie(langCookie);
		
		// --- then redirect to let open SUIT take the new language into account
		OpenSuitUrlBuilder url = OpenSuitUrlBuilder.copyFromRequest(request, true);
		response.sendRedirect(url.toUrl(response.getCharacterEncoding(), false));
	}
}
