package org.ow2.opensuit.samples.movies_db.xml;

import java.net.URLEncoder;

import org.ow2.opensuit.xmlmap.annotations.XmlEnumeration;


@XmlEnumeration
public abstract class SearchEngines
{
	public abstract String getSearchMovieUrl(String title);
	
	public abstract String getSearchDirectorUrl(String title);
	
	/**
	 * Allocine Search Engine
	 */
	public static SearchEngines ALLOCINE = new SearchEngines()
	{
		@Override
		public String getSearchMovieUrl(String title)
		{
		    return "http://www.allocine.fr/recherche/?rub=1&motcle="+URLEncoder.encode(title);
		}
		@Override
		public String getSearchDirectorUrl(String name)
		{
		    return "http://www.allocine.fr/recherche/?rub=2&motcle="+URLEncoder.encode(name);
		}		
	};
	/**
	 * IMDB Search Engine
	 */
	public static SearchEngines IMDB = new SearchEngines()
	{
		@Override
		public String getSearchMovieUrl(String title)
		{
		    return "http://www.imdb.com/find?s=tt&q="+URLEncoder.encode(title);
		}
		@Override
		public String getSearchDirectorUrl(String name)
		{
		    return "http://www.imdb.com/find?s=nm&q="+URLEncoder.encode(name);
		}		
	};
	/**
	 * Allmovie Search Engine
	 */
	public static SearchEngines ALLMOVIE = new SearchEngines()
	{
		@Override
		public String getSearchMovieUrl(String title)
		{
		    return "http://www.allmovie.com/cg/avg.dll?p=avg&opt1=6&sql="+URLEncoder.encode(title);
		}
		@Override
		public String getSearchDirectorUrl(String name)
		{
		    return "http://www.allmovie.com/cg/avg.dll?p=avg&opt1=6&sql="+URLEncoder.encode(name);
		}		
	};
}
