/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.model.dataaccess;

import java.util.ArrayList;

class ExactStringTokenizer {
    private static String[] STRING_ARRAY = new String[0];
    private String str;
    private int curTokenPos;
    private int nextDelimPos;
    private char delim;

    public static String[] split(String iString, char delim) {
        ArrayList<String> ret = new ArrayList<String>();
        ExactStringTokenizer st = new ExactStringTokenizer(iString, delim);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(STRING_ARRAY);
    }

    public ExactStringTokenizer(String iString, char delim) {
        this.str = iString;
        this.delim = delim;
        this.reinit();
    }

    private void reinit() {
        this.curTokenPos = 0;
        this.nextDelimPos = Integer.MIN_VALUE;
    }

    public boolean hasMoreTokens() {
        if (this.nextDelimPos == Integer.MIN_VALUE) {
            this.nextDelimPos = this.str.indexOf(this.delim, this.curTokenPos);
        }
        return this.nextDelimPos >= 0 || this.curTokenPos <= this.str.length();
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            return null;
        }
        String ret = null;
        if (this.nextDelimPos >= 0) {
            ret = this.str.substring(this.curTokenPos, this.nextDelimPos);
            this.curTokenPos = this.nextDelimPos + 1;
            this.nextDelimPos = Integer.MIN_VALUE;
        } else {
            ret = this.str.substring(this.curTokenPos);
            this.curTokenPos = this.str.length() + 1;
        }
        return ret;
    }
}

