/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.samples.movies_db.model.dataaccess;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Random;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.DataBaseError;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.ExactStringTokenizer;
import org.ow2.opensuit.samples.movies_db.model.dataaccess.RequestOptions;
import org.ow2.opensuit.samples.movies_db.model.to.MovieTO;
import org.ow2.opensuit.samples.movies_db.model.to.PersonTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoviesDataBase {
    private static char SEPAR = (char)9;
    private static PersonTO[] PERSON_ARRAY = new PersonTO[0];
    private static MovieTO[] MOVIE_ARRAY = new MovieTO[0];
    private static MoviesDataBase database;
    private ArrayList<PersonTO> directors;
    private ArrayList<MovieTO> movies;
    private DateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");
    private DateFormat DATE_FORMAT = new SimpleDateFormat("d MMMMM yyyy", Locale.US);
    private static File workDir;
    public static final int SORT_BY_ID = 1;
    public static final int SORT_BY_FRENCH_TITLE = 2;
    public static final int SORT_BY_ORIGINAL_TITLE = 3;
    public static final int SORT_BY_DIRECTOR = 4;
    public static final int SORT_BY_RELEASE_DATE = 5;
    public static final int SORT_BY_NAME = 2;
    public static final int SORT_BY_NATIONALITY = 3;
    public static final int SORT_BY_BIRTH_DATE = 4;
    public static final int SORT_BY_DEATH_DATE = 5;

    public static MoviesDataBase getDataBase() throws DataBaseError {
        if (database == null) {
            database = new MoviesDataBase();
            database.load();
        }
        return database;
    }

    private MoviesDataBase() {
    }

    private void load() {
        try {
            this.loadDirectors();
            this.loadMovies();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private InputStream readFile(String name) throws FileNotFoundException {
        File workFile = new File(workDir, name);
        if (workFile.exists()) {
            System.out.println("read '" + name + "' from: " + workFile.getAbsolutePath());
            return new FileInputStream(workFile);
        }
        System.out.println("read '" + name + "' from resources");
        return MoviesDataBase.class.getClassLoader().getResourceAsStream(name);
    }

    private OutputStream writeFile(String name) throws FileNotFoundException {
        File workFile = new File(workDir, name);
        System.out.println("save '" + name + "' to: " + workFile.getAbsolutePath());
        return new FileOutputStream(workFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirectors() throws IOException {
        this.directors = new ArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.readFile("directors.txt")));
        try {
            String curline = null;
            while ((curline = reader.readLine()) != null) {
                if (curline.length() == 0 || curline.startsWith("#")) continue;
                String[] values = ExactStringTokenizer.split(curline, SEPAR);
                PersonTO director = new PersonTO();
                director.setId(Integer.parseInt(values[0]));
                director.setName(values[1]);
                director.setNationality(values[2]);
                if (values[3].length() > 0) {
                    try {
                        director.setBirth(this.DATE_FORMAT.parse(values[3]));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (values[4].length() > 0) {
                    try {
                        director.setDeath(this.DATE_FORMAT.parse(values[4]));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                this.directors.add(director);
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMovies() throws IOException {
        this.movies = new ArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.readFile("movies.txt")));
        try {
            String curline = null;
            while ((curline = reader.readLine()) != null) {
                if (curline.length() == 0 || curline.startsWith("#")) continue;
                String[] values = ExactStringTokenizer.split(curline, SEPAR);
                MovieTO movie = new MovieTO();
                movie.setId(Integer.parseInt(values[0]));
                movie.setFrenchTitle(values[1]);
                movie.setOriginalTitle(values[2]);
                if (values[3].length() > 0) {
                    try {
                        movie.setReleaseDate(this.YEAR_FORMAT.parse(values[3]));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                int directorId = Integer.parseInt(values[4]);
                try {
                    movie.setDirector(this.getDirector(directorId));
                }
                catch (DataBaseError e) {
                    e.printStackTrace();
                }
                this.movies.add(movie);
            }
        }
        finally {
            reader.close();
        }
    }

    private void saveDirectors() {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(this.writeFile("directors.txt"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        writer.println("# Directors");
        for (int i = 0; i < this.directors.size(); ++i) {
            PersonTO director = this.directors.get(i);
            writer.print(String.valueOf(director.getId()));
            writer.print(SEPAR);
            writer.print(director.getName());
            writer.print(SEPAR);
            writer.print(director.getNationality());
            writer.print(SEPAR);
            writer.print(this.DATE_FORMAT.format(director.getBirth()));
            writer.print(SEPAR);
            if (director.getDeath() != null) {
                writer.print(this.DATE_FORMAT.format(director.getDeath()));
            }
            writer.println();
        }
        writer.close();
    }

    private void saveMovies() {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(this.writeFile("movies.txt"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        writer.println("# Movies");
        for (int i = 0; i < this.movies.size(); ++i) {
            MovieTO movie = this.movies.get(i);
            writer.print(String.valueOf(movie.getId()));
            writer.print(SEPAR);
            writer.print(movie.getFrenchTitle());
            writer.print(SEPAR);
            writer.print(movie.getOriginalTitle());
            writer.print(SEPAR);
            if (movie.getReleaseDate() != null) {
                writer.print(this.YEAR_FORMAT.format(movie.getReleaseDate()));
            }
            writer.print(SEPAR);
            writer.print(String.valueOf(movie.getDirector().getId()));
            writer.println();
        }
        writer.close();
    }

    private int getMovieIndex(int iId) {
        for (int i = 0; i < this.movies.size(); ++i) {
            if (this.movies.get(i).getId() != iId) continue;
            return i;
        }
        return -1;
    }

    public MovieTO getMovie(int iId) throws DataBaseError {
        int idx = this.getMovieIndex(iId);
        if (idx < 0) {
            throw new DataBaseError(1, "Movie " + iId + " not found.");
        }
        try {
            return this.movies.get(idx).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DataBaseError(0, e.getMessage());
        }
    }

    public int countAllMovies() throws DataBaseError {
        return this.movies.size();
    }

    private MovieTO[] applyRequestOptions(ArrayList<MovieTO> list, RequestOptions iOptions) {
        MovieTO[] ret = list.toArray(MOVIE_ARRAY);
        if (iOptions != null) {
            if (iOptions.hasSortOption()) {
                Arrays.sort(ret, new MoviesComparator(iOptions.getSortCriteria(), iOptions.isSortAscendingly()));
            }
            if (iOptions.hasPagination()) {
                MovieTO[] paginated = new MovieTO[Math.min(iOptions.getNbOfResults(), ret.length - iOptions.getFirstResult())];
                System.arraycopy(ret, iOptions.getFirstResult(), paginated, 0, paginated.length);
                ret = paginated;
            }
        }
        return ret;
    }

    public MovieTO[] getAllMovies(RequestOptions iOptions) throws DataBaseError {
        return this.applyRequestOptions(this.movies, iOptions);
    }

    private int createMovieId() {
        int id;
        Random rd = new Random();
        while (this.getMovieIndex(id = Math.abs(rd.nextInt())) >= 0) {
        }
        return id;
    }

    public void setMovie(MovieTO iMovie) throws DataBaseError {
        int idx;
        int n = idx = iMovie.getId() == 0 ? -1 : this.getMovieIndex(iMovie.getId());
        if (idx < 0) {
            iMovie.setId(this.createMovieId());
            try {
                iMovie = iMovie.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new DataBaseError(0, e.getMessage());
            }
            this.movies.add(iMovie);
        } else {
            try {
                iMovie = iMovie.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new DataBaseError(0, e.getMessage());
            }
            this.movies.set(idx, iMovie);
        }
        this.saveMovies();
    }

    public void removeMovie(int iId) throws DataBaseError {
        int idx = this.getMovieIndex(iId);
        if (idx < 0) {
            return;
        }
        this.movies.remove(idx);
        this.saveMovies();
    }

    public MovieTO[] searchMovieByTitle(String title, RequestOptions iOptions) throws DataBaseError {
        title = title.toLowerCase();
        ArrayList<MovieTO> results = new ArrayList<MovieTO>();
        for (int i = 0; i < this.movies.size(); ++i) {
            MovieTO movie = this.movies.get(i);
            if (!movie.getFrenchTitle().toLowerCase().contains(title) && !movie.getOriginalTitle().toLowerCase().contains(title)) continue;
            results.add(movie);
        }
        return this.applyRequestOptions(results, iOptions);
    }

    public int countMovieByTitle(String title) throws DataBaseError {
        int count = 0;
        for (int i = 0; i < this.movies.size(); ++i) {
            MovieTO movie = this.movies.get(i);
            if (!movie.getFrenchTitle().toLowerCase().contains(title) && !movie.getOriginalTitle().toLowerCase().contains(title)) continue;
            ++count;
        }
        return count;
    }

    public MovieTO[] searchMoviesByDirector(String director, RequestOptions iOptions) throws DataBaseError {
        PersonTO[] matchingDirectors = this.searchDirectorByName(director, null);
        ArrayList<MovieTO> results = new ArrayList<MovieTO>();
        if (matchingDirectors != null && matchingDirectors.length > 0) {
            for (int i = 0; i < matchingDirectors.length; ++i) {
                MovieTO[] movies = this.getMoviesFromDirector(matchingDirectors[i].getId(), null);
                for (int j = 0; j < movies.length; ++j) {
                    results.add(movies[j]);
                }
            }
        }
        return this.applyRequestOptions(results, iOptions);
    }

    public int countMoviesByDirector(String director) throws DataBaseError {
        PersonTO[] matchingDirectors = this.searchDirectorByName(director, null);
        int count = 0;
        if (matchingDirectors != null && matchingDirectors.length > 0) {
            for (int i = 0; i < matchingDirectors.length; ++i) {
                MovieTO[] movies = this.getMoviesFromDirector(matchingDirectors[i].getId(), null);
                count += movies.length;
            }
        }
        return count;
    }

    public MovieTO[] getMoviesFromDirector(int iDirectorId, RequestOptions iOptions) throws DataBaseError {
        ArrayList<MovieTO> results = new ArrayList<MovieTO>();
        for (int i = 0; i < this.movies.size(); ++i) {
            MovieTO movie = this.movies.get(i);
            if (movie.getDirector().getId() != iDirectorId) continue;
            results.add(movie);
        }
        return this.applyRequestOptions(results, iOptions);
    }

    private int getDirectorIndex(int iId) {
        for (int i = 0; i < this.directors.size(); ++i) {
            if (this.directors.get(i).getId() != iId) continue;
            return i;
        }
        return -1;
    }

    private PersonTO[] applyRequestOptions2(ArrayList<PersonTO> list, RequestOptions iOptions) {
        PersonTO[] ret = list.toArray(PERSON_ARRAY);
        if (iOptions != null) {
            if (iOptions.hasSortOption()) {
                Arrays.sort(ret, new PersonComparator(iOptions.getSortCriteria(), iOptions.isSortAscendingly()));
            }
            if (iOptions.hasPagination()) {
                PersonTO[] paginated = new PersonTO[Math.min(iOptions.getNbOfResults(), ret.length - iOptions.getFirstResult())];
                System.arraycopy(ret, iOptions.getFirstResult(), paginated, 0, paginated.length);
                ret = paginated;
            }
        }
        return ret;
    }

    public PersonTO getDirector(int iId) throws DataBaseError {
        int idx = this.getDirectorIndex(iId);
        if (idx < 0) {
            throw new DataBaseError(1, "Director " + iId + " not found.");
        }
        try {
            return this.directors.get(idx).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DataBaseError(0, e.getMessage());
        }
    }

    public PersonTO[] getAllDirectors(RequestOptions iOptions) throws DataBaseError {
        return this.applyRequestOptions2(this.directors, iOptions);
    }

    public int countAllDirectors() throws DataBaseError {
        return this.directors.size();
    }

    private int createDirectorId() {
        int id;
        Random rd = new Random();
        while (this.getDirectorIndex(id = Math.abs(rd.nextInt())) >= 0) {
        }
        return id;
    }

    public void setDirector(PersonTO iDirector) throws DataBaseError {
        int idx;
        try {
            iDirector = iDirector.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DataBaseError(0, e.getMessage());
        }
        int n = idx = iDirector.getId() == 0 ? -1 : this.getDirectorIndex(iDirector.getId());
        if (idx < 0) {
            iDirector.setId(this.createDirectorId());
            this.directors.add(iDirector);
        } else {
            this.directors.set(idx, iDirector);
        }
        this.saveDirectors();
    }

    public void removeDirector(int iId) throws DataBaseError {
        int idx = this.getDirectorIndex(iId);
        if (idx < 0) {
            return;
        }
        this.movies.remove(idx);
        this.saveDirectors();
    }

    public PersonTO[] searchDirectorByName(String name, RequestOptions iOptions) throws DataBaseError {
        name = name.toLowerCase();
        ArrayList<PersonTO> results = new ArrayList<PersonTO>();
        for (int i = 0; i < this.directors.size(); ++i) {
            PersonTO director = this.directors.get(i);
            if (!director.getName().toLowerCase().contains(name)) continue;
            results.add(director);
        }
        return this.applyRequestOptions2(results, iOptions);
    }

    static {
        workDir = new File(System.getProperty("user.home"));
        if (!workDir.exists()) {
            workDir = new File(System.getProperty("java.io.tmpdir"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PersonComparator
    implements Comparator<PersonTO> {
        private int crit;
        private int sign;

        public PersonComparator(int iSortingCriteria, boolean iSortAscendingly) {
            this.crit = iSortingCriteria;
            this.sign = iSortAscendingly ? 1 : -1;
        }

        @Override
        public int compare(PersonTO m1, PersonTO m2) {
            switch (this.crit) {
                case 1: {
                    return this.sign * (m1.getId() - m2.getId());
                }
                case 3: {
                    if (m1.getNationality() == null) {
                        if (m2.getNationality() == null) {
                            return 0;
                        }
                        return -this.sign;
                    }
                    if (m2.getNationality() == null) {
                        return this.sign;
                    }
                    return this.sign * m1.getNationality().compareTo(m2.getNationality());
                }
                case 4: {
                    if (m1.getBirth() == null) {
                        if (m2.getBirth() == null) {
                            return 0;
                        }
                        return -this.sign;
                    }
                    if (m2.getBirth() == null) {
                        return this.sign;
                    }
                    return this.sign * m1.getBirth().compareTo(m2.getBirth());
                }
                case 5: {
                    if (m1.getDeath() == null) {
                        if (m2.getDeath() == null) {
                            return 0;
                        }
                        return -this.sign;
                    }
                    if (m2.getDeath() == null) {
                        return this.sign;
                    }
                    return this.sign * m1.getDeath().compareTo(m2.getDeath());
                }
            }
            if (m1.getName() == null) {
                if (m2.getName() == null) {
                    return 0;
                }
                return -this.sign;
            }
            if (m2.getName() == null) {
                return this.sign;
            }
            return this.sign * m1.getName().compareTo(m2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoviesComparator
    implements Comparator<MovieTO> {
        private int crit;
        private int sign;

        public MoviesComparator(int iSortingCriteria, boolean iSortAscendingly) {
            this.crit = iSortingCriteria;
            this.sign = iSortAscendingly ? 1 : -1;
        }

        @Override
        public int compare(MovieTO m1, MovieTO m2) {
            switch (this.crit) {
                case 1: {
                    return this.sign * (m1.getId() - m2.getId());
                }
                case 2: {
                    if (m1.getFrenchTitle() == null) {
                        if (m2.getFrenchTitle() == null) {
                            return 0;
                        }
                        return -this.sign;
                    }
                    if (m2.getFrenchTitle() == null) {
                        return this.sign;
                    }
                    return this.sign * m1.getFrenchTitle().compareTo(m2.getFrenchTitle());
                }
                case 4: {
                    if (m1.getDirector() == null) {
                        if (m2.getDirector() == null) {
                            return 0;
                        }
                        return -this.sign;
                    }
                    if (m2.getDirector() == null) {
                        return this.sign;
                    }
                    return this.sign * m1.getDirector().getName().compareTo(m2.getDirector().getName());
                }
                case 5: {
                    if (m1.getReleaseDate() == null) {
                        if (m2.getReleaseDate() == null) {
                            return 0;
                        }
                        return -this.sign;
                    }
                    if (m2.getReleaseDate() == null) {
                        return this.sign;
                    }
                    return this.sign * m1.getReleaseDate().compareTo(m2.getReleaseDate());
                }
            }
            if (m1.getOriginalTitle() == null) {
                if (m2.getOriginalTitle() == null) {
                    return 0;
                }
                return -this.sign;
            }
            if (m2.getOriginalTitle() == null) {
                return this.sign;
            }
            return this.sign * m1.getOriginalTitle().compareTo(m2.getOriginalTitle());
        }
    }
}

