/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 France Telecom, http://www.francetelecom.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ow2.opensuit.xml.spring;

import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlEnumeration;

/**
 * This enumeration allows to precise the location
 * of the Spring Application Context, in order to :
 * <ul>
 * <li>Build-time validation for declared Spring beans
 * </ul>
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
@XmlDoc("Allow to specify the Spring Application Context location. You must " +
		" precise it if, you need to perform build-time validation. Exception" +
		"values: <ul>" +
		"<li>CLASSPATH: allow to specify the Spring Application Context location from your classpath</li>" +
		"<li>WAR: allow to specify the Spring Application Context location from your war file</li>" +
		"</ul>")
@XmlEnumeration
public enum ConfigLocation {
    
    @XmlDoc("Enumeration item that represent classpath location for Spring Application Context")
    CLASSPATH,
    
    @XmlDoc("Enumeration item that represent war location for Spring Application Context")
    WAR
}
