/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 France Telecom, http://www.francetelecom.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ow2.opensuit.xml.spring;

import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;

/**
 *Represent a Spring Application Context file, with these attributes:<br/>"
 *<ul>
 *  <li>File</li>
 *</ul>
 * 
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
@XmlDoc("Represent a Spring Application Context file, with these attributes:<br/>"
                + "<ul>"
                + "<li>File</li>"
                + "</ul>")
@XmlElement
public class XmlConfig {

    @XmlDoc("Defines the path and name of one Spring Application Context file <br/><br/>"
                     + "Example: /ApplicationContext.xml")
    @XmlAttribute(name="File")
    private String file;

    /**
     * @return the path
     */
    public String getFile() {
        return file;
    }
   
}
