/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xml.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.ow2.opensuit.xml.base.binding.IDataSource;
import org.ow2.opensuit.xml.interfaces.IBeanProvider;
import org.ow2.opensuit.xml.spring.ConfigLocation;
import org.ow2.opensuit.xml.spring.XmlConfig;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChildren;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlDoc(value="Allow to use several beans, declared into Spring context.")
@XmlElement
public class SpringBeans
implements IDataSource,
IInitializable {
    @XmlDoc(value="Spring configuration file(s).<br/>Note: This is not required at runtime if 'CreateContext' is false, but still it is useful to enable build-time validation.")
    @XmlChildren(name="ConfigFiles", minOccurs=1)
    private XmlConfig[] configFiles;
    @XmlDoc(value="Defines where the Spring configuration file(s) should be searched.<br/><ul><li>WAR: in the WAR /WEB-INF directory.<li>CLASSPATH: in the application classpath.</ul>Default: WAR.")
    @XmlAttribute(name="SearchIn", required=false)
    private ConfigLocation searchIn = ConfigLocation.WAR;
    @XmlDoc(value="Determines whether Open SUIT has to create and initialize the Spring Application Context.<br/>If set to 'true', your Spring Application Context will be instantiated by Open SUIT, and made available for the whole application. As a result you won't have to declare it anywhere else.<br/>Otherwise Open SUIT assumes the Spring Application Context is declared and initialized by some other way (Spring servlet for instance), and will just retrieve it through the J2EE servlet context.<br/>Default: false.")
    @XmlAttribute(name="CreateContext", required=false)
    private boolean createContext = false;
    private Object appContext;
    private Method getType;
    private Method getBean;

    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        ServletContext servletCtx = (ServletContext)instContext.getAncestor(ServletContext.class);
        boolean isBuildTimeValidation = servletCtx.getClass().getName().startsWith("org.ow2.opensuit.core.impl.tools");
        if (this.createContext || isBuildTimeValidation) {
            if (this.configFiles == null) {
                return;
            }
            ArrayList<String> files = new ArrayList<String>();
            for (XmlConfig f : this.configFiles) {
                files.add(f.getFile());
            }
            this.appContext = this.searchIn == ConfigLocation.CLASSPATH ? this.newClasspathAppContext(files, initSupport) : this.newWarAppContext(files, initSupport, servletCtx);
            if (this.appContext == null) {
                return;
            }
            try {
                this.getBean = this.appContext.getClass().getMethod("getBean", String.class);
                this.getType = this.appContext.getClass().getMethod("getType", String.class);
            }
            catch (SecurityException e) {
                initSupport.addValidationMessage((Object)this, null, 1, "Security exception throwed by the security manager. " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                initSupport.addValidationMessage((Object)this, null, 1, "Ooops! Looks like you're using a Spring version unsupported by Open SUIT.");
            }
        } else {
            try {
                Class<?> wacuClass = Class.forName("org.springframework.web.context.support.WebApplicationContextUtils");
                Method gwactMethod = wacuClass.getMethod("getWebApplicationContext", ServletContext.class);
                this.appContext = gwactMethod.invoke(wacuClass, servletCtx);
                if (this.appContext == null) {
                    initSupport.addValidationMessage((Object)this, null, 1, "No Spring context found in servlet context. \nMake sure it is properly defined, and that it is setup before starting the Open SUIT servlet!");
                    return;
                }
                this.getType = this.appContext.getClass().getMethod("getType", String.class);
                this.getBean = this.appContext.getClass().getMethod("getBean", String.class);
            }
            catch (ClassNotFoundException e) {
                initSupport.addValidationMessage((Object)this, null, 1, "Could not load spring context. Spring library is probably not in your classpath.");
            }
            catch (NoSuchMethodException e) {
                initSupport.addValidationMessage((Object)this, null, 1, "Ooops! Looks like you're using a Spring version unsupported by Open SUIT.");
            }
            catch (InvocationTargetException e) {
                initSupport.addValidationMessage((Object)this, null, 1, "Error in Spring initialization. Please look at Spring logs. " + e.getCause());
            }
            catch (Exception e) {
                initSupport.addValidationMessage((Object)this, null, 1, "Error while retrieving Spring context: " + e.getCause());
            }
        }
    }

    public Class<?> getBeanType(String name) throws IBeanProvider.UnresolvedBeanError {
        if (this.getType == null) {
            return null;
        }
        try {
            Class clazz = (Class)this.getType.invoke(this.appContext, name);
            return clazz;
        }
        catch (InvocationTargetException e) {
            throw new IBeanProvider.UnresolvedBeanError();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Type getBeanGenericType(String name) throws IBeanProvider.UnresolvedBeanError {
        return this.getBeanType(name);
    }

    public Object getBeanValue(HttpServletRequest request, String name) throws Exception {
        if (this.getBean == null) {
            return null;
        }
        try {
            Object obj = this.getBean.invoke(this.appContext, name);
            return obj;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            e.printStackTrace(System.err);
            return null;
        }
    }

    private Object newWarAppContext(List<String> warFiles, IInitializationSupport initSupport, ServletContext servletContext) {
        ArrayList<String> urlContextList = new ArrayList<String>();
        for (String warFile : warFiles) {
            try {
                URL url = servletContext.getResource("/WEB-INF" + warFile);
                if (url == null) {
                    initSupport.addValidationMessage((Object)this, null, 1, "Bad searchIn for: " + warFile + " application context file, " + "declared in SpringBeans tag. It must " + "be located in /WEB-INF");
                    return null;
                }
                urlContextList.add(url.toString());
            }
            catch (MalformedURLException e) {
                initSupport.addValidationMessage((Object)this, null, 1, "Malformed URL for: " + warFile + " application context file, " + "declared in SpringBeans tag");
            }
        }
        String[] s = urlContextList.toArray(new String[urlContextList.size()]);
        try {
            Class<?> fsxacClass = Class.forName("org.springframework.context.support.FileSystemXmlApplicationContext");
            Constructor<?> fsxacConst = fsxacClass.getConstructor(String[].class);
            return fsxacConst.newInstance(new Object[]{s});
        }
        catch (ClassNotFoundException e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Could not load Spring context. Spring library is probably not in your classpath.");
        }
        catch (NoSuchMethodException e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Ooops! Looks like you're using a Spring version unsupported by Open SUIT.");
        }
        catch (InvocationTargetException e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Error in Spring initialization. Please look at Spring logs. " + e.getCause());
        }
        catch (Exception e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Error while retrieving Spring context: " + e.getCause());
        }
        return null;
    }

    private Object newClasspathAppContext(List<String> classpathURLs, IInitializationSupport initSupport) {
        String[] s = classpathURLs.toArray(new String[classpathURLs.size()]);
        try {
            Class<?> fsxacClas = Class.forName("org.springframework.context.support.ClassPathXmlApplicationContext");
            Constructor<?> fsxacConst = fsxacClas.getConstructor(String[].class);
            return fsxacConst.newInstance(new Object[]{s});
        }
        catch (ClassNotFoundException e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Could not load Spring context. Spring library is probably not in your classpath.");
        }
        catch (NoSuchMethodException e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Ooops! Looks like you're using a Spring version unsupported by Open SUIT.");
        }
        catch (InvocationTargetException e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Error in Spring initialization. Please look at Spring logs. " + e.getCause());
        }
        catch (Exception e) {
            initSupport.addValidationMessage((Object)this, null, 1, "Error while retrieving Spring context: " + e.getCause());
        }
        return null;
    }
}

