/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.schema.ISchema;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.opensuit.xmlmap.utils.ClassHelper;

public class DocGenerator {
    private static final boolean SHOW_INHERITANCE_IN_FIELDS = false;
    private static final String[] STRING_ARRAY = new String[0];
    private static final ISchemaElement[] ELT_ARRAY_TYPE = new ISchemaElement[0];
    private SchemasManager schemas;
    private ISchema mainSchema;
    private File docRootDir;
    private Locale locale = Locale.US;
    private String generatedComment;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: DocGenerator [dest_doc_dir] [java_package] ( [import_package] )*");
            return;
        }
        File outDir = new File(args[0]);
        String javaPackage = args[1];
        try {
            System.out.println("Generate Documentation from code");
            System.out.println("--------------------------------");
            System.out.println("  - output directory : " + outDir);
            System.out.println("  - root code package: " + javaPackage);
            SchemasManager schemas = new SchemasManager();
            ISchema mainSchema = schemas.declareSchema(javaPackage, javaPackage, javaPackage);
            for (int i = 2; i < args.length; ++i) {
                String importPack = args[i];
                schemas.declareSchema(importPack, importPack, importPack);
            }
            System.out.println("");
            mainSchema.buildFromClassPath();
            DocGenerator generator = new DocGenerator(schemas);
            generator.buildDoc(mainSchema, outDir.getAbsoluteFile());
            System.out.println("... Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DocGenerator(SchemasManager iSchemas) {
        this.schemas = iSchemas;
    }

    public void buildDoc(ISchema iSchema, File iDocRootDir) throws FileNotFoundException {
        int i;
        this.mainSchema = iSchema;
        this.docRootDir = iDocRootDir.getAbsoluteFile();
        Date now = new Date();
        this.generatedComment = "Generated by XMLMap DocGenerator on " + now;
        ISchemaElement[] elts = this.mainSchema.getAllElements();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i2 = 0; i2 < elts.length; ++i2) {
            String pack = elts[i2].getTagName();
            int idx = pack.lastIndexOf(46);
            pack = idx > 0 ? pack.substring(0, idx) : "";
            if (tmp.contains(pack)) continue;
            tmp.add(pack);
        }
        Object[] packages = tmp.toArray(STRING_ARRAY);
        Arrays.sort(packages);
        this.writeFrameset();
        this.writePackagesList((String[])packages);
        this.writeClassesList(null);
        for (i = 0; i < packages.length; ++i) {
            this.writeClassesList((String)packages[i]);
        }
        this.writeSchemaSummary(iSchema);
        for (i = 0; i < elts.length; ++i) {
            this.writeElement(elts[i]);
        }
    }

    private File newFile(String path) {
        return new File(this.docRootDir.getAbsolutePath() + "/" + path);
    }

    private void writeFrameset() throws FileNotFoundException {
        File f = this.newFile(this.mainSchema.getRootPackage() + "_index.html");
        f.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileOutputStream(f));
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + "  -->");
        writer.println("<TITLE>");
        writer.println("XML Doc for " + this.mainSchema.getName());
        writer.println("</TITLE>");
        writer.println("</HEAD>");
        writer.println("<FRAMESET cols=\"20%,80%\">");
        writer.println("\t<FRAMESET rows=\"30%,70%\">");
        writer.println("\t\t<FRAME src=\"" + this.mainSchema.getRootPackage() + "/overview-frame.html\" name=\"packageListFrame\" title=\"All Packages\">");
        writer.println("\t\t<FRAME src=\"" + this.mainSchema.getRootPackage() + "/allclasses-frame.html\" name=\"packageFrame\" title=\"All elements and substitution groups\">");
        writer.println("\t</FRAMESET>");
        writer.println("\t<FRAME src=\"" + this.mainSchema.getRootPackage() + "/overview-summary.html\" name=\"classFrame\" title=\"Package, element and substitution group descriptions\">");
        writer.println("</FRAMESET>");
        writer.println("</HTML>");
        writer.close();
    }

    private void writePackagesList(String[] packages) throws FileNotFoundException {
        File f = this.newFile(this.mainSchema.getRootPackage() + "/overview-frame.html");
        f.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileOutputStream(f));
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + " -->");
        writer.println("<TITLE>");
        writer.println("Packages List");
        writer.println("</TITLE>");
        writer.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        writer.println("<base target=\"packageFrame\">");
        writer.println("</HEAD>");
        writer.println("<BODY BGCOLOR=\"white\">");
        writer.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        writer.println("<TR>");
        writer.println("<TD NOWRAP><FONT CLASS=\"FrameItemFont\"><A HREF=\"allclasses-frame.html\">All Classes</A></FONT>");
        writer.println("<P>");
        writer.println("<FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Packages</FONT>");
        writer.println("<BR>");
        for (int i = 0; i < packages.length; ++i) {
            String packageName = packages[i];
            String packageDir = null;
            if (packageName.length() == 0) {
                packageName = "(root)";
                packageDir = ".";
            } else {
                packageDir = packages[i].replace('.', '/');
            }
            writer.println("<FONT CLASS=\"FrameItemFont\"><A HREF=\"" + packageDir + "/package-frame.html\">" + packageName + "</A></FONT>");
            writer.println("<BR>");
        }
        writer.println("</TD>");
        writer.println("</TR>");
        writer.println("</TABLE>");
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.close();
    }

    private String toRoot(File file, File dir) {
        File d;
        StringBuilder toRoot = new StringBuilder(".");
        for (d = file.getParentFile(); d != null && !d.equals(dir); d = d.getParentFile()) {
            toRoot.append("/..");
        }
        if (d == null) {
            System.out.println("error: toRoot(" + file + ", " + dir + ")... null");
        }
        return toRoot.toString();
    }

    private void writeClassesList(String pack) throws FileNotFoundException {
        String toRoot = ".";
        String title = "All Elements";
        File f = null;
        if (pack == null) {
            f = this.newFile(this.mainSchema.getRootPackage() + "/allclasses-frame.html");
            toRoot = "..";
        } else if (pack.length() == 0) {
            title = "Elements from root package";
            f = this.newFile(this.mainSchema.getRootPackage() + "/package-frame.html");
            toRoot = "..";
        } else {
            title = "Elements from package '" + pack + "'";
            f = this.newFile(this.mainSchema.getRootPackage() + "/" + pack.replace('.', '/') + "/package-frame.html");
            toRoot = this.toRoot(f, this.docRootDir);
        }
        f.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileOutputStream(f));
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + "  -->");
        writer.println("<TITLE>");
        writer.println(title);
        writer.println("</TITLE>");
        writer.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + toRoot + "/stylesheet.css\" TITLE=\"Style\">");
        writer.println("<base target=\"classFrame\">");
        writer.println("</HEAD>");
        writer.println("<BODY BGCOLOR=\"white\">");
        writer.println("<FONT size=\"+1\" CLASS=\"FrameHeadingFont\">");
        writer.println("<B>" + title + "</B></FONT>");
        writer.println("<BR>");
        writer.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        writer.println("<TR>");
        writer.println("<TD NOWRAP><FONT CLASS=\"FrameItemFont\">");
        ISchemaElement[] elts = this.mainSchema.getAllElements();
        if (pack != null) {
            ArrayList<ISchemaElement> eltsFromPackage = new ArrayList<ISchemaElement>();
            for (int i = 0; i < elts.length; ++i) {
                String eltPack = elts[i].getTagName();
                int idx = eltPack.lastIndexOf(46);
                eltPack = idx > 0 ? eltPack.substring(0, idx) : "";
                if (!eltPack.equals(pack)) continue;
                eltsFromPackage.add(elts[i]);
            }
            elts = eltsFromPackage.toArray(ELT_ARRAY_TYPE);
        }
        Arrays.sort(elts, new Comparator(){

            public int compare(Object o1, Object o2) {
                ISchemaElement e1 = (ISchemaElement)o1;
                ISchemaElement e2 = (ISchemaElement)o2;
                return e1.getTagName().compareTo(e2.getTagName());
            }
        });
        for (int i = 0; i < elts.length; ++i) {
            String link = this.getElementDocPath(elts[i]);
            if (elts[i].getMappedClass().isInterface()) {
                writer.println("<I>");
            }
            writer.println("<A HREF=\"" + toRoot + "/" + link + "\">" + elts[i].getTagName() + "</A>");
            if (elts[i].getMappedClass().isInterface()) {
                writer.println("</I>");
            }
            writer.println("<BR>");
        }
        writer.println("</TD>");
        writer.println("</TR>");
        writer.println("</TABLE>");
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.close();
    }

    private void writeSchemaSummary(ISchema schema) throws FileNotFoundException {
        File f = this.newFile(this.mainSchema.getRootPackage() + "/overview-summary.html");
        f.getParentFile().mkdirs();
        String toRoot = this.toRoot(f, this.docRootDir);
        PrintWriter writer = new PrintWriter(new FileOutputStream(f));
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + "  -->");
        writer.println("<TITLE>");
        writer.print("XML Doc: ");
        writer.print(schema.getRootPackage());
        writer.println("</TITLE>");
        writer.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + toRoot + "/stylesheet.css\" TITLE=\"Style\">");
        writer.println("<base target=\"classFrame\">");
        writer.println("</HEAD>");
        writer.println("<BODY BGCOLOR=\"white\">");
        writer.println("<H2>");
        writer.print("XML Doc");
        writer.println("</H2>");
        writer.println("<HR>");
        writer.println("<P>");
        writer.print("This is the XML documentation for Java package <b>");
        writer.print(schema.getRootPackage());
        writer.print("</b>.");
        writer.println("</P>");
        writer.println("<HR>");
        ISchema[] dependencies = schema.getUsedSchemas();
        writer.print("<h3>");
        writer.print("Schema Dependencies:");
        writer.println("<h3>");
        writer.println("<ul>");
        if (dependencies != null && dependencies.length > 0) {
            for (int i = 0; i < dependencies.length; ++i) {
                writer.print("<li>");
                writer.print("<a href=\"../");
                writer.print(dependencies[i].getRootPackage());
                writer.print("_index.html\" target=\"_top\">");
                writer.print(dependencies[i].getRootPackage());
                writer.print("</a>");
                writer.println("</li>");
            }
        } else {
            writer.println("<li>none</li>");
        }
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.close();
    }

    private String getElementDocPath(ISchemaElement iElt) {
        return iElt.getSchema().getRootPackage() + "/" + iElt.getTagName().replace('.', '/') + ".html";
    }

    private String getPackageDocPath(String packageName) {
        if (packageName == null) {
            return this.mainSchema.getRootPackage();
        }
        return this.mainSchema.getRootPackage() + "/" + packageName.replace('.', '/');
    }

    private void writeElement(ISchemaElement iElt) throws FileNotFoundException {
        ISchemaElement fieldTypeElt;
        String fieldDetails;
        String link;
        FieldMapping field;
        FieldMapping[] mappedFields;
        ISchemaElement[] substitutionGroups;
        int i;
        ISchemaElement ancestor;
        boolean isAbstract = (iElt.getMappedClass().getModifiers() & 0x400) != 0;
        int idx = iElt.getTagName().lastIndexOf(46);
        String simpleEltName = iElt.getTagName();
        String packageName = "(root)";
        if (idx > 0) {
            packageName = iElt.getTagName().substring(0, idx);
            simpleEltName = iElt.getTagName().substring(idx + 1);
        }
        String title = null;
        title = iElt.getType() == 4 ? (isAbstract ? "abstract Element " + iElt.getTagName() : "Element " + iElt.getTagName()) : (iElt.getType() == 1 ? "Enumeration " + iElt.getTagName() : "Substitution Group " + iElt.getTagName());
        ArrayList<ISchemaElement> ancestors = new ArrayList<ISchemaElement>();
        for (ancestor = iElt.getSuperType(); ancestor != null; ancestor = ancestor.getSuperType()) {
            ancestors.add(0, ancestor);
        }
        ancestors.add(iElt);
        ArrayList<ISchemaElement> fieldAncestors = new ArrayList<ISchemaElement>();
        ArrayList<ElementMapping> mappings = new ArrayList<ElementMapping>();
        fieldAncestors.add(iElt);
        mappings.add(iElt.getSchema().getMethod().getElementMappings(iElt.getMappedClass(), true));
        File f = this.newFile(this.getElementDocPath(iElt));
        f.getParentFile().mkdirs();
        String toRoot = this.toRoot(f, this.docRootDir);
        PrintWriter writer = new PrintWriter(new FileOutputStream(f));
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + "  -->");
        writer.println("<TITLE>");
        writer.println(title);
        writer.println("</TITLE>");
        writer.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + toRoot + "/stylesheet.css\" TITLE=\"Style\">");
        writer.println("<base target=\"classFrame\">");
        writer.println("</HEAD>");
        writer.println("<SCRIPT type=\"text/javascript\">");
        writer.println("function windowTitle()");
        writer.println("{");
        writer.println("\tparent.document.title=\"" + title + "\";");
        writer.println("}");
        writer.println("</SCRIPT>");
        writer.println("<BODY onload=\"windowTitle()\" BGCOLOR=\"white\">");
        writer.println("<H2>");
        writer.println(title);
        writer.println("</H2>");
        if (ancestors.size() > 1) {
            writer.println("<PRE>");
            for (int i2 = 0; i2 < ancestors.size(); ++i2) {
                String link2;
                if (i2 > 0) {
                    int j;
                    for (j = 0; j < i2; ++j) {
                        writer.print("  ");
                    }
                    writer.println("|");
                    for (j = 0; j < i2; ++j) {
                        writer.print("  ");
                    }
                    writer.print("+-- ");
                }
                ancestor = (ISchemaElement)ancestors.get(i2);
                String string = link2 = i2 == ancestors.size() - 1 ? null : this.getElementDocPath(ancestor);
                if (link2 != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link2 + "\">");
                }
                writer.print(ancestor.getTagName());
                if (link2 != null) {
                    writer.print("</A>");
                }
                writer.println();
            }
            writer.println("</PRE>");
        }
        if (iElt.getType() == 2 || isAbstract) {
            writer.println("<DL>");
            writer.println("<DT><B>Known Implementing Elements:</B></DT>");
            writer.println("<DD>");
            ISchemaElement[] allElements = this.mainSchema.getAllElements();
            int nbImpl = 0;
            for (i = 0; i < allElements.length; ++i) {
                String link3;
                if (iElt.getMappedClass() == allElements[i].getMappedClass() || !iElt.getMappedClass().isAssignableFrom(allElements[i].getMappedClass())) continue;
                if (nbImpl > 0) {
                    writer.print(", ");
                }
                if ((link3 = this.getElementDocPath(allElements[i])) != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link3 + "\">");
                }
                writer.print(allElements[i].getTagName());
                if (link3 != null) {
                    writer.print("</A>");
                }
                ++nbImpl;
            }
            if (nbImpl == 0) {
                writer.print("None.");
            }
            writer.println("</DD>");
            writer.println("</DL>");
        }
        if ((substitutionGroups = iElt.getSubstitutionGroups()) != null && substitutionGroups.length > 0) {
            writer.println("<DL>");
            writer.println("<DT><B>Substitution Groups:</B></DT>");
            writer.println("<DD>");
            for (int i3 = 0; i3 < substitutionGroups.length; ++i3) {
                String link4;
                if (i3 > 0) {
                    writer.print(", ");
                }
                if ((link4 = this.getElementDocPath(substitutionGroups[i3])) != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link4 + "\">");
                }
                writer.print(substitutionGroups[i3].getTagName());
                if (link4 == null) continue;
                writer.print("</A>");
            }
            writer.println("</DD>");
            writer.println("</DL>");
        }
        writer.println("<HR>");
        String compDetails = iElt.getSchema().getMethod().getElementDetails(this.locale, iElt.getMappedClass());
        if (compDetails == null) {
            compDetails = iElt.getSchema().getMethod().getElementTitle(this.locale, iElt.getMappedClass());
        }
        writer.println("<P>");
        writer.println(compDetails);
        writer.println("<P>");
        writer.println("<HR>");
        if (iElt.getType() == 1) {
            writer.println("<P>");
            writer.println("<A NAME=\"ENUM_ITEMS\"/>");
            writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
            writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
            writer.println("<TD COLSPAN=2><FONT SIZE=\"+2\">");
            writer.println("<B>Enumeration Items</B></FONT></TD>");
            writer.println("</TR>");
            int nbItems = iElt.getSchema().getMethod().getNbOfEnumItems(iElt.getMappedClass());
            for (int i4 = 0; i4 < nbItems; ++i4) {
                String itemName = iElt.getSchema().getMethod().getEnumItemName(iElt.getMappedClass(), i4);
                String itemDetails = iElt.getSchema().getMethod().getEnumItemDetails(this.locale, iElt.getMappedClass(), itemName);
                if (itemDetails == null) {
                    itemDetails = iElt.getSchema().getMethod().getEnumItemDetails(this.locale, iElt.getMappedClass(), itemName);
                }
                writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                writer.println("<TD nowrap><CODE><B>" + itemName + "</B></CODE></TD>");
                writer.println("<TD width=\"100%\">" + itemDetails + "</TD>");
                writer.println("</TR>");
            }
            writer.println("</TABLE>");
        } else {
            String attrDetails;
            int j;
            ISchemaElement elt;
            writer.println("<P>");
            writer.println("<!-- ======== CONTENT ======== -->");
            writer.println("<A NAME=\"CONTENT\"/>");
            for (i = 0; i < fieldAncestors.size(); ++i) {
                elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
                mappedFields = ((ElementMapping)mappings.get(i)).getMappings(8);
                if (mappedFields == null || mappedFields.length <= 0) continue;
                writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
                writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
                writer.println("<TD COLSPAN=1><FONT SIZE=\"+2\"><B>");
                if (i == 0) {
                    writer.println("Element Textual Content");
                } else {
                    writer.println("Element Textual Content Inherited from ");
                    String link5 = this.getElementDocPath(elt);
                    if (link5 != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link5 + "\">");
                    }
                    writer.print(elt.getTagName());
                    if (link5 != null) {
                        writer.print("</A>");
                    }
                }
                writer.println("</B></FONT></TD>");
                writer.println("</TR>");
                for (j = 0; j < mappedFields.length; ++j) {
                    field = mappedFields[j];
                    attrDetails = iElt.getSchema().getMethod().getMappingDetails(this.locale, field);
                    if (attrDetails == null) {
                        attrDetails = iElt.getSchema().getMethod().getMappingTitle(this.locale, field);
                    }
                    writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                    writer.println("<TD width=\"100%\">" + attrDetails + "</TD>");
                    writer.println("</TR>");
                }
                writer.println("</TABLE>");
                writer.println("<P>");
            }
            writer.println("<P>");
            writer.println("<!-- ======== ATTRIBUTES ======== -->");
            writer.println("<A NAME=\"ATTRIBUTES\"/>");
            for (i = 0; i < fieldAncestors.size(); ++i) {
                elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
                mappedFields = ((ElementMapping)mappings.get(i)).getMappings(1);
                if (mappedFields == null || mappedFields.length <= 0) continue;
                writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
                writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
                writer.println("<TD COLSPAN=3><FONT SIZE=\"+2\"><B>");
                if (i == 0) {
                    writer.println("Attributes");
                } else {
                    writer.println("Attributes Inherited from ");
                    String link6 = this.getElementDocPath(elt);
                    if (link6 != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link6 + "\">");
                    }
                    writer.print(elt.getTagName());
                    if (link6 != null) {
                        writer.print("</A>");
                    }
                }
                writer.println("</B></FONT></TD>");
                writer.println("</TR>");
                for (j = 0; j < mappedFields.length; ++j) {
                    field = mappedFields[j];
                    attrDetails = iElt.getSchema().getMethod().getMappingDetails(this.locale, field);
                    if (attrDetails == null) {
                        attrDetails = iElt.getSchema().getMethod().getMappingTitle(this.locale, field);
                    }
                    writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                    writer.println("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">");
                    writer.println("<CODE>");
                    if (field.isUseRequired()) {
                        writer.println("mandatory");
                    } else {
                        writer.println("optional");
                    }
                    writer.println("&nbsp;");
                    if (iElt.getSchema().getMethod().isEnumeration(field.getBaseClass())) {
                        ISchemaElement enumElt = this.schemas.getElement(field.getBaseClass());
                        if (enumElt != null) {
                            link = this.getElementDocPath(enumElt);
                            if (link != null) {
                                writer.print("<A HREF=\"" + toRoot + "/" + link + "\">");
                            }
                            writer.print(enumElt.getTagName());
                            if (link != null) {
                                writer.print("</A>");
                            }
                        } else {
                            writer.println(ClassHelper.getSimpleName(field.getBaseClass()));
                        }
                    } else {
                        writer.println(ClassHelper.getSimpleName(field.getBaseClass()));
                    }
                    writer.println("</CODE></FONT></TD>");
                    writer.println("<TD nowrap><CODE><B>" + field.getName() + "</B></CODE></TD>");
                    writer.println("<TD width=\"100%\">" + attrDetails + "</TD>");
                    writer.println("</TR>");
                }
                writer.println("</TABLE>");
                writer.println("<P>");
            }
            writer.println("<P>");
            writer.println("<!-- ======== CHILDREN ======== -->");
            writer.println("<A NAME=\"CHILDREN\"/>");
            for (i = 0; i < fieldAncestors.size(); ++i) {
                elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
                mappedFields = ((ElementMapping)mappings.get(i)).getMappings(2);
                if (mappedFields == null || mappedFields.length <= 0) continue;
                writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
                writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
                writer.println("<TD COLSPAN=3><FONT SIZE=\"+2\"><B>");
                if (i == 0) {
                    writer.println("Named Children Elements");
                } else {
                    writer.println("Named Children Elements Inherited from ");
                    String link7 = this.getElementDocPath(elt);
                    if (link7 != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link7 + "\">");
                    }
                    writer.print(elt.getTagName());
                    if (link7 != null) {
                        writer.print("</A>");
                    }
                }
                writer.println("</B></FONT></TD>");
                writer.println("</TR>");
                for (j = 0; j < mappedFields.length; ++j) {
                    field = mappedFields[j];
                    fieldDetails = iElt.getSchema().getMethod().getMappingDetails(this.locale, field);
                    if (fieldDetails == null) {
                        fieldDetails = iElt.getSchema().getMethod().getMappingTitle(this.locale, field);
                    }
                    writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                    writer.println("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">");
                    writer.println("<CODE>");
                    if (field.getMaxOccurs() == 1) {
                        if (field.isUseRequired()) {
                            writer.println("mandatory");
                        } else {
                            writer.println("optional");
                        }
                    } else if (field.getMinOccurs() == field.getMaxOccurs()) {
                        writer.println("extactly " + field.getMaxOccurs());
                    } else {
                        writer.println(String.valueOf(field.getMinOccurs()) + "&nbsp;-&nbsp;" + (field.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(field.getMaxOccurs())));
                    }
                    writer.println("&nbsp;");
                    fieldTypeElt = this.schemas.getElement(field.getBaseClass());
                    if (fieldTypeElt != null) {
                        link = this.getElementDocPath(fieldTypeElt);
                        if (link != null) {
                            writer.print("<A HREF=\"" + toRoot + "/" + link + "\">");
                        }
                        writer.print(fieldTypeElt.getTagName());
                        if (link != null) {
                            writer.print("</A>");
                        }
                    } else {
                        writer.print(ClassHelper.getSimpleName(field.getBaseClass()));
                    }
                    if (field.getMaxOccurs() > 1) {
                        writer.print("[]");
                    }
                    writer.println("</CODE></FONT></TD>");
                    writer.println("<TD nowrap><CODE><B>" + field.getName() + "</B></CODE></TD>");
                    writer.println("<TD width=\"100%\">" + fieldDetails + "</TD>");
                    writer.println("</TR>");
                }
                writer.println("</TABLE>");
                writer.println("<P>");
            }
        }
        writer.println("<P>");
        writer.println("<!-- ======== CHILDREN ======== -->");
        writer.println("<A NAME=\"CHILDREN\"/>");
        for (i = 0; i < fieldAncestors.size(); ++i) {
            ISchemaElement elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
            mappedFields = ((ElementMapping)mappings.get(i)).getMappings(4);
            if (mappedFields == null || mappedFields.length <= 0) continue;
            writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
            writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
            writer.println("<TD COLSPAN=2><FONT SIZE=\"+2\"><B>");
            if (i == 0) {
                writer.println("Direct Children Elements");
            } else {
                writer.println("Direct Children Elements Inherited from ");
                String link8 = this.getElementDocPath(elt);
                if (link8 != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link8 + "\">");
                }
                writer.print(elt.getTagName());
                if (link8 != null) {
                    writer.print("</A>");
                }
            }
            writer.println("</B></FONT></TD>");
            writer.println("</TR>");
            for (int j = 0; j < mappedFields.length; ++j) {
                field = mappedFields[j];
                fieldDetails = iElt.getSchema().getMethod().getMappingDetails(this.locale, field);
                if (fieldDetails == null) {
                    fieldDetails = iElt.getSchema().getMethod().getMappingTitle(this.locale, field);
                }
                writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                writer.println("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">");
                writer.println("<CODE>");
                if (field.getMaxOccurs() == 1) {
                    if (field.isUseRequired()) {
                        writer.println("mandatory");
                    } else {
                        writer.println("optional");
                    }
                } else if (field.getMinOccurs() == field.getMaxOccurs()) {
                    writer.println("extactly " + field.getMaxOccurs());
                } else {
                    writer.println(String.valueOf(field.getMinOccurs()) + "&nbsp;-&nbsp;" + (field.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(field.getMaxOccurs())));
                }
                writer.println("&nbsp;");
                fieldTypeElt = this.schemas.getElement(field.getBaseClass());
                if (fieldTypeElt != null) {
                    link = this.getElementDocPath(fieldTypeElt);
                    if (link != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link + "\">");
                    }
                    writer.print(fieldTypeElt.getTagName());
                    if (link != null) {
                        writer.print("</A>");
                    }
                } else {
                    writer.print(ClassHelper.getSimpleName(field.getBaseClass()));
                }
                if (field.getMaxOccurs() > 1) {
                    writer.print("[]");
                }
                writer.println("</CODE></FONT></TD>");
                writer.println("<TD width=\"100%\">" + fieldDetails + "</TD>");
                writer.println("</TR>");
            }
            writer.println("</TABLE>");
            writer.println("<P>");
        }
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.close();
    }
}

