/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.ow2.opensuit.xmlmap.XmlInstantiator;
import org.ow2.opensuit.xmlmap.XmlSerializer;
import org.ow2.opensuit.xmlmap.impl.InitializableObjInfoHolder;
import org.ow2.opensuit.xmlmap.impl.ObjInfo;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.opensuit.xmlmap.utils.XsdHelper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEditor
extends InitializableObjInfoHolder {
    private IInstantiationContext validSupport;
    private SchemasManager manager;
    private Object root;

    public XmlEditor(IInstantiationContext iSupport) {
        this.validSupport = iSupport;
    }

    public void load(URL xmlUrl) throws ParserConfigurationException, SAXException, IOException {
        XmlInstantiator model = XmlInstantiator.instantiate(xmlUrl, this.validSupport);
        this.manager = model.getSchemas();
        this.root = model.getRoot();
        this.revalidate();
    }

    public void save(OutputStream xmlOutput) throws UnsupportedEncodingException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        XmlSerializer.serialize(this.manager, this.root, xmlOutput);
    }

    public Object getRoot() {
        return this.root;
    }

    public SchemasManager getSchemas() {
        return this.manager;
    }

    @Override
    protected Object instantiateFile(URL xmlFile, ObjInfo parentInfo) throws Exception {
        return null;
    }

    public void delete(Object iObj) {
    }

    public void changeType(Object iObj, Class<?> iNewType) {
    }

    public void changeValues(Object iObj, FieldMapping[] iFields, Object[] iValues) {
    }

    public void add(Object iParent, FieldMapping iMapping, Object iChild) {
    }

    private void revalidate() {
        this.removeAllInfo();
        ObjInfo rootInfo = new ObjInfo(null, this.root);
        this.addInfo(rootInfo);
        this.glueAndCheckObj(rootInfo);
        this.initializeAll(this.validSupport);
    }

    private void glueAndCheckObj(ObjInfo info) {
        FieldMapping[] contentMappings;
        FieldMapping fieldMapping;
        int i;
        Object obj = info.getObject();
        ObjInfo parent = info.getParent();
        ISchemaElement schemaElt = this.manager.getElement(obj.getClass());
        if (schemaElt == null) {
            info.addMessage(null, 0, "Object not found in any declared schema.");
            return;
        }
        ElementMapping mappings = schemaElt.getSchema().getMethod().getElementMappings(obj.getClass(), true);
        if (parent != null) {
            FieldMapping[] ancestorMappings = mappings.getMappings(64);
            for (i = 0; i < ancestorMappings.length; ++i) {
                ObjInfo ancestor;
                fieldMapping = ancestorMappings[i];
                for (ancestor = info.getParent(); ancestor != null && !fieldMapping.getField().getType().isInstance(ancestor.getObject()); ancestor = ancestor.getParent()) {
                }
                if (ancestor != null) {
                    try {
                        fieldMapping.getField().setAccessible(true);
                        fieldMapping.getField().set(obj, ancestor.getObject());
                    }
                    catch (IllegalArgumentException e) {
                        info.addMessage(fieldMapping.getName(), 2, "Ancestor field '" + fieldMapping.getField().getName() + "' type (" + fieldMapping.getBaseClass().getName() + ") is not compatible with the parent type: " + ancestor.getObject().getClass().getName() + ". Will be null.");
                    }
                    catch (IllegalAccessException e) {
                        info.addMessage(fieldMapping.getName(), 0, "Ancestor field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                    }
                    continue;
                }
                info.addMessage(fieldMapping.getName(), 4, "No matching ancestor for field '" + fieldMapping.getField().getName() + "' type (" + fieldMapping.getBaseClass().getName() + "). Will be null.");
            }
        }
        if ((contentMappings = mappings.getMappings(8)).length > 0) {
            for (i = 0; i < contentMappings.length; ++i) {
                fieldMapping = contentMappings[i];
                fieldMapping.getField().setAccessible(true);
                try {
                    String content = (String)fieldMapping.getField().get(obj);
                    continue;
                }
                catch (Exception e) {
                    info.addMessage(fieldMapping.getName(), 0, "Content field '" + fieldMapping.getField().getName() + "' could not be retreived.", e);
                }
            }
        }
        FieldMapping[] attrMappings = mappings.getMappings(1);
        for (int i2 = 0; i2 < attrMappings.length; ++i2) {
            FieldMapping fieldMapping2 = attrMappings[i2];
            fieldMapping2.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping2.getField().get(obj);
            }
            catch (Exception e) {
                info.addMessage(fieldMapping2.getName(), 0, "Attribute field '" + fieldMapping2.getField().getName() + "' could not be retreived.", e);
                continue;
            }
            if (val == null) {
                if (!fieldMapping2.isUseRequired()) continue;
                info.addMessage(fieldMapping2.getName(), 0, "Attribute '" + fieldMapping2.getName() + "' required.");
                continue;
            }
            if (XsdHelper.getSimpleType(fieldMapping2.getBaseClass()) != null || schemaElt.getSchema().getMethod().isEnumeration(fieldMapping2.getBaseClass())) continue;
            info.addMessage(fieldMapping2.getName(), 0, "Attribute '" + fieldMapping2.getName() + "' has an unsupported type: " + fieldMapping2.getBaseClass() + ".");
        }
        FieldMapping[] childMappings = mappings.getMappings(2);
        for (int i3 = 0; i3 < childMappings.length; ++i3) {
            FieldMapping fieldMapping3 = childMappings[i3];
            fieldMapping3.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping3.getField().get(obj);
            }
            catch (Exception e) {
                info.addMessage(fieldMapping3.getName(), 0, "Child node field '" + fieldMapping3.getField().getName() + "' could not be retreived.", e);
                continue;
            }
            if (val == null) {
                if (!fieldMapping3.isUseRequired()) continue;
                info.addMessage(fieldMapping3.getName(), 0, "Child node '" + fieldMapping3.getName() + "' required.");
                continue;
            }
            if (fieldMapping3.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping3.getMinOccurs()) {
                    info.addMessage(fieldMapping3.getName(), 0, "Child node '" + fieldMapping3.getName() + "' expects at least " + fieldMapping3.getMinOccurs() + " children.");
                } else if (len > fieldMapping3.getMaxOccurs()) {
                    info.addMessage(fieldMapping3.getName(), 0, "Child node '" + fieldMapping3.getName() + "' expects at most " + fieldMapping3.getMaxOccurs() + " children.");
                }
                for (int j = 0; j < len; ++j) {
                    Object v = Array.get(val, j);
                    ObjInfo childInfo = new ObjInfo(info, v);
                    this.addInfo(childInfo);
                    this.glueAndCheckObj(childInfo);
                }
                continue;
            }
            ObjInfo childInfo = new ObjInfo(info, val);
            this.addInfo(childInfo);
            this.glueAndCheckObj(childInfo);
        }
        FieldMapping[] collectedMappings = mappings.getMappings(4);
        for (int i4 = 0; i4 < collectedMappings.length; ++i4) {
            FieldMapping fieldMapping4 = collectedMappings[i4];
            fieldMapping4.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping4.getField().get(obj);
            }
            catch (Exception e) {
                info.addMessage(fieldMapping4.getName(), 0, "Collected node '" + fieldMapping4.getField().getName() + "' could not be retreived.", e);
                continue;
            }
            if (val == null) {
                if (!fieldMapping4.isUseRequired()) continue;
                info.addMessage(fieldMapping4.getName(), 0, "Collected node '" + fieldMapping4.getName() + "' required.");
                continue;
            }
            if (fieldMapping4.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping4.getMinOccurs()) {
                    info.addMessage(fieldMapping4.getName(), 0, "Collected node '" + fieldMapping4.getName() + "' expects at least " + fieldMapping4.getMinOccurs() + " children.");
                } else if (len > fieldMapping4.getMaxOccurs()) {
                    info.addMessage(fieldMapping4.getName(), 0, "Collected node '" + fieldMapping4.getName() + "' expects at most " + fieldMapping4.getMaxOccurs() + " children.");
                }
                for (int j = 0; j < len; ++j) {
                    Object v = Array.get(val, j);
                    ObjInfo childInfo = new ObjInfo(info, v);
                    this.addInfo(childInfo);
                    this.glueAndCheckObj(childInfo);
                }
                continue;
            }
            ObjInfo childInfo = new ObjInfo(info, val);
            this.addInfo(childInfo);
            this.glueAndCheckObj(childInfo);
        }
    }
}

