/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.opensuit.xmlmap.impl.InitializableObjInfoHolder;
import org.ow2.opensuit.xmlmap.impl.ObjInfo;
import org.ow2.opensuit.xmlmap.interfaces.IContentAssist;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.schema.ISchema;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.opensuit.xmlmap.utils.XmlHelper;
import org.ow2.opensuit.xmlmap.utils.XsdHelper;
import org.ow2.opensuit.xmlmap.utils.minidom.DomBuilder;
import org.ow2.opensuit.xmlmap.utils.minidom.Parser;
import org.ow2.opensuit.xmlmap.utils.minidom.XmlAttribute;
import org.ow2.opensuit.xmlmap.utils.minidom.XmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlInstantiator
extends InitializableObjInfoHolder {
    private ClassLoader classLoader = XmlInstantiator.class.getClassLoader();
    private IInstantiationContext instantiationContext;
    private SchemasManager schemasMgr;
    private Object rootObject;
    private Map<String, Object> file2Obj = new HashMap<String, Object>();
    private Map<String, Document> parsedFiles;

    public static final XmlInstantiator instantiate(URL xmlFileUrl, IInstantiationContext instantiationContext) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        return XmlInstantiator.instantiate(xmlFileUrl, instantiationContext, XmlInstantiator.class.getClassLoader());
    }

    public static final XmlInstantiator instantiate(URL xmlFileUrl, IInstantiationContext instantiationContext, ClassLoader classLoader) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        return XmlInstantiator.instantiate(xmlFileUrl, instantiationContext, classLoader, null);
    }

    public static final XmlInstantiator instantiate(URL xmlFileUrl, IInstantiationContext instantiationContext, ClassLoader classLoader, Map<String, Document> parsedFiles) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        XmlInstantiator doc = new XmlInstantiator(instantiationContext);
        doc.setClassLoader(classLoader);
        doc.setParsedFiles(parsedFiles);
        doc.instantiateMainDoc(xmlFileUrl);
        return doc;
    }

    private XmlInstantiator(IInstantiationContext iValidSupport) {
        this.instantiationContext = iValidSupport;
        this.schemasMgr = new SchemasManager();
    }

    private void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.schemasMgr.setClassLoader(classLoader);
    }

    private void setParsedFiles(Map<String, Document> parsedFiles) {
        this.parsedFiles = parsedFiles;
    }

    public Object getRoot() {
        return this.rootObject;
    }

    public SchemasManager getSchemas() {
        return this.schemasMgr;
    }

    public IContentAssist getContentAssist(URL fromFile, Node node) {
        Object o;
        Element e = null;
        if (node instanceof Element) {
            e = (Element)node;
        } else if (node instanceof Text) {
            e = (Element)((Text)node).getParentNode();
        } else if (node instanceof Attr) {
            e = ((Attr)node).getOwnerElement();
        } else {
            System.out.println("no content assist for this node type");
            return null;
        }
        Object root = this.file2Obj.get(fromFile.toExternalForm());
        if (root == null) {
            System.out.println("file not found");
            return null;
        }
        ArrayList<Element> elementsPath = new ArrayList<Element>();
        while (e != null) {
            elementsPath.add(0, e);
            Node parent = e.getParentNode();
            if (!(parent instanceof Element)) break;
            e = (Element)parent;
        }
        if ((o = this.find(root, elementsPath, 1)) == null) {
            System.out.println("object not found from node");
            return null;
        }
        System.out.println("object found from node: " + o);
        ISchemaElement schemaElt = this.schemasMgr.getElement(o.getClass());
        if (schemaElt == null) {
            System.out.println("schema element not found");
            return null;
        }
        ElementMapping mappings = schemaElt.getSchema().getMethod().getElementMappings(o.getClass(), true);
        if (node instanceof Attr) {
            Attr a = (Attr)node;
            String name = a.getLocalName() == null ? a.getName() : a.getLocalName();
            FieldMapping attrMapping = mappings.getMappingByNameAndType(name, 1);
            if (attrMapping == null) {
                System.out.println("no such attribute mapping: " + name);
                return null;
            }
            IContentAssist ca = schemaElt.getSchema().getMethod().getContentAssist(o, attrMapping);
            System.out.println("content assist: " + ca);
            return ca;
        }
        FieldMapping[] contentMappings = mappings.getMappings(8);
        if (contentMappings.length == 0) {
            System.out.println("no content mapping");
            return null;
        }
        return schemaElt.getSchema().getMethod().getContentAssist(o, contentMappings[0]);
    }

    private Object find(Object parent, List<Element> elementsPath, int index) {
        FieldMapping[] dirChildMappings;
        Class<?> elementType;
        if (index >= elementsPath.size()) {
            return parent;
        }
        ISchemaElement schemaElt = this.schemasMgr.getElement(parent.getClass());
        if (schemaElt == null) {
            System.out.println("schema element not found for class " + parent.getClass().getName());
            return null;
        }
        Element childElt = elementsPath.get(index);
        System.out.println(">> look for object " + childElt.getTagName() + "...");
        ElementMapping mappings = schemaElt.getSchema().getMethod().getElementMappings(parent.getClass(), true);
        String name = childElt.getLocalName() == null ? childElt.getNodeName() : childElt.getLocalName();
        FieldMapping childMapping = mappings.getMappingByNameAndType(name, 2);
        if (childMapping != null) {
            System.out.println(" ... this is a child mapping: " + childMapping);
            if (childMapping.getMaxOccurs() > 1) {
                childMapping.getField().setAccessible(true);
                try {
                    Object children = childMapping.getField().get(parent);
                    int childIdx = XmlHelper.getChildIndex(elementsPath.get(index + 1));
                    Object child = Array.get(children, childIdx);
                    return this.find(child, elementsPath, index + 2);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            childMapping.getField().setAccessible(true);
            try {
                Object child = childMapping.getField().get(parent);
                return this.find(child, elementsPath, index + 2);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }
        String javaPackage = childElt.getNamespaceURI();
        String version = null;
        if (javaPackage.startsWith("xmlmap://")) {
            int idx = javaPackage.indexOf(47, 9);
            if (idx < 0) {
                idx = javaPackage.length();
            } else {
                version = javaPackage.substring(idx + 1);
                if (version.equals("unversioned")) {
                    version = null;
                }
            }
            javaPackage = javaPackage.substring(9, idx);
        }
        try {
            elementType = Class.forName(javaPackage + "." + childElt.getLocalName(), true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            System.out.println("No class found for tag '" + childElt.getTagName() + "'.");
            return null;
        }
        for (FieldMapping mapping : dirChildMappings = mappings.getMappings(4)) {
            if (!mapping.getBaseClass().isAssignableFrom(elementType)) continue;
            childMapping = mapping;
            break;
        }
        if (childMapping == null) {
            System.out.println("direct child mapping not found: " + elementType.getName());
            return null;
        }
        System.out.println(" ... this is a direct child mapping: " + childMapping);
        if (childMapping.getMaxOccurs() > 1) {
            childMapping.getField().setAccessible(true);
            try {
                Object children = childMapping.getField().get(parent);
                int childIdx = this.getChildIndexOfType(childMapping.getBaseClass(), childElt);
                Object child = Array.get(children, childIdx);
                return this.find(child, elementsPath, index + 1);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }
        childMapping.getField().setAccessible(true);
        try {
            Object child = childMapping.getField().get(parent);
            return this.find(child, elementsPath, index + 1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getChildIndexOfType(Class type, Element iElt) {
        Element parent = (Element)iElt.getParentNode();
        if (parent == null) {
            return -1;
        }
        int idxElt = 0;
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            Element elt = (Element)n;
            if (elt == iElt) {
                return idxElt;
            }
            if (elt.getNamespaceURI() == null) continue;
            Class<?> elementType = null;
            String javaPackage = elt.getNamespaceURI();
            String version = null;
            if (javaPackage.startsWith("xmlmap://")) {
                int idx = javaPackage.indexOf(47, 9);
                if (idx < 0) {
                    idx = javaPackage.length();
                } else {
                    version = javaPackage.substring(idx + 1);
                    if (version.equals("unversioned")) {
                        version = null;
                    }
                }
                javaPackage = javaPackage.substring(9, idx);
            }
            try {
                elementType = Class.forName(javaPackage + "." + elt.getLocalName(), true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                System.out.println("No class found for tag '" + elt.getTagName() + "'.");
            }
            if (elementType == null || !type.isAssignableFrom(elementType)) continue;
            ++idxElt;
        }
        return -1;
    }

    private void instantiateMainDoc(URL mainDocUrl) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        ObjInfo docInfo = new ObjInfo(null, null);
        docInfo.setLocation(mainDocUrl, 0);
        this.addInfo(docInfo);
        this.rootObject = this.instantiateFile(mainDocUrl, docInfo);
        this.initializeAll(this.instantiationContext);
    }

    @Override
    protected Object instantiateFile(URL xmlFile, ObjInfo parentInfo) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        Document doc = this.parsedFiles == null ? null : this.parsedFiles.get(xmlFile.toExternalForm());
        XmlElement elt = doc == null ? Parser.parse(xmlFile) : DomBuilder.build(doc);
        Object o = this.instanciateElt(parentInfo, elt, xmlFile);
        this.file2Obj.put(xmlFile.toExternalForm(), o);
        return o;
    }

    private boolean isSimpleType(Class<?> type) {
        if (XsdHelper.getSimpleType(type) != null) {
            return true;
        }
        ISchema declaringSchema = this.schemasMgr.getDeclaringSchema(type);
        if (declaringSchema == null) {
            return false;
        }
        if (declaringSchema.getMethod().isEnumeration(type)) {
            return true;
        }
        return declaringSchema.getMethod().isSimpleType(type);
    }

    private Object instanciateSimpleType(ObjInfo parentInfo, Class<?> simpleType, String stringValue, int line, URL xmlFile) throws Exception {
        if (XsdHelper.getSimpleType(simpleType) != null) {
            try {
                return XsdHelper.parseSimpleType(stringValue, simpleType);
            }
            catch (Exception e) {
                throw new Exception("Could not parse base simple type '" + simpleType.getName() + "' (" + stringValue + "): " + e.getMessage(), e);
            }
        }
        ISchema declaringSchema = this.schemasMgr.getDeclaringSchema(simpleType);
        if (declaringSchema == null) {
            throw new Exception("Not a simple type '" + simpleType.getName() + "'.");
        }
        if (declaringSchema.getMethod().isEnumeration(simpleType)) {
            Object val = declaringSchema.getMethod().getEnumItem(simpleType, stringValue);
            if (val == null) {
                throw new Exception("Value '" + stringValue + "' does not correspond to any element in enumeration '" + simpleType.getName() + "'.");
            }
            return val;
        }
        if (declaringSchema.getMethod().isSimpleType(simpleType)) {
            Object base;
            ISchemaElement schemaElt = declaringSchema.getElement(simpleType);
            try {
                base = this.instanciateSimpleType(parentInfo, schemaElt.getSchema().getMethod().getBaseSimpleType(simpleType), stringValue, line, xmlFile);
            }
            catch (Exception e) {
                throw new Exception("Could not get base simple type value for '" + simpleType.getName() + "': " + e.getMessage());
            }
            Object obj = null;
            try {
                obj = simpleType.newInstance();
            }
            catch (IllegalArgumentException e) {
                throw new Exception("IllegalArgumentException while invoking " + simpleType.getName() + " default constructor: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new Exception("InstantiationException while invoking " + simpleType.getName() + " default constructor: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new Exception("IllegalAccessException while invoking " + simpleType.getName() + " default constructor: " + e.getMessage());
            }
            ObjInfo info = new ObjInfo(parentInfo, obj);
            info.setLocation(xmlFile, line);
            this.addInfo(info);
            ElementMapping mappings = schemaElt.getSchema().getMethod().getElementMappings(obj.getClass(), true);
            for (int i = 0; i < mappings.getMappingErrors().length; ++i) {
                info.addMessage(null, 0, mappings.getMappingErrors()[i].getMessage());
            }
            FieldMapping[] ancestorMappings = mappings.getMappings(64);
            for (int i = 0; i < ancestorMappings.length; ++i) {
                Object ancestorObj;
                FieldMapping fieldMapping = ancestorMappings[i];
                boolean found = false;
                for (ObjInfo ancestor = parentInfo; ancestor != null; ancestor = ancestor.getParent()) {
                    if (!fieldMapping.getField().getType().isInstance(ancestor.getObject())) continue;
                    found = true;
                    try {
                        fieldMapping.getField().setAccessible(true);
                        fieldMapping.getField().set(obj, ancestor.getObject());
                    }
                    catch (IllegalArgumentException e) {
                        info.addMessage(fieldMapping.getName(), 2, "Ancestor field '" + fieldMapping.getField().getName() + "' type (" + fieldMapping.getBaseClass().getName() + ") is not compatible with the parent type: " + ancestor.getObject().getClass().getName() + ". Will be null.");
                    }
                    catch (IllegalAccessException e) {
                        info.addMessage(fieldMapping.getName(), 0, "Ancestor field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                    }
                    break;
                }
                if (found || (ancestorObj = this.instantiationContext.getAncestor(fieldMapping.getField().getType())) == null) continue;
                found = true;
                try {
                    fieldMapping.getField().setAccessible(true);
                    fieldMapping.getField().set(obj, ancestorObj);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    info.addMessage(fieldMapping.getName(), 2, "Ancestor field '" + fieldMapping.getField().getName() + "' type (" + fieldMapping.getBaseClass().getName() + ") is not compatible with the parent type: " + ancestorObj.getClass().getName() + ". Will be null.");
                    continue;
                }
                catch (IllegalAccessException e) {
                    info.addMessage(fieldMapping.getName(), 0, "Ancestor field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
            }
            FieldMapping[] contentMappings = mappings.getMappings(8);
            if (contentMappings.length > 0) {
                for (int i = 0; i < contentMappings.length; ++i) {
                    FieldMapping fieldMapping = contentMappings[i];
                    try {
                        fieldMapping.getField().setAccessible(true);
                        fieldMapping.getField().set(obj, base);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        info.addMessage(fieldMapping.getName(), 0, "Content field '" + fieldMapping.getField().getName() + "' is not of expected type (" + base.getClass().getName() + "): " + fieldMapping.getClass().getName());
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        info.addMessage(fieldMapping.getName(), 0, "Content field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                    }
                }
            } else {
                info.addMessage(null, 0, "SimpleType object '" + simpleType.getName() + "' must declare a content mapping to get the base XSD type.");
            }
            return obj;
        }
        throw new Exception("Not a simple type '" + simpleType.getName() + "'.");
    }

    private Object instanciateElt(ObjInfo parentInfo, XmlElement iNode, URL xmlFile) {
        int i;
        FieldMapping fieldMapping;
        int i2;
        FieldMapping fieldMapping2;
        int i3;
        Class<?> c;
        String nsAndTag = iNode.getTagName();
        if (iNode.getLocalName().startsWith("Import_")) {
            ObjInfo info = new ObjInfo(parentInfo, null);
            info.setLocation(xmlFile, iNode.getLine());
            this.addInfo(info);
            String file = iNode.getAttribute("File");
            if (file == null) {
                info.addMessage("File", 0, "Attribute File expected on an Import element.");
                return null;
            }
            try {
                StringBuffer fileUrl = new StringBuffer();
                int idx = xmlFile.getFile().lastIndexOf(47);
                fileUrl.append(xmlFile.getFile().substring(0, idx + 1));
                fileUrl.append(file);
                URL xmlFileUrl = new URL(xmlFile.getProtocol(), xmlFile.getHost(), fileUrl.toString());
                return this.instantiateFile(xmlFileUrl, parentInfo);
            }
            catch (FileNotFoundException e) {
                info.addMessage("File", 0, "File '" + file + "' not found.");
                return null;
            }
            catch (Exception e) {
                info.addMessage("File", 0, "Error while importing document '" + file + "'.", e);
                return null;
            }
        }
        String javaPackage = iNode.getNamespaceURI();
        String version = null;
        if (javaPackage.startsWith("xmlmap://")) {
            int idx = javaPackage.indexOf(47, 9);
            if (idx < 0) {
                idx = javaPackage.length();
            } else {
                version = javaPackage.substring(idx + 1);
                if (version.equals("unversioned")) {
                    version = null;
                }
            }
            javaPackage = javaPackage.substring(9, idx);
        }
        try {
            c = Class.forName(javaPackage + "." + iNode.getLocalName(), true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            parentInfo.addMessage(null, 0, "No class found for tag '" + nsAndTag + "'.");
            return null;
        }
        ISchema schema = this.schemasMgr.getSchema(javaPackage);
        if (schema == null) {
            String location = null;
            String prefix = null;
            int idx = iNode.getTagName().indexOf(58);
            if (idx > 0) {
                prefix = iNode.getTagName().substring(0, idx);
            }
            schema = this.schemasMgr.declareSchema(prefix, location, javaPackage);
        }
        if (version == null && schema.getVersion() != null || version != null && !version.equals(schema.getVersion())) {
            parentInfo.addMessage(null, 2, "Child element " + iNode.getTagName() + " refers to schema " + iNode.getNamespaceURI() + " that doesn't match schema version: " + schema.getNamespace() + ". This may cause errors.");
        }
        Object obj = null;
        try {
            obj = c.newInstance();
        }
        catch (IllegalArgumentException e) {
            parentInfo.addMessage(null, 0, "IllegalArgumentException while invoking " + c.getName() + " default constructor: " + e.getMessage());
            return null;
        }
        catch (InstantiationException e) {
            parentInfo.addMessage(null, 0, "InstantiationException while invoking " + c.getName() + " default constructor: " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            parentInfo.addMessage(null, 0, "IllegalAccessException while invoking " + c.getName() + " default constructor: " + e.getMessage());
            return null;
        }
        ISchemaElement schemaElt = this.schemasMgr.getElement(obj.getClass());
        ObjInfo info = new ObjInfo(parentInfo, obj);
        info.setLocation(xmlFile, iNode.getLine());
        this.addInfo(info);
        ElementMapping mappings = schemaElt.getSchema().getMethod().getElementMappings(obj.getClass(), true);
        for (int i4 = 0; i4 < mappings.getMappingErrors().length; ++i4) {
            info.addMessage(null, 0, mappings.getMappingErrors()[i4].getMessage());
        }
        FieldMapping[] ancestorMappings = mappings.getMappings(64);
        for (int i5 = 0; i5 < ancestorMappings.length; ++i5) {
            Object ancestorObj;
            FieldMapping fieldMapping3 = ancestorMappings[i5];
            boolean found = false;
            for (ObjInfo ancestor = parentInfo; ancestor != null; ancestor = ancestor.getParent()) {
                if (!fieldMapping3.getField().getType().isInstance(ancestor.getObject())) continue;
                found = true;
                try {
                    fieldMapping3.getField().setAccessible(true);
                    fieldMapping3.getField().set(obj, ancestor.getObject());
                }
                catch (IllegalArgumentException e) {
                    info.addMessage(fieldMapping3.getName(), 2, "Ancestor field '" + fieldMapping3.getField().getName() + "' type (" + fieldMapping3.getBaseClass().getName() + ") is not compatible with the parent type: " + ancestor.getObject().getClass().getName() + ". Will be null.");
                }
                catch (IllegalAccessException e) {
                    info.addMessage(fieldMapping3.getName(), 0, "Ancestor field '" + fieldMapping3.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
                break;
            }
            if (found || (ancestorObj = this.instantiationContext.getAncestor(fieldMapping3.getField().getType())) == null) continue;
            found = true;
            try {
                fieldMapping3.getField().setAccessible(true);
                fieldMapping3.getField().set(obj, ancestorObj);
                continue;
            }
            catch (IllegalArgumentException e) {
                info.addMessage(fieldMapping3.getName(), 2, "Ancestor field '" + fieldMapping3.getField().getName() + "' type (" + fieldMapping3.getBaseClass().getName() + ") is not compatible with the parent type: " + ancestorObj.getClass().getName() + ". Will be null.");
                continue;
            }
            catch (IllegalAccessException e) {
                info.addMessage(fieldMapping3.getName(), 0, "Ancestor field '" + fieldMapping3.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
            }
        }
        FieldMapping[] contentMappings = mappings.getMappings(8);
        if (contentMappings.length > 0) {
            for (int i6 = 0; i6 < contentMappings.length; ++i6) {
                FieldMapping fieldMapping4 = contentMappings[i6];
                Object value = null;
                try {
                    value = this.instanciateSimpleType(info, fieldMapping4.getField().getType(), iNode.getContent(), iNode.getLine(), xmlFile);
                }
                catch (Exception e) {
                    info.addMessage(fieldMapping4.getName(), 0, "Content mapping could not be parsed as simple type '" + fieldMapping4.getField().getType() + "'.", e);
                    continue;
                }
                try {
                    fieldMapping4.getField().setAccessible(true);
                    fieldMapping4.getField().set(obj, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    info.addMessage(fieldMapping4.getName(), 0, "Content field '" + fieldMapping4.getField().getName() + "' is not of expected type (" + fieldMapping4.getField().getType().getName() + "): " + value);
                    continue;
                }
                catch (IllegalAccessException e) {
                    info.addMessage(fieldMapping4.getName(), 0, "Content field '" + fieldMapping4.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
            }
        }
        ArrayList<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
        Collection<XmlAttribute> attrs = iNode.getAttributes();
        if (attrs != null) {
            for (XmlAttribute attr : attrs) {
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI()) || attr.getName().equals("xmlns") || attr.getName().startsWith("xmlns:")) continue;
                attributes.add(attr);
            }
        }
        FieldMapping[] attrMappings = mappings.getMappings(1);
        for (i3 = attrMappings.length - 1; i3 >= 0; --i3) {
            fieldMapping2 = attrMappings[i3];
            XmlAttribute attr = null;
            for (int j = 0; j < attributes.size(); ++j) {
                XmlAttribute curAttr = (XmlAttribute)attributes.get(j);
                if (!fieldMapping2.getName().equals(curAttr.getLocalName())) continue;
                attr = curAttr;
                break;
            }
            if (attr == null) continue;
            attrMappings[i3] = null;
            String textVal = attr.getValue();
            attributes.remove(attr);
            if (this.isSimpleType(fieldMapping2.getBaseClass())) {
                Object val = null;
                try {
                    val = this.instanciateSimpleType(info, fieldMapping2.getBaseClass(), textVal, iNode.getLine(), xmlFile);
                }
                catch (Exception e) {
                    info.addMessage(fieldMapping2.getName(), 0, "Simple type attribute '" + fieldMapping2.getName() + "' could not be parsed.", e);
                    continue;
                }
                try {
                    fieldMapping2.getField().setAccessible(true);
                    fieldMapping2.getField().set(obj, val);
                }
                catch (IllegalArgumentException e) {
                    info.addMessage(fieldMapping2.getName(), 0, "Attribute '" + fieldMapping2.getName() + "' was not casted to the expected type (expected: " + fieldMapping2.getField().getType().getName() + " / cast: " + (val == null ? "?" : val.getClass().getName()) + ")");
                }
                catch (IllegalAccessException e) {
                    info.addMessage(fieldMapping2.getName(), 0, "Field '" + fieldMapping2.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
                continue;
            }
            info.addMessage(fieldMapping2.getName(), 0, "Field '" + fieldMapping2.getField().getName() + "' is not a simple type: cannot be mapped to an attribute.");
        }
        for (i3 = 0; i3 < attributes.size(); ++i3) {
            XmlAttribute attr = (XmlAttribute)attributes.get(i3);
            info.addMessage(null, 0, "Attribute '" + attr.getName() + "' does not match to any field of the class '" + obj.getClass() + "'.");
        }
        for (i3 = 0; i3 < attrMappings.length; ++i3) {
            fieldMapping2 = attrMappings[i3];
            if (fieldMapping2 == null || fieldMapping2.getMinOccurs() <= 0) continue;
            info.addMessage(fieldMapping2.getName(), 0, "Attribute '" + fieldMapping2.getName() + "' required.");
        }
        ArrayList<XmlElement> childrenElts = new ArrayList<XmlElement>();
        List<XmlElement> childrenList = iNode.getChildren();
        if (childrenList != null) {
            for (int j = 0; j < childrenList.size(); ++j) {
                childrenElts.add(childrenList.get(j));
            }
        }
        FieldMapping[] childMappings = mappings.getMappings(2);
        for (i2 = childMappings.length - 1; i2 >= 0; --i2) {
            XmlElement elt;
            Object o;
            fieldMapping = childMappings[i2];
            XmlElement mappedElement = null;
            for (int j = 0; j < childrenElts.size(); ++j) {
                XmlElement curElt = (XmlElement)childrenElts.get(j);
                if (!fieldMapping.getName().equals(curElt.getLocalName())) continue;
                mappedElement = curElt;
                break;
            }
            if (mappedElement == null) continue;
            info.setMappingLocation(fieldMapping.getName(), mappedElement.getLine());
            childrenElts.remove(mappedElement);
            childMappings[i2] = null;
            if (this.isSimpleType(fieldMapping.getBaseClass())) {
                String textVal = mappedElement.getContent();
                Object val = null;
                try {
                    val = this.instanciateSimpleType(info, fieldMapping.getBaseClass(), textVal, mappedElement.getLine(), xmlFile);
                }
                catch (Exception e) {
                    info.addMessage(fieldMapping.getName(), 0, "Simple type element '" + fieldMapping.getName() + "' could not be parsed.", e);
                    continue;
                }
                try {
                    fieldMapping.getField().setAccessible(true);
                    fieldMapping.getField().set(obj, val);
                }
                catch (IllegalArgumentException e) {
                    info.addMessage(fieldMapping.getName(), 0, "Element '" + fieldMapping.getName() + "' was not casted to the expected type (expected: " + fieldMapping.getField().getType().getName() + " / cast: " + val.getClass().getName() + ")");
                }
                catch (IllegalAccessException e) {
                    info.addMessage(fieldMapping.getName(), 0, "Field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
                continue;
            }
            ArrayList<XmlElement> arrayElements = new ArrayList<XmlElement>();
            for (int k = 0; k < mappedElement.getChildren().size(); ++k) {
                if (!(mappedElement.getChildren().get(k) instanceof XmlElement)) continue;
                arrayElements.add(mappedElement.getChildren().get(k));
            }
            if (arrayElements.size() < fieldMapping.getMinOccurs()) {
                info.addMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at least " + fieldMapping.getMinOccurs() + " children.");
            } else if (arrayElements.size() > fieldMapping.getMaxOccurs()) {
                info.addMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at most " + fieldMapping.getMaxOccurs() + " children.");
            }
            if (arrayElements.size() <= 0) continue;
            if (fieldMapping.getField().getType().isArray()) {
                Class<?> baseType = fieldMapping.getField().getType().getComponentType();
                ArrayList<Object> arrayObjects = new ArrayList<Object>();
                for (int j = 0; j < arrayElements.size(); ++j) {
                    XmlElement elt2 = (XmlElement)arrayElements.get(j);
                    Object o2 = this.instanciateElt(info, elt2, xmlFile);
                    if (o2 == null) continue;
                    if (!baseType.isInstance(o2)) {
                        info.addMessage(fieldMapping.getName(), 0, "Child element is not of expected type: '" + baseType.getName() + "'.");
                        continue;
                    }
                    arrayObjects.add(o2);
                }
                Object arr = Array.newInstance(baseType, arrayObjects.size());
                for (int j = 0; j < arrayObjects.size(); ++j) {
                    Array.set(arr, j, arrayObjects.get(j));
                }
                try {
                    fieldMapping.getField().setAccessible(true);
                    fieldMapping.getField().set(obj, arr);
                }
                catch (IllegalArgumentException e) {
                    info.addMessage(fieldMapping.getName(), 0, "Instanciated elements array '" + fieldMapping.getName() + "' is not of the expected type (expected: " + baseType.getName() + "[] / instanciated: " + arr.getClass().getComponentType().getName() + "[])");
                }
                catch (IllegalAccessException e) {
                    info.addMessage(fieldMapping.getName(), 0, "Field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
                continue;
            }
            if (arrayElements.size() > 1) {
                info.addMessage(fieldMapping.getName(), 0, "Only one '" + fieldMapping.getName() + "' child node expected.");
            }
            if ((o = this.instanciateElt(info, elt = (XmlElement)arrayElements.get(0), xmlFile)) == null) continue;
            if (!fieldMapping.getField().getType().isInstance(o)) {
                info.addMessage(fieldMapping.getName(), 0, "Child element is not of expected type: '" + fieldMapping.getField().getType().getName() + "'.");
                continue;
            }
            try {
                fieldMapping.getField().setAccessible(true);
                fieldMapping.getField().set(obj, o);
                continue;
            }
            catch (IllegalArgumentException e) {
                info.addMessage(fieldMapping.getName(), 0, "Instanciated element '" + fieldMapping.getName() + "' is not of the expected type (expected: " + fieldMapping.getField().getType().getName() + " / instanciated: " + o.getClass().getName() + ")");
                continue;
            }
            catch (IllegalAccessException e) {
                info.addMessage(fieldMapping.getName(), 0, "Field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
            }
        }
        for (i2 = 0; i2 < childMappings.length; ++i2) {
            fieldMapping = childMappings[i2];
            if (fieldMapping == null || fieldMapping.getMinOccurs() <= 0) continue;
            info.addMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' is required for class '" + obj.getClass() + "'.");
        }
        ArrayList<Object> collectableObjs = new ArrayList<Object>();
        for (int i7 = childrenElts.size() - 1; i7 >= 0; --i7) {
            XmlElement curElt = (XmlElement)childrenElts.get(i7);
            Object o = this.instanciateElt(info, curElt, xmlFile);
            if (o == null) {
                childrenElts.remove(i7);
                continue;
            }
            collectableObjs.add(0, o);
        }
        FieldMapping[] collectedMappings = mappings.getMappings(4);
        for (i = collectedMappings.length - 1; i >= 0; --i) {
            FieldMapping fieldMapping5 = collectedMappings[i];
            Class<?> baseType = fieldMapping5.getBaseClass();
            ArrayList matchingObjects = new ArrayList();
            ArrayList matchingElements = new ArrayList();
            for (int j = collectableObjs.size() - 1; j >= 0; --j) {
                Object o = collectableObjs.get(j);
                if (!baseType.isInstance(o)) continue;
                collectableObjs.remove(j);
                Object elt = childrenElts.remove(j);
                matchingObjects.add(0, o);
                matchingElements.add(0, elt);
            }
            if (matchingElements.size() > 0) {
                info.setMappingLocation(fieldMapping5.getName(), ((XmlElement)matchingElements.get(0)).getLine());
            }
            if (matchingObjects.size() < fieldMapping5.getMinOccurs()) {
                info.addMessage(fieldMapping5.getName(), 0, "Child node '" + fieldMapping5.getName() + "' expects at least " + fieldMapping5.getMinOccurs() + " children.");
            } else if (matchingObjects.size() > fieldMapping5.getMaxOccurs()) {
                info.addMessage(fieldMapping5.getName(), 0, "Child node '" + fieldMapping5.getName() + "' expects at most " + fieldMapping5.getMaxOccurs() + " children.");
            }
            if (matchingObjects.size() <= 0) continue;
            if (fieldMapping5.getField().getType().isArray()) {
                Object arr = Array.newInstance(baseType, matchingObjects.size());
                for (int j = 0; j < matchingObjects.size(); ++j) {
                    Array.set(arr, j, matchingObjects.get(j));
                }
                try {
                    fieldMapping5.getField().setAccessible(true);
                    fieldMapping5.getField().set(obj, arr);
                }
                catch (IllegalArgumentException e) {
                    info.addMessage(fieldMapping5.getName(), 0, "Instanciated elements array '" + fieldMapping5.getName() + "' is not of the expected type (expected: " + baseType.getName() + "[] / instanciated: " + arr.getClass().getComponentType().getName() + "[])");
                }
                catch (IllegalAccessException e) {
                    info.addMessage(fieldMapping5.getName(), 0, "Field '" + fieldMapping5.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
                continue;
            }
            if (matchingObjects.size() > 1) {
                info.addMessage(fieldMapping5.getName(), 0, "Only one '" + fieldMapping5.getName() + "' child node expected.");
            }
            Object o = matchingObjects.get(0);
            try {
                fieldMapping5.getField().setAccessible(true);
                fieldMapping5.getField().set(obj, o);
                continue;
            }
            catch (IllegalArgumentException e) {
                info.addMessage(fieldMapping5.getName(), 0, "Instanciated element '" + fieldMapping5.getName() + "' is not of the expected type (expected: " + fieldMapping5.getField().getType().getName() + " / instanciated: " + o.getClass().getName() + ")");
                continue;
            }
            catch (IllegalAccessException e) {
                info.addMessage(fieldMapping5.getName(), 0, "Field '" + fieldMapping5.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
            }
        }
        for (i = 0; i < childrenElts.size(); ++i) {
            XmlElement elt = (XmlElement)childrenElts.get(i);
            Object o = collectableObjs.get(i);
            info.addMessage(null, 0, "Node '" + elt.getTagName() + "' (--> " + o.getClass() + ") does not match to any field of the class '" + obj.getClass() + "'.");
        }
        return obj;
    }
}

