/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.ow2.opensuit.xmlmap.impl.ObjInfo;
import org.ow2.opensuit.xmlmap.impl.ObjInfoHolder;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.schema.ISchema;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.opensuit.xmlmap.utils.XmlHelper;
import org.ow2.opensuit.xmlmap.utils.XsdHelper;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSerializer
extends ObjInfoHolder {
    private Document doc;
    private SchemasManager manager;
    private Object root;

    public Document getDocument() {
        return this.doc;
    }

    public static final XmlSerializer serialize(SchemasManager iManager, Object iRoot) throws ParserConfigurationException {
        XmlSerializer serializer = new XmlSerializer(iManager, iRoot);
        serializer.serialize();
        return serializer;
    }

    public static final XmlSerializer serialize(SchemasManager iManager, Object iRoot, OutputStream output) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        XmlSerializer serializer = XmlSerializer.serialize(iManager, iRoot);
        XmlHelper.serializeXml(serializer.getDocument(), output);
        return serializer;
    }

    public XmlSerializer(SchemasManager iManager, Object iRoot) throws ParserConfigurationException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.manager = iManager;
        this.root = iRoot;
    }

    private void serialize() {
        ObjInfo rootInfo = new ObjInfo(null, this.root);
        this.addInfo(rootInfo);
        this.serializeObj(this.doc, rootInfo);
        Element element = this.doc.getDocumentElement();
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ISchema[] imports = this.manager.getAllSchemas();
        StringBuffer schemaLocation = new StringBuffer();
        for (int i = 0; i < imports.length; ++i) {
            element.setAttribute("xmlns:" + imports[i].getName(), imports[i].getNamespace());
            schemaLocation.append(imports[i].getNamespace());
            schemaLocation.append(" ");
            schemaLocation.append(imports[i].getLocator());
            schemaLocation.append(" ");
        }
        element.setAttribute("xsi:schemaLocation", schemaLocation.toString());
    }

    private void serializeObj(Node iParent, ObjInfo iObjInfo) {
        ISchemaElement schemaElt = this.manager.getElement(iObjInfo.getObject().getClass());
        if (schemaElt == null) {
            iObjInfo.addMessage(null, 0, "Object not found in any declared schema.");
            return;
        }
        Element element = this.doc.createElement(schemaElt.getSchema().getName() + ":" + schemaElt.getTagName());
        iParent.appendChild(element);
        ElementMapping mappings = schemaElt.getSchema().getMethod().getElementMappings(iObjInfo.getObject().getClass(), true);
        FieldMapping[] contentMappings = mappings.getMappings(8);
        if (contentMappings.length > 0) {
            for (int i = 0; i < contentMappings.length; ++i) {
                FieldMapping fieldMapping = contentMappings[i];
                fieldMapping.getField().setAccessible(true);
                try {
                    String content = (String)fieldMapping.getField().get(iObjInfo.getObject());
                    if (content == null) continue;
                    CDATASection cdata = this.doc.createCDATASection(content);
                    element.appendChild(cdata);
                    continue;
                }
                catch (Exception e) {
                    iObjInfo.addMessage(fieldMapping.getName(), 0, "Content field '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                }
            }
        }
        FieldMapping[] attrMappings = mappings.getMappings(1);
        for (int i = 0; i < attrMappings.length; ++i) {
            FieldMapping fieldMapping = attrMappings[i];
            fieldMapping.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping.getField().get(iObjInfo.getObject());
            }
            catch (Exception e) {
                iObjInfo.addMessage(fieldMapping.getName(), 0, "Attribute field '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping.isUseRequired()) continue;
                iObjInfo.addMessage(fieldMapping.getName(), 0, "Attribute '" + fieldMapping.getName() + "' required.");
                continue;
            }
            String simpleValue = XsdHelper.formatSimpleType(val, fieldMapping.getBaseClass());
            if (simpleValue != null) {
                element.setAttribute(fieldMapping.getName(), simpleValue);
                continue;
            }
            if (!schemaElt.getSchema().getMethod().isEnumeration(fieldMapping.getBaseClass())) continue;
            String enumValName = schemaElt.getSchema().getMethod().getEnumItemName(val);
            element.setAttribute(fieldMapping.getName(), enumValName);
        }
        FieldMapping[] childMappings = mappings.getMappings(2);
        for (int i = 0; i < childMappings.length; ++i) {
            FieldMapping fieldMapping = childMappings[i];
            fieldMapping.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping.getField().get(iObjInfo.getObject());
            }
            catch (Exception e) {
                iObjInfo.addMessage(fieldMapping.getName(), 0, "Child node field '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping.isUseRequired()) continue;
                iObjInfo.addMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' required.");
                continue;
            }
            Element childNode = this.doc.createElement(fieldMapping.getName());
            element.appendChild(childNode);
            String simpleValue = XsdHelper.formatSimpleType(val, fieldMapping.getBaseClass());
            if (simpleValue != null) {
                childNode.appendChild(this.doc.createTextNode(simpleValue));
                continue;
            }
            if (schemaElt.getSchema().getMethod().isEnumeration(fieldMapping.getBaseClass())) {
                String enumValName = schemaElt.getSchema().getMethod().getEnumItemName(val);
                childNode.appendChild(this.doc.createTextNode(enumValName));
                continue;
            }
            if (fieldMapping.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping.getMinOccurs()) {
                    iObjInfo.addMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at least " + fieldMapping.getMinOccurs() + " children.");
                } else if (len > fieldMapping.getMaxOccurs()) {
                    iObjInfo.addMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at most " + fieldMapping.getMaxOccurs() + " children.");
                }
                for (int j = 0; j < len; ++j) {
                    Object v = Array.get(val, j);
                    if (v == null) continue;
                    ObjInfo childInfo = new ObjInfo(iObjInfo, v);
                    this.addInfo(childInfo);
                    this.serializeObj(childNode, childInfo);
                }
                continue;
            }
            ObjInfo childInfo = new ObjInfo(iObjInfo, val);
            this.addInfo(childInfo);
            this.serializeObj(childNode, childInfo);
        }
        FieldMapping[] collectedMappings = mappings.getMappings(4);
        for (int i = 0; i < collectedMappings.length; ++i) {
            FieldMapping fieldMapping = collectedMappings[i];
            fieldMapping.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping.getField().get(iObjInfo.getObject());
            }
            catch (Exception e) {
                iObjInfo.addMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping.isUseRequired()) continue;
                iObjInfo.addMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getName() + "' required.");
                continue;
            }
            if (fieldMapping.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping.getMinOccurs()) {
                    iObjInfo.addMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getName() + "' expects at least " + fieldMapping.getMinOccurs() + " children.");
                } else if (len > fieldMapping.getMaxOccurs()) {
                    iObjInfo.addMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getName() + "' expects at most " + fieldMapping.getMaxOccurs() + " children.");
                }
                for (int j = 0; j < len; ++j) {
                    Object v = Array.get(val, j);
                    ObjInfo childInfo = new ObjInfo(iObjInfo, v);
                    this.addInfo(childInfo);
                    this.serializeObj(element, childInfo);
                }
                continue;
            }
            ObjInfo childInfo = new ObjInfo(iObjInfo, val);
            this.addInfo(childInfo);
            this.serializeObj(element, childInfo);
        }
    }
}

