/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.ow2.opensuit.xmlmap.impl.ObjInfo;
import org.ow2.opensuit.xmlmap.impl.ObjInfoHolder;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

public abstract class InitializableObjInfoHolder
extends ObjInfoHolder {
    protected void initializeAll(IInstantiationContext iValidSupport) {
        InitializerImpl initializer = new InitializerImpl(this, iValidSupport);
        initializer.initializeAll();
    }

    protected abstract Object instantiateFile(URL var1, ObjInfo var2) throws Exception;

    private class InitializerImpl {
        private IInstantiationContext validSupport;
        private List<ObjInfo> toInitialize = new ArrayList<ObjInfo>();
        private List<ObjInfo> initializing = new ArrayList<ObjInfo>();

        public InitializerImpl(ObjInfoHolder objInfoHolder, IInstantiationContext iValidSupport) {
            this.validSupport = iValidSupport;
            this.addObjsToInitialize(0);
        }

        private void addObjsToInitialize(int startIndex) {
            List<ObjInfo> objInfos = InitializableObjInfoHolder.this.getAllObjInfo();
            for (int i = startIndex; i < objInfos.size(); ++i) {
                ObjInfo info = objInfos.get(i);
                if (info.getObject() == null || !(info.getObject() instanceof IInitializable)) continue;
                this.toInitialize.add(info);
            }
        }

        public void initializeAll() {
            while (!this.toInitialize.isEmpty()) {
                ObjInfo info = this.toInitialize.get(0);
                this.doInitialize(info);
            }
        }

        private boolean doCouldInitialize(Object object) {
            if (object == null) {
                return false;
            }
            ObjInfo info = InitializableObjInfoHolder.this.getInfoFromObj(object);
            if (info == null) {
                return true;
            }
            if (object instanceof IInitializable) {
                if (this.initializing.contains(info)) {
                    StringBuffer sb = new StringBuffer("Cyclic dependency found: ");
                    for (int i = 0; i < this.initializing.size(); ++i) {
                        ObjInfo inf = this.initializing.get(i);
                        sb.append(inf.getObject().getClass().getName());
                        sb.append(" --> ");
                    }
                    sb.append(info.getObject().getClass().getName());
                    throw new RuntimeException(sb.toString());
                }
                if (this.toInitialize.contains(info)) {
                    this.doInitialize(info);
                }
            }
            return !info.hasMessages(1);
        }

        private void doInitialize(ObjInfo info) {
            this.toInitialize.remove(info);
            this.initializing.add(info);
            try {
                ((IInitializable)info.getObject()).initialize(new InitializationSupportImpl(info), this.validSupport);
            }
            catch (Throwable t) {
                info.addMessage(null, 1, "Initialization error.", t);
            }
            this.initializing.remove(info);
        }

        private class InitializationSupportImpl
        implements IInitializationSupport {
            private ObjInfo info;

            public InitializationSupportImpl(ObjInfo info) {
                this.info = info;
            }

            public void addValidationMessage(Object fromNode, String mappingName, int severity, String message) {
                this.addValidationMessage(fromNode, mappingName, severity, message, null);
            }

            public void addValidationMessage(Object fromNode, String mappingName, int severity, String message, Throwable error) {
                if (fromNode == this.info.getObject()) {
                    this.info.addMessage(mappingName, severity, message, error);
                } else {
                    ObjInfo info2 = InitializableObjInfoHolder.this.getInfoFromObj(fromNode);
                    if (info2 != null) {
                        info2.addMessage(mappingName, severity, message, error);
                    }
                }
            }

            public boolean initialize(Object object) {
                boolean dependencyCouldInit = InitializerImpl.this.doCouldInitialize(object);
                return dependencyCouldInit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object instantiate(URL xmlFileUrl) throws Exception {
                int nbObjsBefore = InitializableObjInfoHolder.this.getAllObjInfo().size();
                try {
                    Object object = InitializableObjInfoHolder.this.instantiateFile(xmlFileUrl, this.info);
                    return object;
                }
                finally {
                    InitializerImpl.this.addObjsToInitialize(nbObjsBefore);
                }
            }
        }
    }
}

