/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.ow2.opensuit.xmlmap.impl.IXmlModelMessage;
import org.ow2.opensuit.xmlmap.impl.ObjInfo;

public class ModelMessageImpl
implements IXmlModelMessage {
    private ObjInfo objInfo;
    private String mapping;
    private int type;
    private String msg;
    private Throwable error;

    public ModelMessageImpl(ObjInfo iObjInfo, String iMappingName, int iType, String iMsg, Throwable error) {
        this.objInfo = iObjInfo;
        this.mapping = iMappingName;
        this.type = iType;
        this.msg = iMsg;
        this.error = error;
    }

    public Object getObject() {
        return this.objInfo.getObject();
    }

    public ObjInfo getInfo() {
        return this.objInfo;
    }

    public String getMappingName() {
        return this.mapping;
    }

    public String getMessage() {
        if (this.error == null) {
            return this.msg;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.msg);
        this.error.printStackTrace(pw);
        return sw.toString();
    }

    public int getSeverity() {
        return this.type;
    }

    public URL getFile() {
        return this.objInfo.getXmlFile();
    }

    public int getLine() {
        return this.objInfo.getMappingLocation(this.mapping);
    }

    public void dump(PrintWriter iPrinter) {
        switch (this.type) {
            case 0: {
                iPrinter.print("+ Instanciation Error: ");
                break;
            }
            case 2: {
                iPrinter.print("+ Instanciation Warning: ");
                break;
            }
            case 4: {
                iPrinter.print("+ Instanciation Info: ");
                break;
            }
            case 1: {
                iPrinter.print("+ Validation Error: ");
                break;
            }
            case 3: {
                iPrinter.print("+ Validation Warning: ");
                break;
            }
            case 5: {
                iPrinter.print("+ Validation Info: ");
            }
        }
        iPrinter.println(this.msg);
        if (this.error != null) {
            this.error.printStackTrace(iPrinter);
        }
    }
}

