/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.impl;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ow2.opensuit.xmlmap.impl.IXmlModelMessage;
import org.ow2.opensuit.xmlmap.impl.ModelMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjInfo {
    private ObjInfo parent;
    private Object obj;
    private List<IXmlModelMessage> messages;
    private URL xmlFile;
    private int lineNumber = -1;
    private HashMap<String, Integer> mappingName2Line;

    public ObjInfo(ObjInfo iParent, Object iObj) {
        this.parent = iParent;
        this.obj = iObj;
    }

    public void setMappingLocation(String name, int line) {
        if (this.mappingName2Line == null) {
            this.mappingName2Line = new HashMap(1);
        }
        this.mappingName2Line.put(name, line);
    }

    public int getMappingLocation(String name) {
        if (name == null || this.mappingName2Line == null) {
            return this.lineNumber;
        }
        Integer mappingLine = this.mappingName2Line.get(name);
        return mappingLine == null ? this.lineNumber : mappingLine;
    }

    public void setLocation(URL xmlFile, int lineNumber) {
        this.xmlFile = xmlFile;
        this.lineNumber = lineNumber;
    }

    public URL getXmlFile() {
        return this.xmlFile;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Object getObject() {
        return this.obj;
    }

    public ObjInfo getParent() {
        return this.parent;
    }

    public void clearMessages() {
        if (this.messages == null) {
            return;
        }
        this.messages.clear();
    }

    public void addMessage(String iMappingName, int iType, String iMessage) {
        this.addMessage(iMappingName, iType, iMessage, null);
    }

    public void addMessage(String iMappingName, int iType, String iMessage, Throwable error) {
        if (this.messages == null) {
            this.messages = new ArrayList<IXmlModelMessage>(1);
        }
        this.messages.add(new ModelMessageImpl(this, iMappingName, iType, iMessage, error));
    }

    public int countMessages(int treshold) {
        if (this.messages == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.messages.size(); ++i) {
            if (((ModelMessageImpl)this.messages.get(i)).getSeverity() > treshold) continue;
            ++count;
        }
        return count;
    }

    public List<IXmlModelMessage> getMessages(int treshold) {
        if (this.messages == null) {
            return null;
        }
        ArrayList<IXmlModelMessage> ret = new ArrayList<IXmlModelMessage>();
        for (int i = 0; i < this.messages.size(); ++i) {
            if (((ModelMessageImpl)this.messages.get(i)).getSeverity() > treshold) continue;
            ret.add(this.messages.get(i));
        }
        return ret;
    }

    public boolean hasMessages(int treshold) {
        if (this.messages == null) {
            return false;
        }
        for (int i = 0; i < this.messages.size(); ++i) {
            if (((ModelMessageImpl)this.messages.get(i)).getSeverity() > treshold) continue;
            return true;
        }
        return false;
    }

    public void dumpMessages(int treshold, PrintWriter iPrinter) {
        List<IXmlModelMessage> errors = this.getMessages(treshold);
        if (errors == null || errors.size() == 0) {
            return;
        }
        iPrinter.println("[" + this.getNicePath() + "]:");
        for (int i = 0; i < errors.size(); ++i) {
            ((ModelMessageImpl)errors.get(i)).dump(iPrinter);
        }
        iPrinter.println(" ");
    }

    private String getNicePath() {
        if (this.obj == null) {
            if (this.xmlFile != null) {
                return this.xmlFile + "(l " + (this.lineNumber >= 0 ? String.valueOf(this.lineNumber) : "?") + ") > Document";
            }
            return "Document";
        }
        if (this.xmlFile != null) {
            return this.xmlFile + "(l " + (this.lineNumber >= 0 ? String.valueOf(this.lineNumber) : "?") + ") > " + this.obj.getClass().getName();
        }
        return this.obj.getClass().getName();
    }
}

