/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.impl;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.ow2.opensuit.xmlmap.impl.IXmlModelMessage;
import org.ow2.opensuit.xmlmap.impl.ObjInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjInfoHolder {
    private List<ObjInfo> elements = new ArrayList<ObjInfo>();
    private List<URL> files = new ArrayList<URL>();
    private static final URL[] URL_ARRAY_TYPE = new URL[0];

    public List<ObjInfo> getAllObjInfo() {
        return this.elements;
    }

    public ObjInfo getInfoFromObj(Object iObj) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (iObj != this.elements.get(i).getObject()) continue;
            return this.elements.get(i);
        }
        return null;
    }

    protected void addInfo(ObjInfo info) {
        this.elements.add(info);
        if (info.getXmlFile() != null && !this.files.contains(info.getXmlFile())) {
            this.files.add(info.getXmlFile());
        }
    }

    protected void removeAllInfo() {
        this.elements.clear();
        this.files.clear();
    }

    public URL[] getAllFiles() {
        return this.files.toArray(URL_ARRAY_TYPE);
    }

    private int countMessages(int treshold) {
        int nbErrs = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            ObjInfo oi = this.elements.get(i);
            nbErrs += oi.countMessages(treshold);
        }
        return nbErrs;
    }

    public void dumpMessages(int treshold, PrintWriter iPrinter) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).dumpMessages(treshold, iPrinter);
        }
        iPrinter.flush();
    }

    public boolean hasMessages(int treshold) {
        return this.countMessages(treshold) > 0;
    }

    public IXmlModelMessage[] getAllMessages() {
        ArrayList<IXmlModelMessage> retList = new ArrayList<IXmlModelMessage>();
        for (int i = 0; i < this.elements.size(); ++i) {
            ObjInfo oi = this.elements.get(i);
            List<IXmlModelMessage> msgs = oi.getMessages(5);
            if (msgs == null) continue;
            retList.addAll(msgs);
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    public IXmlModelMessage[] getAllElementMessages(Object iXmlElement) {
        ObjInfo oi = this.getInfoFromObj(iXmlElement);
        if (oi == null) {
            return null;
        }
        List<IXmlModelMessage> msgs = oi.getMessages(5);
        if (msgs == null) {
            return null;
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[msgs.size()];
        msgs.toArray(ret);
        return ret;
    }

    public IXmlModelMessage[] getGlobalElementMessages(Object iXmlElement) {
        ObjInfo oi = this.getInfoFromObj(iXmlElement);
        if (oi == null) {
            return null;
        }
        List<IXmlModelMessage> msgs = oi.getMessages(5);
        if (msgs == null) {
            return null;
        }
        ArrayList<IXmlModelMessage> retList = new ArrayList<IXmlModelMessage>();
        for (int i = 0; i < msgs.size(); ++i) {
            IXmlModelMessage msg = msgs.get(i);
            if (msg.getMappingName() != null) continue;
            retList.add(msg);
        }
        if (retList.isEmpty()) {
            return null;
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    public IXmlModelMessage[] getMappingElementMessages(Object iXmlElement, String iMappingName) {
        ObjInfo oi = this.getInfoFromObj(iXmlElement);
        if (oi == null) {
            return null;
        }
        List<IXmlModelMessage> msgs = oi.getMessages(5);
        if (msgs == null) {
            return null;
        }
        ArrayList<IXmlModelMessage> retList = new ArrayList<IXmlModelMessage>();
        for (int i = 0; i < msgs.size(); ++i) {
            IXmlModelMessage msg = msgs.get(i);
            if (!iMappingName.equals(msg.getMappingName())) continue;
            retList.add(msg);
        }
        if (retList.isEmpty()) {
            return null;
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[retList.size()];
        retList.toArray(ret);
        return ret;
    }
}

