/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ow2.opensuit.xmlmap.impl.UnsupportedMapping;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.mapping.IMappingMethod;
import org.ow2.opensuit.xmlmap.schema.ISchema;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.opensuit.xmlmap.utils.XsdHelper;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaImpl
implements ISchema {
    private static final ISchema[] SCHEMAS_ARRAY_TYPE = new ISchema[0];
    private static final ISchemaElement[] ELTS_ARRAY_TYPE = new ISchemaElement[0];
    private static final SchemaElement NO_ELT = new SchemaElement();
    private SchemasManager manager;
    private List<ISchema> usedSchemas = new ArrayList<ISchema>();
    private boolean manageInheritance = true;
    private boolean built = false;
    private String name;
    private String locator;
    private String pkg;
    private String version;
    private IMappingMethod method;
    private Map<Class<?>, ISchemaElement> class2Infos = new HashMap();

    public SchemaImpl(SchemasManager iMgr, String iName, String iLocator, String iPackage) {
        this.manager = iMgr;
        this.name = iName;
        this.locator = iLocator;
        this.pkg = iPackage;
        this.loadConfig();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocator() {
        return this.locator;
    }

    private IMappingMethod instantiateMappingMethod(String methodClassName) throws Exception {
        try {
            Class<?> methodClass = Class.forName(methodClassName, true, this.manager.getClassLoader());
            if (!IMappingMethod.class.isAssignableFrom(methodClass)) {
                throw new Exception("Mapping Method class '" + methodClassName + "' is not a valid mapping method implementation.");
            }
            return (IMappingMethod)methodClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Mapping Method class '" + methodClassName + "' not found.", e);
        }
        catch (InstantiationException e) {
            throw new Exception("Error while instantiating Mapping Method class '" + methodClassName + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not instantiate Mapping Method class '" + methodClassName + "'.", e);
        }
    }

    private void info(String message) {
        System.out.println("[" + this.getNamespace() + "] INFO: " + message);
    }

    private void error(String message, Exception t) {
        System.err.println("[" + this.getNamespace() + "] ERROR: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    private void loadConfig() {
        InputStream configIn = this.getClass().getClassLoader().getResourceAsStream(this.pkg.replace('.', '/') + "/xmlmap.properties");
        if (configIn != null) {
            try {
                Properties config = new Properties();
                config.load(configIn);
                this.version = config.getProperty("version");
                String methodClassName = config.getProperty("method");
                if (methodClassName != null) {
                    try {
                        this.method = this.instantiateMappingMethod(methodClassName);
                        this.info("Use Mapping Method '" + methodClassName + "'");
                    }
                    catch (Exception e) {
                        this.error(e.getMessage(), e);
                    }
                }
            }
            catch (IOException e) {
                this.error("Error while loading xmlmap configuration from " + this.pkg.replace('.', '/') + "/xmlmap.properties", e);
            }
        }
    }

    @Override
    public IMappingMethod getMethod() {
        if (this.method != null) {
            return this.method;
        }
        if (this.method == null) {
            try {
                this.method = this.instantiateMappingMethod("org.ow2.opensuit.xmlmap.BindWithAnnotations");
                this.info("Selected default mapping method '" + this.method.getClass().getName() + "'");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.method == null) {
            try {
                this.method = this.instantiateMappingMethod("org.ow2.opensuit.xmlmap.BindWithNamingRules");
                this.info("Selected default mapping method '" + this.method.getClass().getName() + "'");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.method == null) {
            try {
                this.method = this.instantiateMappingMethod("org.ow2.opensuit.xmlmap.BindImplicitely");
                this.info("Selected default mapping method '" + this.method.getClass().getName() + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.method == null) {
            this.error("No mapping method found. Please add an xmlmap-method jar file to your classpath.", null);
        }
        return this.method;
    }

    @Override
    public String getRootPackage() {
        return this.pkg;
    }

    @Override
    public String getNamespace() {
        return "xmlmap://" + this.pkg + "/" + (this.version == null ? "unversioned" : this.version);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isFullyBuilt() {
        return this.built;
    }

    public String toString() {
        return "Schema[" + this.name + "," + this.locator + "," + this.pkg + "]";
    }

    private void setUsedSchema(ISchema iSchema) {
        if (iSchema == this) {
            return;
        }
        if (!this.usedSchemas.contains(iSchema)) {
            this.usedSchemas.add(iSchema);
        }
    }

    @Override
    public ISchemaElement getElement(Class<?> iClass) {
        SchemaElement elt = (SchemaElement)this.class2Infos.get(iClass);
        if (elt == null) {
            String className = iClass.getName();
            if (!className.startsWith(this.pkg + ".")) {
                return null;
            }
            String tag = className.substring(this.pkg.length() + 1);
            if (iClass.isInterface()) {
                if (this.getMethod().isSubstitutionGroup(iClass)) {
                    elt = new SchemaElement();
                    elt.type = 2;
                    elt.clazz = iClass;
                    elt.tag = tag;
                    elt.schema = this;
                } else {
                    elt = NO_ELT;
                }
            } else if (this.getMethod().isEnumeration(iClass)) {
                elt = new SchemaElement();
                elt.type = 1;
                elt.clazz = iClass;
                elt.tag = tag;
                elt.schema = this;
            } else if (this.getMethod().isSimpleType(iClass)) {
                elt = new SchemaElement();
                elt.type = 8;
                elt.clazz = iClass;
                elt.tag = tag;
                elt.schema = this;
            } else if (!this.getMethod().isXmlElement(iClass)) {
                elt = NO_ELT;
            } else {
                elt = new SchemaElement();
                elt.type = 4;
                elt.clazz = iClass;
                elt.tag = tag;
                elt.schema = this;
                ArrayList<ISchemaElement> substGroupElements = new ArrayList<ISchemaElement>();
                ArrayList<ISchemaElement> extendedElements = new ArrayList<ISchemaElement>();
                for (Class<?> cls = iClass; cls != Object.class && cls != null; cls = cls.getSuperclass()) {
                    ISchemaElement abstractClassElement;
                    if (!cls.equals(iClass) && (cls.getModifiers() & 0x400) != 0 && (abstractClassElement = this.manager.getElement(cls)) != null) {
                        extendedElements.add(abstractClassElement);
                        this.setUsedSchema(abstractClassElement.getSchema());
                    }
                    Class<?>[] itfs = cls.getInterfaces();
                    for (int i = 0; i < itfs.length; ++i) {
                        ISchemaElement itfElement;
                        if (!this.getMethod().isSubstitutionGroup(itfs[i]) || (itfElement = this.manager.getElement(itfs[i])) == null || substGroupElements.contains(itfElement)) continue;
                        substGroupElements.add(itfElement);
                        this.setUsedSchema(itfElement.getSchema());
                    }
                }
                if (substGroupElements.size() > 0) {
                    SchemaElement.access$502(elt, substGroupElements.toArray(ELTS_ARRAY_TYPE));
                } else if (extendedElements.size() > 0) {
                    SchemaElement.access$502(elt, extendedElements.toArray(ELTS_ARRAY_TYPE));
                }
                Class<?> superClass = iClass.getSuperclass();
                if (this.manageInheritance && superClass != Object.class) {
                    elt.superClass = this.manager.getElement(superClass);
                    if (elt.superClass != null) {
                        this.setUsedSchema(elt.superClass.getSchema());
                    }
                }
            }
            this.class2Infos.put(iClass, elt);
        }
        if (NO_ELT.equals(elt)) {
            return null;
        }
        return elt;
    }

    @Override
    public ISchema[] getUsedSchemas() {
        return this.usedSchemas.toArray(SCHEMAS_ARRAY_TYPE);
    }

    @Override
    public ISchemaElement[] getAllElements() {
        ArrayList<ISchemaElement> ret = new ArrayList<ISchemaElement>();
        for (ISchemaElement elt : this.class2Infos.values()) {
            if (NO_ELT.equals(elt)) continue;
            ret.add(elt);
        }
        return ret.toArray(ELTS_ARRAY_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildFromClassPath() {
        String packageEntryName = this.pkg.replace('.', '/') + "/";
        System.out.println("Building Schema for package: " + this.pkg + "...");
        Enumeration<URL> res = null;
        try {
            res = this.getClass().getClassLoader().getResources(packageEntryName);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (res == null) {
            System.out.println(" --> Directory " + packageEntryName + " not found in classpath.");
            return;
        }
        while (res.hasMoreElements()) {
            URL url = res.nextElement();
            if (url.getProtocol().equals("file")) {
                File packageDir = new File(URLDecoder.decode(url.getFile()));
                if (!packageDir.isDirectory()) continue;
                System.out.println(" --> Directory found: " + packageDir);
                int elts = this.buildFromFiles(packageDir, this.pkg, true);
                System.out.println("     (" + elts + " elements)");
                continue;
            }
            if (url.getProtocol().equals("jar") || url.getProtocol().equals("zip")) {
                String jarUrlStr = URLDecoder.decode(url.getFile());
                int idx = jarUrlStr.lastIndexOf(33);
                if (idx > 0) {
                    jarUrlStr = jarUrlStr.substring(0, idx);
                }
                System.out.println(" --> Jar found: " + jarUrlStr);
                int elts = 0;
                try {
                    URL jarUrl = new URL(jarUrlStr);
                    ZipInputStream zip = new ZipInputStream(jarUrl.openStream());
                    try {
                        ZipEntry entry = null;
                        while ((entry = zip.getNextEntry()) != null) {
                            if (!entry.isDirectory() && entry.getName().startsWith(packageEntryName) && entry.getName().endsWith(".class")) {
                                String className = entry.getName().substring(0, entry.getName().length() - 6).replace('/', '.');
                                try {
                                    Class<?> c = Class.forName(className, false, this.manager.getClassLoader());
                                    if (this.getElement(c) != null) {
                                        ++elts;
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println("Error while computing schema element for class '" + className + "'.");
                                    e.printStackTrace();
                                }
                            }
                            zip.closeEntry();
                        }
                    }
                    finally {
                        zip.close();
                    }
                    System.out.println("     (" + elts + " elements)");
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println(" --> Unsupported protocol: " + url);
        }
    }

    private int buildFromFiles(File packageDir, String iPackage, boolean iSearchClassFiles) {
        if (!packageDir.exists()) {
            return 0;
        }
        String[] names = packageDir.list();
        int processed = 0;
        for (int i = 0; i < names.length; ++i) {
            File f = new File(packageDir, names[i]);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                processed += this.buildFromFiles(new File(packageDir, names[i]), iPackage + "." + names[i], iSearchClassFiles);
                continue;
            }
            if (!names[i].endsWith(iSearchClassFiles ? ".class" : ".java")) continue;
            String className = iPackage + "." + names[i].substring(0, names[i].length() - (iSearchClassFiles ? 6 : 5));
            try {
                Class<?> c = Class.forName(className, false, this.manager.getClassLoader());
                if (this.getElement(c) == null) continue;
                ++processed;
                continue;
            }
            catch (Exception e) {
                System.out.println("Error while computing schema element for class '" + className + "'.");
                e.printStackTrace();
            }
        }
        return processed;
    }

    @Override
    public void generateXSD(Document iXmlDoc) {
        int i;
        ISchemaElement[] elements = this.getAllElements();
        Element schemaElt = iXmlDoc.createElement("xs:schema");
        schemaElt.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        schemaElt.setAttribute("xmlns", this.getNamespace());
        schemaElt.setAttribute("targetNamespace", this.getNamespace());
        ISchema[] imports = this.getUsedSchemas();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            schemaElt.setAttribute("xmlns:" + imports[i2].getName(), imports[i2].getNamespace());
            Element importNode = iXmlDoc.createElement("xs:import");
            importNode.setAttribute("schemaLocation", imports[i2].getLocator());
            importNode.setAttribute("namespace", imports[i2].getNamespace());
            schemaElt.appendChild(importNode);
        }
        iXmlDoc.appendChild(schemaElt);
        Element importTypeElt = iXmlDoc.createElement("xs:complexType");
        importTypeElt.setAttribute("name", "__import");
        this.addDocumentation(importTypeElt, "Path to the XML file to import.<br>The path must be relative to the origin XML (may not start with a '/').");
        Element importTypeAttr = iXmlDoc.createElement("xs:attribute");
        importTypeAttr.setAttribute("name", "File");
        importTypeAttr.setAttribute("type", "xs:string");
        importTypeAttr.setAttribute("use", "required");
        importTypeElt.appendChild(importTypeAttr);
        schemaElt.appendChild(importTypeElt);
        System.out.println("Declaring simple types...");
        for (i = 0; i < elements.length; ++i) {
            if (elements[i].getType() != 8) continue;
            Class<?> baseType = this.getMethod().getBaseSimpleType(elements[i].getMappedClass());
            String baseTypeXsd = XsdHelper.getSimpleType(baseType);
            if (baseTypeXsd == null) {
                System.out.println(" --> warning: class '" + elements[i].getMappedClass().getName() + "' has non-simple base type (" + baseType.getName() + ")");
                continue;
            }
            System.out.println(" --> simple type '" + elements[i].getTagName() + "' restricts: " + baseTypeXsd);
            Element typeElt = iXmlDoc.createElement("xs:simpleType");
            typeElt.setAttribute("name", elements[i].getTagName());
            this.addComponentDoc(typeElt, elements[i]);
            Element restrictionElt = iXmlDoc.createElement("xs:restriction");
            restrictionElt.setAttribute("base", "xs:" + baseTypeXsd);
            typeElt.appendChild(restrictionElt);
            schemaElt.appendChild(typeElt);
        }
        System.out.println("Declaring enumerated types...");
        for (i = 0; i < elements.length; ++i) {
            if (elements[i].getType() != 1) continue;
            int nbElts = this.getMethod().getNbOfEnumItems(elements[i].getMappedClass());
            System.out.println(" --> enumeration '" + elements[i].getTagName() + "': " + nbElts + " items");
            Element typeElt = iXmlDoc.createElement("xs:simpleType");
            typeElt.setAttribute("name", elements[i].getTagName());
            this.addComponentDoc(typeElt, elements[i]);
            Element restrictionElt = iXmlDoc.createElement("xs:restriction");
            restrictionElt.setAttribute("base", "xs:string");
            for (int j = 0; j < nbElts; ++j) {
                Element enumElt = iXmlDoc.createElement("xs:enumeration");
                String enumName = this.getMethod().getEnumItemName(elements[i].getMappedClass(), j);
                enumElt.setAttribute("value", enumName);
                restrictionElt.appendChild(enumElt);
                this.addEnumDoc(enumElt, elements[i], enumName);
            }
            typeElt.appendChild(restrictionElt);
            schemaElt.appendChild(typeElt);
        }
        System.out.println("Declaring substitution groups...");
        for (i = 0; i < elements.length; ++i) {
            if (elements[i].getType() != 2) continue;
            System.out.println(" --> interface '" + elements[i].getTagName() + "'");
            Element ifElt = iXmlDoc.createElement("xs:element");
            ifElt.setAttribute("name", elements[i].getTagName());
            ifElt.setAttribute("abstract", "true");
            schemaElt.appendChild(ifElt);
            this.addComponentDoc(ifElt, elements[i]);
            if (!this.getMethod().isImportable(elements[i].getMappedClass())) continue;
            Element importElt = iXmlDoc.createElement("xs:element");
            String importEltName = "Import_" + elements[i].getTagName();
            importElt.setAttribute("name", importEltName);
            importElt.setAttribute("substitutionGroup", elements[i].getTagName());
            importElt.setAttribute("type", "__import");
            schemaElt.appendChild(importElt);
        }
        System.out.println("Declaring elements and types...");
        for (i = 0; i < elements.length; ++i) {
            String simpleTypeName;
            FieldMapping fieldMapping;
            int j;
            ISchemaElement superType;
            if (elements[i].getType() != 4) continue;
            System.out.println(" --> element '" + elements[i].getTagName() + "' and type '_" + elements[i].getTagName() + "'");
            boolean isAbstract = (elements[i].getMappedClass().getModifiers() & 0x400) != 0;
            ElementMapping mappings = this.getMethod().getElementMappings(elements[i].getMappedClass(), !this.manageInheritance);
            for (int j2 = 0; j2 < mappings.getMappingErrors().length; ++j2) {
                System.err.println(mappings.getMappingErrors()[j2].getMessage());
            }
            FieldMapping[] contentMappings = mappings.getMappings(8);
            FieldMapping[] childMappings = mappings.getMappings(2);
            FieldMapping[] collectedMappings = mappings.getMappings(4);
            FieldMapping[] attrMappings = mappings.getMappings(1);
            boolean hasContentMappings = contentMappings.length > 0;
            Element typeElt = iXmlDoc.createElement("xs:complexType");
            schemaElt.appendChild(typeElt);
            typeElt.setAttribute("name", "_" + elements[i].getTagName());
            if (isAbstract) {
                typeElt.setAttribute("abstract", "true");
            }
            if (hasContentMappings) {
                typeElt.setAttribute("mixed", "true");
            }
            if ((superType = elements[i].getSuperType()) != null) {
                Element cc = iXmlDoc.createElement("xs:complexContent");
                typeElt.appendChild(cc);
                Element ext = iXmlDoc.createElement("xs:extension");
                ext.setAttribute("base", this.getPrefixAndTag(superType, true));
                cc.appendChild(ext);
                typeElt = ext;
            }
            Element sequence = null;
            for (j = 0; j < childMappings.length; ++j) {
                fieldMapping = childMappings[j];
                if (sequence == null) {
                    sequence = iXmlDoc.createElement("xs:sequence");
                    typeElt.appendChild(sequence);
                }
                Element eltNode = iXmlDoc.createElement("xs:element");
                eltNode.setAttribute("name", fieldMapping.getName());
                eltNode.setAttribute("minOccurs", fieldMapping.isUseRequired() ? "1" : "0");
                eltNode.setAttribute("maxOccurs", "1");
                sequence.appendChild(eltNode);
                this.addAttributeDoc(eltNode, fieldMapping);
                simpleTypeName = this.getSimpleTypeName(fieldMapping.getBaseClass());
                if (simpleTypeName != null) {
                    if (fieldMapping.getMaxOccurs() > 1) {
                        throw new UnsupportedMapping("Field  '" + fieldMapping.getName() + "' (from class " + elements[i].getMappedClass().getName() + ") has unsupported array of simple type: " + fieldMapping.getBaseClass().getName());
                    }
                    eltNode.setAttribute("type", simpleTypeName);
                    continue;
                }
                Element ctNode = iXmlDoc.createElement("xs:complexType");
                eltNode.appendChild(ctNode);
                Element seqNode = iXmlDoc.createElement("xs:sequence");
                ctNode.appendChild(seqNode);
                Element eltChild = iXmlDoc.createElement("xs:element");
                ISchemaElement ref = this.manager.getElement(fieldMapping.getBaseClass());
                if (ref == null) {
                    throw new UnsupportedMapping("Field  '" + fieldMapping.getName() + "' (from class " + elements[i].getMappedClass().getName() + ") has unsupported type: " + fieldMapping.getBaseClass().getName());
                }
                if (ref.getType() == 8) {
                    eltChild.setAttribute("type", this.getPrefixAndTag(ref, false));
                } else {
                    eltChild.setAttribute("ref", this.getPrefixAndTag(ref, false));
                }
                eltChild.setAttribute("minOccurs", String.valueOf(fieldMapping.getMinOccurs()));
                eltChild.setAttribute("maxOccurs", fieldMapping.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(fieldMapping.getMaxOccurs()));
                seqNode.appendChild(eltChild);
            }
            for (j = 0; j < collectedMappings.length; ++j) {
                fieldMapping = collectedMappings[j];
                if (sequence == null) {
                    sequence = iXmlDoc.createElement("xs:sequence");
                    typeElt.appendChild(sequence);
                }
                Element eltChild = iXmlDoc.createElement("xs:element");
                ISchemaElement ref = this.manager.getElement(fieldMapping.getBaseClass());
                if (ref == null) {
                    throw new UnsupportedMapping("Field  '" + fieldMapping.getName() + "' (from class " + elements[i].getMappedClass().getName() + ") has unsupported type: " + fieldMapping.getBaseClass().getName());
                }
                if (ref.getType() == 8) {
                    eltChild.setAttribute("type", this.getPrefixAndTag(ref, false));
                } else {
                    eltChild.setAttribute("ref", this.getPrefixAndTag(ref, false));
                }
                eltChild.setAttribute("minOccurs", String.valueOf(fieldMapping.getMinOccurs()));
                eltChild.setAttribute("maxOccurs", fieldMapping.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(fieldMapping.getMaxOccurs()));
                sequence.appendChild(eltChild);
                this.addAttributeDoc(eltChild, fieldMapping);
            }
            if (hasContentMappings && sequence == null) {
                sequence = iXmlDoc.createElement("xs:sequence");
                typeElt.appendChild(sequence);
                Element any = iXmlDoc.createElement("xs:any");
                any.setAttribute("minOccurs", "0");
                any.setAttribute("maxOccurs", "unbounded");
                sequence.appendChild(any);
            }
            for (int j3 = 0; j3 < attrMappings.length; ++j3) {
                fieldMapping = attrMappings[j3];
                Element attr = iXmlDoc.createElement("xs:attribute");
                attr.setAttribute("name", fieldMapping.getName());
                attr.setAttribute("use", fieldMapping.isUseRequired() ? "required" : "optional");
                typeElt.appendChild(attr);
                simpleTypeName = this.getSimpleTypeName(fieldMapping.getBaseClass());
                if (simpleTypeName != null) {
                    if (fieldMapping.getMaxOccurs() > 1) {
                        System.out.println("Array of simple type not supported: '" + fieldMapping.getName() + "' (" + fieldMapping.getBaseClass() + "[])");
                    } else {
                        attr.setAttribute("type", simpleTypeName);
                    }
                } else {
                    System.out.println("Unsupported attribute type: '" + fieldMapping.getBaseClass() + "'");
                }
                this.addAttributeDoc(attr, fieldMapping);
            }
            Element elt = iXmlDoc.createElement("xs:element");
            elt.setAttribute("name", elements[i].getTagName());
            elt.setAttribute("type", "_" + elements[i].getTagName());
            if (isAbstract) {
                elt.setAttribute("abstract", "true");
            }
            this.addComponentDoc(elt, elements[i]);
            ISchemaElement[] substGroups = elements[i].getSubstitutionGroups();
            if (substGroups != null && substGroups.length > 0) {
                if (substGroups.length > 1) {
                    System.out.println("     + warning: class '" + elements[i].getMappedClass().getName() + "' has more than one interfaces:");
                    for (int j4 = 0; j4 < substGroups.length; ++j4) {
                        System.out.println("        [" + j4 + "] " + substGroups[j4].getMappedClass().getName());
                    }
                    System.out.println("     + Only the first one will be declared as substitution group: " + substGroups[0].getMappedClass().getName());
                } else {
                    System.out.println("     + subst. group: " + substGroups[0].getMappedClass().getName());
                }
                elt.setAttribute("substitutionGroup", this.getPrefixAndTag(substGroups[0], false));
            }
            schemaElt.appendChild(elt);
        }
    }

    private boolean addComponentDoc(Element iElement, ISchemaElement iElt) {
        String doc = this.getMethod().getElementDetails(Locale.getDefault(), iElt.getMappedClass());
        if (doc == null) {
            return false;
        }
        this.addDocumentation(iElement, doc);
        return true;
    }

    private void addDocumentation(Element iElement, String text) {
        Element annotation = iElement.getOwnerDocument().createElement("xs:annotation");
        iElement.appendChild(annotation);
        Element documentation = iElement.getOwnerDocument().createElement("xs:documentation");
        annotation.appendChild(documentation);
        CDATASection cdata = iElement.getOwnerDocument().createCDATASection(text);
        documentation.appendChild(cdata);
    }

    private boolean addAttributeDoc(Element iElement, FieldMapping iMapping) {
        String doc = this.getMethod().getMappingDetails(Locale.getDefault(), iMapping);
        if (doc == null) {
            return false;
        }
        this.addDocumentation(iElement, doc);
        return true;
    }

    private boolean addEnumDoc(Element iElement, ISchemaElement iElt, String enulValueName) {
        String doc = this.getMethod().getEnumItemDetails(Locale.getDefault(), iElt.getMappedClass(), enulValueName);
        if (doc == null) {
            return false;
        }
        this.addDocumentation(iElement, doc);
        return true;
    }

    private String getSimpleTypeName(Class<?> type) {
        String simpleTypeName = XsdHelper.getSimpleType(type);
        if (simpleTypeName != null) {
            return "xs:" + simpleTypeName;
        }
        ISchemaElement ref = this.manager.getElement(type);
        if (ref == null) {
            return null;
        }
        if (ref.getType() == 1) {
            return this.getPrefixAndTag(ref, false);
        }
        if (ref.getType() == 8) {
            return this.getPrefixAndTag(ref, false);
        }
        return null;
    }

    private String getPrefixAndTag(ISchemaElement iElt, boolean iAsType) {
        if (iAsType && iElt.getType() == 4) {
            if (iElt.getSchema() == this || iElt.getSchema().getName() == null) {
                return "_" + iElt.getTagName();
            }
            return iElt.getSchema().getName() + ":_" + iElt.getTagName();
        }
        if (iElt.getSchema() == this || iElt.getSchema().getName() == null) {
            return iElt.getTagName();
        }
        return iElt.getSchema().getName() + ":" + iElt.getTagName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SchemaElement
    implements ISchemaElement {
        private Class<?> clazz;
        private int type;
        private String tag;
        private ISchema schema;
        private ISchemaElement[] substitutionGroups;
        private ISchemaElement superClass;

        private SchemaElement() {
        }

        @Override
        public Class<?> getMappedClass() {
            return this.clazz;
        }

        @Override
        public ISchema getSchema() {
            return this.schema;
        }

        @Override
        public ISchemaElement[] getSubstitutionGroups() {
            return this.substitutionGroups;
        }

        @Override
        public ISchemaElement getSuperType() {
            return this.superClass;
        }

        @Override
        public String getTagName() {
            return this.tag;
        }

        @Override
        public int getType() {
            return this.type;
        }

        public String toString() {
            return "SchemaElement[" + (this.type == 4 ? "ELT" : (this.type == 1 ? "ENUM" : "INTERF")) + ":" + this.getMappedClass().getName() + "]";
        }

        static /* synthetic */ ISchemaElement[] access$502(SchemaElement x0, ISchemaElement[] x1) {
            x0.substitutionGroups = x1;
            return x1;
        }
    }
}

